*	Function Name:	DosToNet()
*	Parameters:		cFileSpec, file spec to convert to NetWare spec
*
*
*	Description
*
*	The purpose of this function is to convert a DOS file spec to a NetWare file spec.
*	if no drive or path is specified, the default drive/directory is used for the 
*	conversion
*
Parameter cFileSpec
Private cPath, cDrive, cName, cAnswer, c, cTemp

cFileSpec=upper(alltrim(cFileSpec))

cPath=path(cFileSpec)
if empty(cPath)
	cDrive=left(sys(5),1)
	cPath=substr(sys(2003),2)+'\'  && Get default
else
	cDrive=left(cPath,1) && Get the drive letter
	if len(cPath)>2
		cPath=substr(cPath,3) && Trim the drive letter off cPath
	else
		cPath=''
	endif
endif

cName=Name(cFileSpec)
cExt=ext(cFileSpec)
cAnswer=cDrive+':'+cPath+cName+'.'+cExt
if !empty(n_ShellVer())
	if empty(N_DrvPath(cDrive))
		* Nothing
	else
		c=N_DrvPath(cDrive)
		IF EMPTY(cPath)
			cPath=substr(c,at(':',c)+1)+'\'
		else
			do case
			case N_DrvDepth(cDrive)=255 
				
			case N_DrvDepth(cDrive)==0
				cPath=substr(c,at(':',c)+1)+cPath
			otherwise
				cTemp=substr(c,at(':',c)+1)+'\'
				cTemp=left(cTemp,rat('/',cTemp,N_DrvDepth(cDrive))-1)
				cPath=cTemp+cPath
			endcase
		endif
		if left(cPath,1)='\'
			cPath=substr(cPath,2)
		endif
		cAnswer = left(c,at(':',c))+cPath+cName+'.'+cExt
	endif
endif
return cAnswer

	