
**************************************
* Program........: GENVIEW.prg
* Author.........: Jim Carroll, City of Topeka User Services
* Date created...: Thu  03-01-1990
* Date modified..:
* Notes..........: Generic file viewer. Needs following parameters:
*                     FMT - name of format file to be used
*                    PICT - picture format for entering search key
*                     KEY - .T. if numeric, .F. if character
*                    LOOK - .T. if viewing file, .F. if editing
*                  Database and tag should be selected before calling, i.e.
*                     USE MYFILE IN A ORDER TAG DOGTAG
*                     SELE A
*                     DO GENVIEW WITH 'DOG', '"999999.99"', .T., .T.
*                  Note that picture statement must be doubly delimited, i.e.
*                  enclosed in quotes which are themselves enclosed in quotes.
* Files used.....: Any you want (see above)

PROC GenView
PARA FMT, PICT, KEY, LOOK
PRIVATE SEARCHKEY, MESS1, MESS2, MESS3
STOR 'Enter the item you want to look for: ' TO MESS1
STOR 'THIS ITEM DOES NOT EXIST - TRY AGAIN!' TO MESS2
STOR 'Do you want to look for another item? ' TO MESS3
DO WHILE .T.
   CLEA
   STOR ' ' TO OPTION               && OPTION controls looping
   IF Key                           && If the key is numeric,
      STORE 0 TO SearchKey          && create a numeric variable
   ELSE                             && otherwise,
      STORE SPACE(11) TO SearchKey  && make it a character variable.
   ENDIF
   @ 10, 40-(LEN(MESS1)/2) SAY MESS1 GET SearchKey PICTURE &PICT
   READ
   DO CASE                                && diff. actions if numeric or char
      CASE KEY                            && if numeric
         IF SearchKey = 0                 && if no number entered,
            EXIT                          && leave this proc.
         ENDIF
      CASE .NOT. KEY                      && if character
         IF LEN(TRIM(SearchKey)) = 0      && and nothing was entered
            EXIT                          && leave
         ENDIF
   ENDCASE
   SEEK SearchKey
   IF EOF()                               && if SearchKey not found,
      @ 12, 40-(LEN(MESS2)/2) SAY MESS2   && say error message,
      ?
      WAIT
      LOOP                                && and start over.
   ELSE
      SET FORM TO (FMT)                   && otherwise, use format file
      IF LOOK                             && () is an indirect ref. to a file
         EDIT NOMENU NOEDIT NOCLEAR       && if viewing, use this
      ELSE                                && otherwise
         EDIT NOMENU NOCLEAR              && permit editing
      ENDIF
      SET FORM TO                         && close format file
      @ 24, 1                             && clears this line
      @ 24, 40-(LEN(MESS3)/2) SAY MESS3 GET OPTION PICTURE '!'
      READ
      IF OPTION <> 'Y'
         EXIT
      ENDIF
      CLEA GETS
   ENDIF
ENDDO
CLEAR
RETURN
