* Program ...: Genio.PRG
* Author ....: Rodney Barbati
* Date ......: September 1, 1987
* Version....: dBASE III PLUS
* Note(s)....: Front end for generic import and export utilities.

IF "" = DBF()
   ? "No Database in use, ending program..."
   RETURN
ENDIF

SET TALK OFF
SET ECHO OFF
SET BELL OFF
SET SCOREBOARD OFF
SET STATUS OFF
SET PROCEDURE TO Genio
ON ESCAPE DO Chk_quit
*
PUBLIC done

CLEAR
@  1,  2 TO  3, 78 DOUBLE
@  2, 20 SAY "G E N E R I C   E X P O R T  /  I M P O R T"
@  5,  2 TO 22, 78 DOUBLE
@  6, 57 TO 17, 69
@  5, 13 SAY " Enter the characters or ASCII codes for the following: "
STORE .F. TO finished, done
*
* ---Repeat until delimiters are OK.
DO WHILE .NOT. finished
   @  7, 58 CLEAR TO 16, 68
   STORE SPACE(3) TO m_fldbeg, m_fldend, m_fdelim, m_rdelim
   m_inout = SPACE(1)
   STORE .T. TO m_crlf, m_fixedf, m_lastfld, m_onscreen
   m_file = SPACE(65)
   @  7, 10 SAY "Beginning field delimiter :";
            GET m_fldbeg
   @  8, 10 SAY "Ending field delimiter    :";
            GET m_fldend
   @  9, 10 SAY "Field separator           :";
            GET m_fdelim
   @ 10, 10 SAY "Record delimiter          :";
            GET m_rdelim
   @ 12, 10 SAY "Fld. delim. on last field :";
            GET m_lastfld;
            PICTURE "Y"
   @ 13, 10 SAY "Fixed length fields       :";
            GET m_fixedf;
            PICTURE "Y"
   @ 14, 10 SAY "CR + LF between Records   :";
            GET m_crlf;
            PICTURE "Y"
   @ 16, 10 SAY "Import or Export (I/E)    :";
            GET m_inout;
            PICTURE "!"
   @ 18, 10 CLEAR TO 19, 70
   @ 18, 10 SAY "File Name                 :";
            GET m_file;
            PICTURE "@S19"
   READ
   IF m_inout = "I" .AND. READKEY() <> 12
      STORE 0 TO m_len, m_numfields
      @ 18, 10 CLEAR TO 19, 70
      @ 18, 57 SAY "Import File:"
      @ 19, 57 SAY LEFT(m_file, 12)
      @ 18, 10 SAY "Maximum record length      :";
               GET m_len
      @ 19, 10 SAY "Number of fields           :";
               GET m_numfields
      READ
   ENDIF
   IF READKEY() = 12
      DO Chk_quit
      IF done
         CLEAR
         ON ESCAPE
       RELEASE done
       CLOSE PROCEDURE
         RETURN
      ENDIF
   ENDIF
   *
   * ---Store either the entered delimiter or its CHR() equivalent.
   STORE IIF(VAL(m_fldbeg) > 0, CHR(VAL(m_fldbeg)), TRIM(m_fldbeg)) TO m_fldbeg
   STORE IIF(VAL(m_fldend) > 0, CHR(VAL(m_fldend)), TRIM(m_fldend)) TO m_fldend
   STORE IIF(VAL(m_fdelim) > 0, CHR(VAL(m_fdelim)), TRIM(m_fdelim)) TO m_fdelim
   STORE IIF(VAL(m_rdelim) > 0, CHR(VAL(m_rdelim)), TRIM(m_rdelim)) TO m_rdelim
   *
   * ---Display the chosen delimiters.
   @  7, 59 SAY m_fldbeg
   @  8, 59 SAY m_fldend
   @  9, 59 SAY IIF(upper(m_fdelim) = "CR", "CR + LF", IIF(m_fdelim = CHR(32), "Space", m_fdelim))
   @ 10, 59 SAY IIF(upper(m_rdelim) = "CR", "CR + LF", IIF(m_rdelim = CHR(32), "Space", m_rdelim))
   @ 12, 59 SAY IIF(m_lastfld, "Yes", "No")
   @ 13, 59 SAY IIF(m_fixedf, "Yes", "No")
   @ 14, 59 SAY IIF(m_crlf, "Yes", "No")
   @ 16, 59 SAY IIF(m_inout = "I", "Import", "Export")
   *
   @ 24,  0 SAY "Are these OK? (Y/N):";
            GET finished;
            PICTURE "Y"
   READ
   @ 24,  0
ENDDO
*
IF m_inout = "E"
   getquery = .F.
   @ 24,  0 SAY "Do you want to select matching records for Export? (Y/N):";
            GET getquery;
            PICTURE "Y"
   READ
   @ 24,  0 CLEAR
   IF getquery
      CREATE QUERY Temp
   ENDIF
   @ 24,  0 SAY "Do you wish to see the work in progress onscreen?";
            GET m_onscreen;
            PICTURE "Y"
   READ
   @ 24,  0 CLEAR
   IF .NOT. m_onscreen
      SET CONSOLE OFF
   ENDIF
   DO EXPORT WITH m_fldbeg, m_fldend, m_fdelim, m_rdelim, m_lastfld, m_fixedf, m_crlf, m_file
ELSE
   DO IMPORT WITH m_fldbeg, m_fldend, m_fdelim, m_rdelim, m_crlf, m_file, m_len, m_numfields
ENDIF
CLOSE PROCEDURE
ON ESCAPE
RELEASE done
SET CONSOLE ON
@ 24,  0 CLEAR
@ 24,  0 SAY IIF(m_inout = "I", "Import", "Export") + " is completed..."
RETURN
* EOP Genio

PROCEDURE Chk_quit
* ---Allow user to interrupt export.
row = ROW()
col = COL()
@ 24,  0 CLEAR
@ 24,  0 SAY "Cancel the Program?";
         GET done;
         PICTURE "Y"
READ
@ 24,  0
@ row, col SAY SPACE(0)
RETURN
* ---EOP Chk_quit
