* Program ...: Export.PRG
* Author ....: Rodney Barbati
* Date ......: September 1, 1987
* Version....: dBASE III PLUS
* Note(s)....: Program for generic export of data fields.  It does not 
*              handle memo fields, but does allow the calling program
*              to specify the field beginning and ending delimiters,
*              field separators, record separators, if CR/LF's are
*              to be put between records, and if the fields are to be
*              TRIMmed or not.  
*
*              If only certain fields are to be COPYed, use the 
*              SET FIELDS TO... command before running this program.
*     
*              The program is called with the following syntax:
*    
*                 DO Export WITH <begin>, <end>, <separator>,
*                                <record separator>, <last field>,    
*                                <fixed width>, <crlf>, <filename>
*
*                 begin            ::= field beginning character
*                 end              ::= field ending character
*                 separator        ::= field separating character
*                 record separator ::= record separating character
*                 last field       ::= delimiters on last field/record?
*                 fixed width      ::= are fields trimmed or not?
*                 crlf             ::= are CR/LF's placed between records?
*                 filename         ::= name of output file
*
*              Note: Although dBASE does TRIM numeric fields to the declared
*              field width when COPYing to text files using the SDF and 
*              DELIMITED options, Export.PRG does not.
*
PARAMETERS m_beg, m_end, m_feld, m_rec, m_lastfld, m_fixed, m_crlf, m_file

SET ECHO OFF
SET TALK OFF
GO TOP
CLEAR
*
* ---Open the output file.
SET ALTERNATE TO &m_file
SET ALTERNATE ON
*
* ---The global variable "done" allows the user to stop the export.
* ---See Genio.PRG for an example of this.
done = .F.
numfields = 0
DO WHILE "" <> FIELD(numfields+1)
   numfields = numfields + 1
ENDDO
DO WHILE .NOT. (done .OR. EOF())
   * ---Loop through all the fields, looking for a NULL fieldname.
   counter = 1
   DO WHILE counter <= numfields
      * ---Store away the field name.
      temp = FIELD(counter)
      * ---Skip memo fields, just like dBASE' COPY TO...
      IF TYPE(temp) <> "M"
         ?? m_beg
         DO CASE
         CASE TYPE(temp) = "N"
            ?? STR(&temp, IIF(m_fixed, LEN(STR(&temp)),;
               LEN(LTRIM(STR(&temp)))))
         CASE TYPE(temp) = "C"
            ?? IIF(m_fixed, &temp, TRIM(&temp))
         CASE TYPE(temp) = "D"
            ?? DTOC(&temp)
         CASE TYPE(temp) = "L"
            ?? IIF(&temp, "T", "F")
         ENDCASE
         IF (counter <> numfields) .OR. (counter = numfields .AND. m_lastfld)
            ?? TRIM(m_end)
         ENDIF
      ENDIF
      counter = counter + 1
      * ---If not at last field and not a memo field, print field delimiter.
      IF "" <> FIELD(counter) .AND. TYPE(temp) <> "M"
         IF upper(m_feld) = "CR"
            ?
         ELSE
            ?? m_feld
         ENDIF
      ENDIF
   ENDDO
   * ---Print record separator if needed.
   IF upper(m_rec) = "CR"
      ?
   ELSE
      ?? m_rec
   ENDIF
   SKIP +1
   * ---Print carriage return/line feed if necessary.
   IF m_crlf .AND. (m_lastfld .OR. .NOT. (m_lastfld .OR. EOF()))
      ?
   ENDIF
ENDDO
ON ESCAPE
CLOSE ALTERNATE
CLOSE PROCEDURE
CLEAR
RETURN
* ---EOP Export
