* Program: GENFIX.PRG
*  Notice: Placed in the Public Domain on May 8, 1994.
*  Author: Tom Rettig
*        : Rettig Micro Corporation
*        : 2532 Lincoln Boulevard, Suite 110
*        : Marina del Rey, CA  90291-5978
*        :  Telephone: 310-301-0911
*        :        FAX: 310-821-1162
*        : CompuServe: 75066,352
*        :           : in FOXFORUM 3rd-Party section or MAIL
*  Action: Fixes GENSCRN.PRG bug in FoxPro 2.6 DOS and Windows.
*  Syntax: DO GENFIX
* Version: 1.00a
*  Update: May 11, 1994
*   Notes: Saves the original GenScrn.PRG as GenScrn.PR_ in
*        :    the executing FoxPro directory.  Can be stored
*        :    anywhere and run from anywhere.
*        : Makes only one change in 2 procedures, WriteCode
*        :    and WriteLine, to include #undef and #elif
*        :    directives that should be written to the SPR.
*        : Requires FoxPro version 2.6 for DOS or Windows and
*        :    fixes only the GenScrn in the executing FP dir.
*

* Translated text must not split between two blocks this size.
#define cREADBYTES  64000

IF NOT ((_DOS OR _WINDOWS) AND;
        (" 2.6 "$VERSION() OR RIGHT(VERSION(),4)==" 2.6"))
   WAIT WINDOW NOWAIT "GenFix is valid only in FoxPro version 2.6"+;
                      " for DOS or Windows"
   RETURN
ENDIF

SET TALK OFF

file_in = SYS(2004)+"GENSCRN.PRG"
WAIT WINDOW NOWAIT "GenFix fixing "+m.file_in

file_out = SYS(2004)+SYS(3)+".TMP"
file_bak = SYS(2004)+"GENSCRN.PR_"
is_changed = .F.

handle_in  = FOPEN(m.file_in)
IF m.handle_in==0
   message = "File not found: "+m.file_in
ELSE
   ERASE (m.file_out)
   handle_out = FCREATE(m.file_out)
   IF m.handle_out==0
      message = "Cannot create: "+m.file_out
   ELSE
      DO WHILE NOT FEOF(m.handle_in)
         string = FREAD(m.handle_in, cREADBYTES)
         IF '"#INCLUDE"'$m.string AND NOT;
               '"#INCLUDE" OR LEFT(m.upline,5)$"#UNDE#ELIF"'$m.string
            string =;
               STRTRAN(m.string, '"#INCLUDE"',;
                       '"#INCLUDE" OR LEFT(m.upline,5)$"#UNDE#ELIF"')
            is_changed = .T.
         ENDIF
         =FWRITE(m.handle_out, m.string)
      ENDDO
   ENDIF
   =FCLOSE(m.handle_in)
   IF m.handle_out>0
      =FCLOSE(m.handle_out)
      DO CASE
         CASE FERROR()>0
            message = "Error writing new GenScrn -- "+;
                      "Fix unsuccessful"
         CASE m.is_changed
            ERASE (m.file_bak)
            RENAME (m.file_in)  TO (m.file_bak)
            RENAME (m.file_out) TO (m.file_in)
            message = "GenFix successful -- "+;
                      "Original file saved as: "+m.file_bak
         OTHERWISE
            ERASE (m.file_out)
            message = "GenFix was previously applied -- "+;
                      "No change necessary"
      ENDCASE
   ENDIF
ENDIF
WAIT WINDOW NOWAIT m.message
SET TALK ON
RETURN
*** genfix.prg **********************************************
