* Program..: GENPRG.PRG
* Author...: John M. Bauman
* Date.....: March 16, 1989
*
* Notes....: This is half of a set.  GENPRG generates a
*            PRG file, which will recreate a DBF from
*            within an application.  This module is
*            intended to be run as a "stand alone" to
*            generate code modules that may be added to
*            your programs. The modules are standard PRG
*            files, created by GENPRG but to work properly,
*            the modules require that GENDBF.PRG/FOX
*            be included in the main procedure file or at
*            least in the current directory when the
*            the modules are run.
**********************************************************
* set up:

SET ECHO OFF
SET TALK OFF
SET SAFE OFF
SET SCORE OFF
SET STAT OFF
SET BELL OFF
SET CONF ON
SET ESCAPE OFF

SET COLOR TO W+/B,N/W,B
CLEAR

* main loop:

DO WHILE .T.
   STORE SPACE(8) TO DBF, OUTFILE

   @ 0,37 SAY "GENPRG"
   @ 2,12 SAY "Create .PRG files to generate your .DBF's"+;
   " from scratch!"

   @ 3,0 TO 3,79 DOUBLE
   @ 23,0 TO 23,79 DOUBLE

   @ 12,15 SAY "Enter .dbf file to use, no extension:"
   @ 12,54 GET DBF PICTURE "!!!!!!!!"

   @ 14,15 SAY "Enter name for output file          :"
   @ 14,54 GET OUTFILE PICTURE "!!!!!!!!"

   @ 20,10 SAY "Leave either or both entries blank and"+;
   " press <ENTER> to quit"



   READ

   DBF     = LTRIM(TRIM(DBF))
   OUTFILE = LTRIM(TRIM(OUTFILE))

   IF LEN(DBF) = 0 .OR. LEN(OUTFILE) = 0
      EXIT
   ENDIF

   * Take away the blanks/add the extension:

   IF AT(" ",OUTFILE) <> 0
      OUTFILE = SPACE(8)
      LOOP
   ENDIF

   OUTFILE  = OUTFILE + ".PRG"
   STRUFILE = DBF
   DBF      = DBF + ".DBF"

   CLEAR

   * Okay, see if it's there:

   IF FILE("&DBF")
      USE &DBF
   ELSE
      @ 16,10 SAY DBF + " Doesn't exist..."
      WAIT
      DBF = SPACE(8)
      CLEAR
      LOOP
   ENDIF

   * Something to hold their attention for a sec:

   @ 10,10 SAY "Now creating " + TRIM(OUTFILE) + " ..."

   *------------------------------------------------
   *  Use COPY STRU EXTE command to create FLD
   *  file, which is DBF whose records equals the
   *  field names of the parent.dbf
   *------------------------------------------------

   STRUFILE = STRUFILE + ".FLD"
   COPY STRU EXTE TO &STRUFILE
   USE &STRUFILE

   *--------------------------------------------
   *            CREATE THE OUTPUT FILE
   *--------------------------------------------

   * Set alte commands to write the file to disk for us:

   SET ALTERNATE TO &OUTFILE
   SET ALTERNATE ON
   SET CONSOLE OFF

   * Header info for file:

   ?? "* " + OUTFILE + ":  This program generates code"+;
   " to produce " + DBF

   ? "* created:  " + DTOC(DATE()) + " using GENPRG by"+;
   " John"+ " M. Bauman"

   ? "* requires:  GENDBF.PRG/FOX to be included with"+;
   " the final program."


   ? "* make sure we have a file to work with:"
   ?
   ? 'IF .NOT. FILE("EXTEFILE.DBF")'
   ? "   DO GENDBF"
   ? "ENDIF"
   ?
   ? "USE EXTEFILE"
   ? "ZAP"
   ?

   GO TOP
   DO WHILE .NOT. EOF()

      ? "* " + TRIM(FIELD_NAME) + ":"

      ? "APPEND BLANK"

      ? 'REPLACE FIELD_NAME WITH '+ '"' +;
      TRIM(FIELD_NAME)+ '"' + "," + " FIELD_TYPE WITH ";
      + '"'+ TRIM(FIELD_TYPE) + '"'

      ? "REPLACE FIELD_LEN WITH " +;
       TRIM(LTRIM(STR(FIELD_LEN)))+ "," + " FIELD_DEC";
      + " WITH "+ TRIM(LTRIM(STR(FIELD_DEC)))
      ?
      SKIP +1
   ENDDO

   ? "CREATE " + DBF + " FROM EXTEFILE.DBF"
   ? "USE"
   ? "RETURN"
   ? "* eof() " + OUTFILE

   SET ALTERNATE OFF
   SET ALTERNATE TO
   SET CONSOLE ON

   @ 10,10 SAY "File " + TRIM(OUTFILE) + " created..."
   @ 12,10 SAY "Remember, " + TRIM(OUTFILE) + " requires"+;
   " GENDBF.PRG to work..."
   WAIT
   CLEAR
   USE

ENDDO while .t.

* clean up:

SET CONSOLE OFF

IF FILE("&STRUFILE")
   ! DEL *.FLD > NUL
ENDIF

IF FILE("EXTEFILE.DBF")
   ! DEL EXTEFILE.DBF > NUL
ENDIF

SET CONSOLE ON

CLEAR
RETURN
* eof() GENPRG.PRG
