# dos 2.5 makefile for NPPC.PLB

PLBNAME = nppc
MODEL = L
ADDOBJ = 
WATDIR = d:\watcom		# where the WATCOM is installed
FOXDIR = d:\foxlck25	# location of FoxPro API
						# libraries,  API_m.OBJ files, and PRO_EXT.H

PLBLNK = $(PLBNAME).lnk

CFLAGS = /ol /of /s /m$(MODEL) /zu /fpc /i=$(FOXDIR);$(WATDIR)\h
#
#   /ol       optimizations (optional)
#   /of 	  entry code
#   /s		  suppress stack checking (optional)
#   /zu 	  SS != DS
#   /fpc	  use floating point calls
#
$(PLBNAME).plb : $(PLBNAME).OBJ $(PLBLNK)
	set path=$(WATDIR)\bin;$(WATDIR)\binb;%PATH%
	set watcom=$(WATDIR)
	wlink @$(PLBLNK)
	wc2ms < $(PLBNAME).wat > $(PLBNAME).map
#
#   Build linker response file
#
$(PLBLNK) : $(PLBNAME).mak
	set path=$(WATDIR)\bin;$(WATDIR)\binb;%PATH%
	set watcom=$(WATDIR)
	%create $(PLBLNK)
	@%append $(PLBLNK) option verbose
	@%append $(PLBLNK) debug all
	@%append $(PLBLNK) file $(FOXDIR)\api_$(MODEL), $(PLBNAME)
	@%append $(PLBLNK) lib $(FOXDIR)\proapi_$(MODEL).lib
	@%append $(PLBLNK) lib nppcn.lib
	@%append $(PLBLNK) lib $(WATDIR)\lib286\dos\clib$(MODEL)
	@%append $(PLBLNK) lib $(WATDIR)\lib286\math$(MODEL)
	@%append $(PLBLNK) option map=$(PLBNAME).wat
	@%append $(PLBLNK) option symfile=$(PLBNAME).sym
	@%append $(PLBLNK) name $(PLBNAME).plb

.c.obj : $(PLBNAME).c $(PLBNAME).mak
	set path=$(WATDIR)\bin;$(WATDIR)\binb;%PATH%
	set watcom=$(WATDIR)
	wcc $(CFLAGS) -dDEBUG $[*

