* fullfeat.prg
* add, edit, and delete in a BROWSE 
USE customer
INDEX on cust_id to custid
SET INDEX to custid
SET DELETED off
ON KEY LABEL f2 DO addcust && add record
ON KEY LABEL f3 DO delcust && delete record
ON KEY LABEL F10 DO killer && finish session
DEFINE WINDOW fullfeat from 2,10 to 15,75 ;
       shadow float close grow 

BROWSE FIELDS cust_id :r:H="ID",;
       company :10:H="Company Name",;
       contact :10,;
       taxrate,;
       state :2:H="ST":P="!!",;
       status=iif(deleted(),"DELETED",""):7,;
       recno=recno():5 ;
       WINDOW fullfeat NOAPPEND NOMENU ;
       NODELETE TITLE "Full Featured"

IF wexist('killer')
  RELEASE WINDOW killer
ENDIF killer window was created
ON KEY LABEL f2  && deactivate hot key
ON KEY LABEL f10  && deactivate hot key
ON KEY LABEL f3  && deactivate hot key
RETURN
* eop fullfeat

PROCEDURE killer
* kills BROWSE by leaving a window on top
DEFINE WINDOW killer from 1,0 to 1,1 none
ACTIVATE WINDOW killer
RETURN
* eop killer

PROCEDURE delcust
* deletes or recalls current window
IF DELETED()
  RECALL
ELSE
  DELETE
ENDIF
DO refresh  && refresh BROWSE window
RETURN
* eop delcust
 
PROCEDURE addcust
* adds one record to customer
DEFINE WINDOW addcust from 19,20 to 24,60 ;
       title "Add cust" shadow float 
ACTIVATE WINDOW addcust TOP
@@ 1,0 SAY "New id: "
newid = cust_id
@@ 1,10 GET newid PICTURE "######"
READ
SEEK newid
IF !FOUND()
  APPEND BLANK
  REPLACE cust_id WITH newid
ENDIF
RELEASE WINDOW addcust
RETURN
* eop addcust

