comment /
FSIZE.ASM --  get size of any file (or group of files that conforms to
              a wildcard).  Requires dBASE III Plus or DR.  Disk space
              occupied is returned in Bytes if less than 65536 (with
              leading "B"), otherwise in Kbytes rounded DOWN! (no leading
              letter).  Yes, it's true, I still haven't figured out how
              to convert those doubleword sizes, that's why it comes back
              in "K".  When I figure it out, I'll probably charge for it.
syntax:
load fsize
memvar=spac(8)+"c:\mydir\*.*"    && will give space on drive c:, dir \mydir
call fsize with memvar

returns:
"E       c:\mydir\*.*"     && no files found or drive not ready  (ERROR)
"B   999 c:\mydir\*.*"     && exactly 999 bytes in files
"    999 c:\mydir\*.*"     && 999*1024 bytes in files
                           && (at least, amount smaller than 1K disregarded)

I leave the breaking up of the string, testing for error, etc. to you.

*************************** WARNING ***************************

The fact that this stuff is free means something, namely that it's not
ready for sale.  Experimental version!!!  All suggestions & complaints
are welcome, but no guarantees are made!  If I take a suggestion from
you and incorporate it, I will send you the updated code for free if &
when I do update it (regardless of whether it is part of a for-sale type
package).
R. Russell Freeland (Synergy Corp.)
voice: 305-792-1866
Compuserve 76146,371

History:
6-4-1986  first version
6-21-1986 fixed so that (hopefully) it won't trash other data in dBASE's
          memvar space



I used code from FIND.ASM to create this.

      Author:         Ross Nelson
                      10 November 1983
      Modified:       Tony Movshon
                      8 August 1984

/


CODESEG SEGMENT BYTE PUBLIC 'CODE'

FILESIZE  PROC FAR
       ORG      0
       ASSUME   CS:CODESEG,DS:codeseg


BEGIN:
       push     cs                      ;gotta use es as pointer to data,
       pop      es                      ;otherwise trashes dBASE data
       mov      byte ptr [bx],' '       ;not sure why, but garbage creeps in
                                        ;otherwise for some reason
       xor      bp,bp                   ;use BP for the low word accumulator
       xor      si,si                   ;and si for the highword
       call     find1st                 ;find first matching file
       cmp      ax,0                    ;did we?
       ja       next                    ;OK, add and find next
       mov      byte ptr [bx],'E'       ;error
       jmp      finish                  ;so return
next:  ;if match is found
       add      si,es:fsizeh            ;add to the accumlators
       add      bp,es:fsizel
       jnc      skip                    ;no carry, skip next statement
       inc      si                      ;carry, add it to hiword
skip:
       call findnext                    ;find next match
       cmp      ax,0                    ;see if we did
       jne      next                    ;yeah, try again

       mov      dx,si                   ;now move accumulators to where
       mov      ax,bp                   ;it's easier to work with them
checksize:
        cmp     dx,0                    ;is the highword empty?
        jg      Kbytes                  ;calculate in Kbytes, it's big enough
        mov     byte ptr [bx],'B'       ;signify bytes inst. of Kbytes
        jmp     Bytes

Kbytes:
        mov     si,1024d                ;let's get it in "K"
        div     si
        xor     dx,dx                   ;clear the remainder

Bytes:
        ;-----------now convert number to an ASCII string
        mov     cx,bx
        add     bx,7                    ;we'll do it backwards
        mov     si,10                   ;prepare to divide by 10
        inc     cx
nexdgt: div     si                      ;divide dx:ax by si
        or      dx,30H                  ;convert remainder to ASCII digit
        dec     bx                      ;backup in string
        mov     [bx],dl                 ;store character
        xor     dx,dx                   ;clear remainder
        or      ax,ax                   ;all done?
        jnz     nexdgt                  ;do next digit
spaces:
        cmp     cx,bx                   ;digits left?
        je      finish                  ;no, finished
        dec     bx                      ;backup
        mov     byte ptr [bx],' '       ;put in a space
        jmp     spaces                  ;check again
finish:


RET
;--------------data goes here, hopefully out of dBASE's way

dta:
reserved   db  21 dup (?)
attribute  db  ?
time       dw  0
date       dw  0
fsizel     dw  0                        ;loword of the file size
fsizeh     dw  0                        ;hiword
name_ext   db  13 dup(?)

FILESIZE  ENDP

FIND1ST         PROC    NEAR

        mov     dx, offset es:DTA       ;point to info block
        push    ds                      ;setup ds as cs to point to our data
        push    cs
        pop     ds
        mov     ah, 1Ah                 ;request new DTA
        int     21h                     ;from MSDOS
        pop     ds                      ;get back dBASE ds
        mov     dx,bx                   ;filename to find
        add     dx,8                    ;where the filespec is
        mov     cx,39                   ;with these attributes
        mov     ah, 4Eh                 ;request search
        int     21h                     ;of DOS
        mov     ax,0                    ;assume failure
        jc      DONE                    ;if CY, no match
        inc     ax                      ;else success
DONE:
                ret
FIND1ST         ENDP

FINDNEXT        PROC    NEAR

        mov     dx, offset es:dta       ;point to info block
        push    ds                      ;setup ds as cs to point to our data
        push    cs
        pop     ds
        mov     ah, 1Ah                 ;request new DTA
        int     21h                     ;from MSDOS
        mov     ah, 4Fh                 ;request search
        int     21h                     ;of DOS
        pop     ds                      ;get back dBASE ds
        mov     ax, 0                   ;assume 0 (failure)
        jc      QUIT                    ;if CY, no match
        inc     ax                      ;else TRUE (success)
QUIT:
                ret

FINDNEXT        ENDP

CODESEG ENDS
        END

