*-SCX Objtypes
#DEFINE cnheader		1
#DEFINE cntext			5
#DEFINE cnline			6
#DEFINE cnbox			7
#DEFINE cnlist			11
#DEFINE cnpushbutton	12
#DEFINE cnradiobutton	13
#DEFINE cncheckbox		14
#DEFINE cnsayget		15
#DEFINE cnpopup			16
#DEFINE cnpicture		17
#DEFINE cnspinner		22
#DEFINE cninvbutton
#DEFINE cnexpression	0
#DEFINE cnprocedure		1
#DEFINE cngetcode		1
#DEFINE ccnull		CHR(0)
#DEFINE cnNormalWt	0
#DEFINE cnBoldWt	1

#DEFINE cfsSay 1
#DEFINE cfsGet 2
#DEFINE cfsMsg 3
#DEFINE cfsWhn 4
#DEFINE cfsVal 5
#DEFINE cfspic 6
#DEFINE cfsOKL 7

#DEFINE cHcodes ALEN(headercode,1)
#DEFINE cScodes ALEN(screencode,1)
#DEFINE cNoFS '*:FSARRAYFIX OFF'
#DEFINE cFontFace 'Arial'
#DEFINE cFontSize 8

PRIVATE FILT,mwname,mwfont,mwfsize,mwcolor,fshift,codesearches

DIMENSION headercode(4)
DIMENSION screencode(7)

headercode(1)='SHOW'
headercode(2)='ACTIVATE'
headercode(3)='DEACTIVATE'
headercode(4)='PROCCODE'

screencode(1)='WHEN'
screencode(2)='VALID'
screencode(3)='MESSAGE'
screencode(4)='ERROR'
screencode(5)='COMMENT'
screencode(6)='NAME'
screencode(7)='EXPR'

IF objtype=cnheader AND (!drvenable(PROGRAM()) OR wordsearch("*:NOFS","SETUPCODE")<>ccnull)
	GO BOTTOM
	RETURN .F.
ENDIF

DO updthrm WITH "Running Field Scroller","[WINDOWS] "+PROGRAM(),0
IF EMPTY(name)
	REPLACE name WITH LOWER(SYS(2015))
ENDIF
IF EMPTY(fontface)
	REPLACE fontface WITH "MS Sans Serif",fontsize WITH 8
ENDIF

mwname=name
mwfont=ALLTRIM(fontface)
mwfontsize=fontsize
mwcolor=" COLOR RGB(,,,"+ALLTRIM(STR(fillred))+","+ALLTRIM(STR(fillgreen))+","+ALLTRIM(STR(fillblue))+")"
fsmoveu=SYS(2015)	
fsmoved=SYS(2015)	
m.objval=SYS(2015)

SCAN FOR objtype=cnbox AND wordsearch("*:FS ","comment")<>ccnull

	*- Establish box-specific attributes
	fstv=vpos
	fsth=hpos
	fsh=HEIGHT
	fsw=WIDTH
	fsshift=SYS(2015)
	fsshow=SYS(2015)
	fsarray=LOWER(wordsearch("*:FS","comment"))
	SET MESSAGE TO "Defining scrolling fields"
	DO updthrm WITH "","[WINDOWS] "+PROGRAM(),.05

	*- Establish font and size
	tempstr=UPPER(WORDSEARCH("*:FSFONT ","COMMENT"))
	fsfontface=cFontFace
	fsfontsize=cFontSize
	IF tempstr<>ccNull
		fsfontface=LEFT(tempstr,IIF(AT(",",tempstr)=0,cFontFace,AT(",",tempstr)-1))
		fsfontsize=IIF(VAL(SUBSTR(tempstr,AT(",",tempstr)+1))<1,cFontSize,VAL(SUBSTR(tempstr,AT(",",tempstr)+1)))
	ENDIF
	
	*- Establish @ ... SAY and @ ... GET weights (Bold/Normal)
	tempstr=UPPER(WORDSEARCH("*:FSBOLD ","COMMENT"))
	fssaywt=cnBoldWt
	fsgetwt=cnNormalWt
	IF tempstr<>ccNull
		fssaywt=IIF(INLIST(tempstr,"GETS","NONE"),cnNormalWt,cnBoldWt)
		fsgetwt=IIF(INLIST(tempstr,"GETS","BOTH"),cnBoldWt,cnNormalWt)
	ENDIF

	*- Establish font ratios
	fsavgh=FONTMETRIC(1,fsfontface,fsfontsize)
	mwavgh=FONTMETRIC(1,mwfont,mwfontsize)
	fsavgw=FONTMETRIC(6,fsfontface,fsfontsize)
	mwavgw=FONTMETRIC(6,mwfont,mwfontsize)

	*- Establish SAY/GET available width ratio
	tempstr=VAL(WORDSEARCH("*:FSRATIO ","COMMENT"))
	fsratio=IIF(tempstr<.1 OR tempstr>.9,.35,tempstr)

	*- Establish margin settings (Left,Right,Top,Bottom,Field,Get:pixels)
	tempstr=VAL(WORDSEARCH("*:FSLM ","COMMENT"))
	fslmargin=IIF(tempstr<2 OR tempstr>30,fsavgh,tempstr)
	
	tempstr=VAL(WORDSEARCH("*:FSRM ","COMMENT"))
	fsrmargin=IIF(tempstr<2 OR tempstr>30,fsavgh,tempstr)

	tempstr=VAL(WORDSEARCH("*:FSTM ","COMMENT"))
	fstmargin=IIF(tempstr<2 OR tempstr>30,fsavgh,tempstr)
	
	tempstr=VAL(WORDSEARCH("*:FSBM ","COMMENT"))
	fsbmargin=IIF(tempstr<2 OR tempstr>30,fsavgh,tempstr)

	tempstr=VAL(WORDSEARCH("*:FSFM ","COMMENT"))
	fsfmargin=IIF(tempstr<2 OR tempstr>30,fsavgh/2,tempstr)

	tempstr=VAL(WORDSEARCH("*:FSGM ","COMMENT"))
	fsgmargin=IIF(tempstr<2 OR tempstr>30,fsavgw*3,tempstr)

	*- Establish the hard stuff
	hfactor=fsavgh/mwavgh
	wfactor=FONTMETRIC(6,fsfontface,fsfontsize,SUBSTR("NB",fsSayWt+1,1))/mwavgw

	*- Establish number of fields that will fit without prior to margin adjust
	numfields=(fsh+px(fsfmargin)-px(fstmargin+fsbmargin))/(px(fsfmargin)+hfactor)
	numfields=INT(numfields)
	*- use extra height to to the margins to fit exactly in the box.

	extraheight=fsh*mwavgh-(fstmargin+(fsfmargin+fsavgh)*(INT(numfields)-1)+fsavgh+fsbmargin)
	margintotal=fstmargin+fsfmargin*(INT(numfields)-1)+fsbmargin
	tempmargin=fsfmargin
	fsfmargin=fsfmargin+FLOOR(1000*extraheight*fsfmargin/margintotal)/1000
	extraheight=extraheight-(fsfmargin-tempmargin)*(INT(numfields)-1)
	fstmargin=fstmargin+extraheight/2
	fsbmargin=fsbmargin+extraheight/2

	fstotwidth=fsw-(fsgmargin+fslmargin+fsrmargin)/mwavgw
	fssaywidth=fstotwidth*fsratio*mwavgw/FONTMETRIC(6,fsfontface,fsfontsize,SUBSTR("NB",fsSayWt+1,1))
	fsgetwidth=fstotwidth*(1-fsratio)*mwavgw/FONTMETRIC(6,fsfontface,fsfontsize,SUBSTR("NB",fsGetWt+1,1))
	m.fshift=LOWER(SYS(2015))
	m.oklarray=LOWER(SYS(2015))
	temppos=fstv+px(fstmargin)
	m.debug=TIME()
	r1=RECNO()

	* DO WHILE temppos<=fstv+fsh-(fstmargin+fsbmargin)/mwavgh
	FOR i=1 TO numfields
		SET MESSAGE TO "Inserting record ["+ALLTRIM(STR(i))+"/"+ALLTRIM(STR(2*numfields+2))+"]"
		DO updthrm WITH "","[WINDOWS] "+PROGRAM(),.05+75*(i/numfields*2+2)
		=insblank(1)
		REPLACE platform WITH "WINDOWS",;
			uniqueid WITH SYS(2019),;
			objtype WITH cnsayget,;
			objcode WITH cngetcode,;
			name WITH fsarray+"("+ALLTRIM(STR(i))+","+ALLTRIM(STR(cfsSay))+")",;
			vpos WITH temppos,;
			hpos WITH fsth+fslmargin/mwavgw,;
			height WITH 1,;
			width WITH fssaywidth;
			when WITH ".F.",;
			comment WITH "*# USERPRECOMMAND IF TYPE(["+name+"])='C'"+m.cr_lf+"*# USERPOSTCOMMAND ENDIF"+m.cr_lf+"*:3D RAISED"+m.cr_lf+cNoFS,;
			fontface WITH fsfontface,;
			fontstyle WITH fsSayWt,;
			picture WITH ['@J'],;
			fontsize WITH fsfontsize,;
			penred WITH -1,;
			penblue WITH -1,;
			pengreen WITH -1,;
			fillred WITH 192,;
			fillblue WITH 192,;
			fillgreen WITH 192
			temppos=temppos+hfactor+fsfmargin/mwavgh
	ENDFOR
	
	*- put in first invisible button
	=insblank(1)
	SET MESSAGE TO "Inserting record ["+ALLTRIM(STR(numfields+1))+"/"+ALLTRIM(STR(2*numfields+2))+"]"
	REPLACE platform WITH "WINDOWS",;
		uniqueid WITH SYS(2015),;
		objtype WITH 20,;
		objcode WITH 1,;
		name WITH SYS(2015),;
		vpos WITH 0,;
		hpos WITH 0,;
		height WITH 0,;
		width WITH 0,;
		picture WITH "[@*IHN]",;
		whentype WITH 1,;
		fontface WITH fsfontface,;
		fontsize WITH 8,;
		penred WITH -1,;
		penblue WITH -1,;
		pengreen WITH -1,;
		fillred WITH -1,;
		fillblue WITH -1,;
		fillgreen WITH -1,;
		comment with cNoFS,;
		when WITH "IF "+fsshift+">0 AND INLIST(LASTKEY(),15,5)"+m.cr_lf+;
		"   IF "+fsmoveu+"(@"+fsarray+",@"+fsshift+")"+m.cr_lf+;
		"      _curobj=_curobj+1"+m.cr_lf+;
		"   ELSE"+m.cr_lf+;
		"      _curobj=_curobj-1"+m.cr_lf+;
		"   ENDIF"+m.cr_lf+;
		"   ="+fsshow+"()"+m.cr_lf+;
		"ENDIF"+m.cr_lf+m.cr_lf+"RETURN .F."
		
	*- Insert 'gets'
	*- PICTURE clauses won't work here, look for a workaround someday.
	temppos=fstv+px(fstmargin)
	*	DO WHILE temppos<fstv+fsh-(fstmargin+fsbmargin)/mwavgh
	FOR i=1 to numfields
		=insblank(1)
		SET MESSAGE TO "Inserting record ["+ALLTRIM(STR(numfields+1+i))+"/"+ALLTRIM(STR(2*numfields+2))+"]"
		DO updthrm WITH "","[WINDOWS] "+PROGRAM(),.05+75*((i+numfields+1)/numfields*2+2)
		REPLACE platform WITH "WINDOWS",;
			uniqueid WITH SYS(2019),;
			objtype WITH cnsayget,;
			objcode WITH cngetcode,;
			name WITH fsarray+"("+ALLTRIM(STR(i))+","+ALLTRIM(STR(cfsGet))+")",;
			vpos WITH temppos,;
			hpos WITH fsth+fssaywidth*wfactor+(fsgmargin+fslmargin)/mwavgw,;
			height WITH 1,;
			width WITH fsgetwidth;
			when WITH ".T.",;
			comment WITH "*# USERPRECOMMAND IF TYPE(["+fsarray+"("+ALLTRIM(STR(i))+",1)])='C'"+m.cr_lf+"*# USERPOSTCOMMAND ENDIF"+m.cr_lf+cNoFS,;
			message WITH "EVAL("+m.objval+"("+fsarray+"("+ALLTRIM(STR(i))+","+ALLTRIM(STR(cfsMsg))+"),"+fsshift+",'"+fsarray+"'))",;
			valid   WITH "EVAL("+m.objval+"("+fsarray+"("+ALLTRIM(STR(i))+","+ALLTRIM(STR(cfsVal))+"),"+fsshift+",'"+fsarray+"'))",;
			when    WITH "EVAL("+m.objval+"("+fsarray+"("+ALLTRIM(STR(i))+","+ALLTRIM(STR(cfsWhn))+"),"+fsshift+",'"+fsarray+"'))",;
			picture WITH "[@K]",;
			fontface WITH fsfontface,;
			fontstyle WITH fsGetWt,;
			fontsize WITH fsfontsize;
			penred WITH -1,;
			penblue WITH -1,;
			pengreen WITH -1,;
			fillred WITH -1,;
			fillblue WITH -1,;
			fillgreen WITH -1
			temppos=temppos+hfactor+fsfmargin/mwavgh
	ENDFOR

	* insert last invisible button
	=insblank(1)
	SET MESSAGE TO "Inserting record ["+ALLTRIM(STR(2*numfields+2))+"/"+ALLTRIM(STR(2*numfields+2))+"]"
	DO updthrm WITH "","[WINDOWS] "+PROGRAM(),.8
	REPLACE platform WITH "WINDOWS",;
		uniqueid WITH SYS(2015),;
		objtype WITH 20,;
		objcode WITH 1,;
		name WITH SYS(2015),;
		vpos WITH 0,;
		hpos WITH 0,;
		height WITH 0,;
		width WITH 0,;
		picture WITH "[@*IHN]",;
		whentype WITH 1,;
		fontface WITH fsfontface,;
		fontsize WITH 8,;
		penred WITH -1,;
		penblue WITH -1,;
		pengreen WITH -1,;
		fillred WITH -1,;
		fillblue WITH -1,;
		fillgreen WITH -1,;
		comment with cNoFS,;
		when WITH "IF "+fsshift+"<ALEN("+fsarray+",1)-"+ALLTRIM(STR(numfields))+" AND INLIST(LASTKEY(),9,24)"+m.cr_lf+;
			"   IF "+fsmoved+"(@"+fsarray+",@"+fsshift+")"+m.cr_lf+;
			"      _curobj=_curobj-1"+m.cr_lf+;
			"   ELSE"+m.cr_lf+;
			"      _curobj=_curobj+1"+m.cr_lf+;
			"   ENDIF"+m.cr_lf+;
			"   ="+fsshow+"()"+m.cr_lf+;
			"ENDIF"+m.cr_lf+;
			"RETURN .F."+m.cr_lf

	r2=RECNO()
	GO TOP
	REPLACE setupcode WITH STRTRAN(setupcode,"#SECTION 1","#SECTION 1"+m.cr_lf+fsshift+"=0")

	REPLACE setupcode WITH setupcode+m.cr_lf+m.cr_lf+;
		"FOR i=1 to ALEN("+fsarray+",1)"+m.cr_lf+;
		"	IF EMPTY("+fsarray+"(i,4))"+m.cr_lf+;
		"		"+fsarray+"(i,4)='.T.'"+m.cr_lf+;
		"	ENDIF"+m.cr_lf+;
		"	IF EMPTY("+fsarray+"(i,5))"+m.cr_lf+;
		"		"+fsarray+"(i,5)='.t.'"+m.cr_lf+;
		"	ENDIF"+m.cr_lf+;
		"	IF EMPTY("+fsarray+"(i,5))"+m.cr_lf+;
		"		"+fsarray+"(i,5)='.t.'"+m.cr_lf+;
		"	ENDIF"+m.cr_lf+;
		"ENDFOR"

	REPLACE proccode WITH proccode+m.cr_lf+;
		"FUNCTION "+fsshow+m.cr_lf+;
		"PRIVATE i"+m.cr_lf+;
		"FOR i=1 TO "+ALLTRIM(STR(numfields))+m.cr_lf+;
		"    SHOW GET "+fsarray+" (i,1)"+m.cr_lf+;
		"	 SHOW GET "+fsarray+" (i,2)"+m.cr_lf+;
		"ENDFOR"

	FOR i=1 to cHcodes
		IF ATC(fsarray,EVAL(headercode(i)))>0 AND WORDSEARCH("*:FSARRAYFIX","COMMENT")<>"OFF"
			=fixarray(headercode(i))
		ENDIF
	ENDFOR
	
	FOR i=1 to cScodes
		SCAN FOR ATC(fsarray,EVAL(screencode(i)))>0 AND WORDSEARCH("*:FSARRAYFIX","COMMENT")<>"OFF"
			t=time()
			=fixarray(screencode(i))
		ENDSCAN
	ENDFOR
	GO r2
ENDSCAN
SET MESSAGE TO "Adding supporting procedures and functions"
GO TOP
	REPLACE proccode WITH proccode+M.CR_LF+;
		"FUNCTION "+fsmoved+m.cr_lf+;
		"PARAMETER fsarray,fsshift"+m.cr_lf+;
		"PRIVATE i,rows,cols,temp,again"+m.cr_lf+;
		"rows=ALEN(fsarray,1)"+m.cr_lf+;
		"cols=ALEN(fsarray,2)"+m.cr_lf+;
		"IF fsshift=rows-"+ALLTRIM(STR(numfields))+m.cr_lf+;
		"     RETURN"+m.cr_lf+;
		"ELSE"+m.cr_lf+;
		"     again=.t."+m.cr_lf+;
		"     DIMENSION temp(cols)"+m.cr_lf+;
		"     DO WHILE fsshift<rows-"+ALLTRIM(STR(numfields))+" AND again"+m.cr_lf+;
		"          fsshift=fsshift+1"+m.cr_lf+;
		"          FOR i=1 to cols"+m.cr_lf+;
		"               temp(i)=fsarray(1,i)"+m.cr_lf+;
		"          ENDFOR"+m.cr_lf+;
		"          =ADEL(fsarray,1)"+m.cr_lf+;
		"          FOR i=1 to cols"+m.cr_lf+;
		"               fsarray(rows,i)=temp(i)"+m.cr_lf+;
		"          ENDFOR"+m.cr_lf+;
		"          again=!EVAL("+m.objval+"(fsarray("+ALLTRIM(STR(numfields))+","+ALLTRIM(STR(cfsWhn))+"),0,'fsarray'))"+m.cr_lf+;
		"      ENDDO"+m.cr_lf+;
		"ENDIF"+m.cr_lf+;
		"RETURN EVAL("+m.objval+"(fsarray("+ALLTRIM(STR(numfields))+","+ALLTRIM(STR(cfsWhn))+"),0,'fsarray'))"
		
	REPLACE proccode WITH proccode+m.cr_lf+;
		"FUNCTION "+fsmoveu+m.cr_lf+;
		"PARAMETER fsarray,fsshift"+m.cr_lf+;
		"PRIVATE i,rows,cols,temp,again"+m.cr_lf+;
		"rows=ALEN(fsarray,1)"+m.cr_lf+;
		"cols=ALEN(fsarray,2)"+m.cr_lf+;
		"IF fsshift=0"+m.cr_lf+;
		"   RETURN .f."+m.cr_lf+;
		"ELSE"+m.cr_lf+;
		"   again=.t."+m.cr_lf+;
		"   DIMENSION temp(rows,cols)"+m.cr_lf+;
		"   DO WHILE fsshift>0 AND again"+m.cr_lf+;
		"      fsshift=fsshift-1"+m.cr_lf+;
		"      =ACOPY(fsarray,temp,1,(rows-1)*cols,aelement(temp,2,1))"+m.cr_lf+;
		"      FOR i=1 to cols"+m.cr_lf+;
		"         temp(1,i)=fsarray(rows,i)"+m.cr_lf+;
		"      ENDFOR"+m.cr_lf+;
		"      =ACOPY(temp,fsarray)"+m.cr_lf+;		
		"      again=!EVAL("+m.objval+"(fsarray(1,"+ALLTRIM(STR(cfsWhn))+"),0,'fsarray'))"+m.cr_lf+;
		"   ENDDO"+m.cr_lf+;
	    "ENDIF"+m.cr_lf+;
	    "RETURN EVAL("+m.objval+"(fsarray(1,"+ALLTRIM(STR(cfsWhn))+"),0,'fsarray'))"

	REPLACE proccode WITH proccode+m.cr_lf+;
		"FUNCTION "+objval+m.cr_lf+;
		"PARAMETER txt,fsshift,arrayname"+m.cr_lf+;
		"PRIVATE i,j,k,l"+m.cr_lf+;
		'DO WHILE REPLICATE("{",2)$txt'+m.cr_lf+;
		'i=AT(REPLICATE("{",2),txt)'+m.cr_lf+;
		'j=AT(REPLICATE("}",2),txt)'+m.cr_lf+;
		'k=AT(",",SUBSTR(txt,i,j-i+1))'+m.cr_lf+;
		'IF k=0'+m.cr_lf+;
		'   l=SUBSTR(txt,i+2,j-i-2)'+m.cr_lf+;
		'   m="2"'+m.cr_lf+;
		'ELSE'+m.cr_lf+;
		'	l=SUBSTR(txt,i+2,k-3)'++m.cr_lf+;
		'	m=SUBSTR(txt,i+k,j-k-i)'+m.cr_lf+;
		'ENDIF'+m.cr_lf+;
		'l=ALLTRIM(STR(VAL(l)+fsshift))'+m.cr_lf+;
		'txt=STUFF(txt,i,j-i+2,arrayname+"("+l+","+m+")")'+m.cr_lf+;
		'ENDDO'+m.cr_lf+;
		'RETURN txt'+m.cr_lf

			
GO BOTTOM	
DO updthrm WITH "","[WINDOWS] "+PROGRAM(),1

FUNCTION px
PARAMETER p
RETURN p/FONTMETRIC(1,mwfont,mwfontsize)

FUNCTION fixarray
parameter snippet
PRIVATE i,j,k,l,str
l=1
DO WHILE ATC(fsarray+"(",EVAL(snippet),l)>0 OR ATC(fsarray+"[",EVAL(snippet),l)>0
	i=ATC(fsarray+"(",EVAL(snippet),l)+LEN(fsarray)+1
	j=ATC(")",SUBSTR(EVAL(snippet),i))-1
	str=SUBSTR(EVAL(snippet),i,j)
	IF ATC(",",str)>0
		j=ATC(",",str)-1
	ENDIF
	STR=left(str,j)
	REPLACE (snippet) WITH STUFF(EVAL(snippet),i,j,"MOD("+str+"-"+fsshift+"-1,ALEN("+fsarray+",1))+1")
	l=l+1
ENDDO
* old, wrong: REPLACE (snippet) WITH STUFF(EVAL(snippet),i,j,"MOD("+str+"+"+fsshift+"-1,"+ALLTRIM(STR(m.numfields))+")+1")
