*--------*---------*---------*---------*---------
*  Program...........: SETWPRNT.PRG
*  System............: Procedure/Function Library
*  Author............: Stephen A. Sawyer
*  Date..............: October 18, 1994
*  Notice............: Copyright (c) 1994
*  ..................: KarCal Company, Inc.
*  Compiler..........: FoxPro 2.6 for Windows
*) Description.......: Changes the default printer in 
*) ..................: WIN.INI based on settings in a 
*) ..................: "printer control" (DBF) file.
*) ..................: The printer control table is
*) ..................: created by the companion GETWPRNT
*  Syntax............: llSuccess = SETWPRNT()
*  Parameters........: None
*  Uses..............: 
*  Returns...........: jlRetVal, logical
*  Calls.............: WRITEINI(), YNALERT()
*  Changes...........: WIN.INI file
*  Called By.........: Generic
*--------*---------*---------*---------*---------
PRIVATE LIKE j*
***************************************************************
* If the printer control table, WINPRINT.DBF does not exist,
* then this routine will return terminate and return .F.
***************************************************************
IF ! FILE(SYS(2023) + "\" + "WinPrint.DBF")
	=YNALERT("No printer control table found",3)
	jlRetVal = .F.
	RETURN jlRetVal
ENDIF
jcCurrArea = ALIAS()
IF USED("WinPrint")
	SELECT WinPrint
ELSE
	SELECT 0
	USE (SYS(2023) + "\WinPrint.DBF")
ENDIF
LOCATE FOR ! EMPTY(cDefault)
jcDefault = ALLTRIM(cDefault)
* Transfer the contents of the printer control table, WINPRINT.DBF
* to an array for use in this routine.
COPY TO ARRAY jaPrinters FIELDS ;
		cprinter, ;
		cparams, ;
		cports, ;
		cport_1, ;
		cport_2, ;
		cport_3, ;
		cport_4, ;
		cport_5, ;
		cport_6
* Use this table to update the WIN.INI file		
jlRetVal = UpdateINI(@jaPrinters,jcDefault)
RETURN jlRetVal
	
PROCEDURE UpdateINI
PARAMETERS paPrinters,pcDefault
PRIVATE LIKE j*
* Set the default printer
IF ! WRITEINI("windows","device",pcDefault) 
	=YNALERT("Error - unable to change default printer",3)
	jlRetVal= .F.
ELSE
	* Delete all existing device and PrinterPort entries.
	IF WRITEINI("devices",0,CHR(0)) AND WRITEINI("PrinterPort",0,CHR(0))
		jlRetVal = .T.
		FOR ji = 1 TO ALEN(paPrinters,1)
			IF ! (WRITEINI("devices",paPrinters[ji,1],paPrinters[ji,2]) AND ;
				WRITEINI("PrinterPorts",paPrinters[ji,1],paPrinters[ji,3]))
				=YNALERT("Error - unable to re-write printer entry " + paPrinters[ji,1],3)
				jlRetVal = .F.
			ELSE
				jlRetVal = .T.
			ENDIF
		ENDFOR ( ji )
	ELSE
		=YNALERT("Error - unable to remove existing printer entries",3)
		jlRetVal = .F.
	ENDIF
ENDIF
RETURN jlRetVal
