*--------*---------*---------*---------*---------
*  Program...........: SETWPRNT.PRG
*  System............: Procedure/Function Library
*  Author............: Stephen A. Sawyer
*  Date..............: October 18, 1994
*  Notice............: Copyright (c) 1994
*  ..................: KarCal Company, Inc.
*  Compiler..........: FoxPro 2.6 for Windows
*) Description.......: Determines the available printers in
*) ..................: WIN.INI and the current default printer
*) ..................: and stores this info in a "printer control"
*) ..................: file.  The file is created if it does not
*) ..................: already exist
*  Syntax............: DO getwprnt
*  Parameters........: None
*  Uses..............: 
*  Returns...........: 
*  Calls.............: READINI(), YNALERT()
*  Changes...........: 
*  Called By.........: Generic
*--------*---------*---------*---------*---------

PRIVATE LIKE j*
jnBufLen = 2048
jcRetBuf = REPLICATE(CHR(0),jnBufLen)
*****************************************************************
* FIRST PASS IN WIN.INI
*****************************************************************
* The following command calls the READINI function, which retrieves, from 
* the "devices" section of WIN.INI *all* of the entries [0], defaulting to the 
* null character (CHR(0)) if no entries are found, and places the retrieved 
* entries in the memvar "jcRetBuf" which has been initialized above to a 
* 2048-character string containing only "null" characters, of length 2048
* (jnBufLen).  
*
* Each entry returned from the WIN.INI file is delimited with null characters 
* (CHR(0). Note that this command retrieves only the *entries* and not the 
* *values* for those entries from WIN.INI.  This is a characteristic of the 
* Windows API (GetProfileString) function which is built into the READINI 
* function.
*****************************************************************
jnBytes = READINI("devices",0,CHR(0),@jcRetBuf,jnBufLen)
* Strip off trailing null characters
jcRetBuf = LEFT(jcRetBuf,jnBytes)
jnDevCount = 0
*****************************************************************
* perform following functions as long as there is a "null" delimiter
* in the string, i.e. "we ain't done yet"
*****************************************************************
DO WHILE CHR(0) $ jcRetBuf
	* parse the string for the next WIN.INI entry
	jcThisDev = LEFT(jcRetBuf,AT(CHR(0),jcRetBuf)-1)
	IF LEFT(jcThisDev,1) <> CHR(0) && We aren't at last entry
		jnDevCount = jnDevCount + 1
		DIMENSION jaPrinters[jnDevCount,9]
		jaPrinters[jnDevCount,1] = jcThisDev
	ENDIF ( LEFT(jcThisDev,1) <> CHR(0) )
	IF (AT(CHR(0),jcRetBuf)+1) >  LEN(jcRetBuf)
		jcRetBuf = ""
	ELSE
		jcRetBuf = SUBSTR(jcRetBuf,AT(CHR(0),jcRetBuf)+1)
	ENDIF
ENDDO ( CHR(0) $ jcRetBuf )
*****************************************************************
* SECOND PASS IN WIN.INI
*****************************************************************
* Now that we have a list of devices (printers) stored in the array 
* jaPrinters, we can use this information to again call READINI which
* uses the Windows API function GetProfileString() to determine the
* parameters for each printer (driver and list of ports) from the 
* [devices] section of WIN.INI, and store this information in column 2 
* of jaPrinters.  We also use READINI to retrieve the list of ports 
* associated with each printer along with their parameters from the 
* [PrinterPorts] section of WIN.INI and store this information in
* column 3 of the jaPrinters array
*****************************************************************
FOR jj = 1 TO jnDevCount
	jcRetBuf = REPLICATE(CHR(0),256)
	jnBytes = READINI("devices",jaPrinters[jj,1],CHR(0),@jcRetBuf,256)
	jcRetBuf = LEFT(jcRetBuf,jnBytes)
	jaPrinters[jj,2] = jcRetBuf
	jcRetBuf = REPLICATE(CHR(0),256)
	jnBytes = READINI("PrinterPorts",jaPrinters[jj,1],CHR(0),@jcRetBuf,256)
	jcRetBuf = LEFT(jcRetBuf,jnBytes)
	jaPrinters[jj,3] = jcRetBuf
ENDFOR ( jj )
*****************************************************************
* THIRD PASS IN WIN.INI
*****************************************************************
* Now read the "device" value from the [Windows] section of WIN.INI which 
* gives us the current default printer
*****************************************************************
jcRetBuf = REPLICATE(CHR(0),256)
jnBytes = READINI("windows","device",CHR(0),@jcRetBuf,256)
jcRetBuf = LEFT(jcRetBuf,jnBytes)
jcDefault = jcRetBuf
*****************************************************************
* Parse port information for multiple port/single printer situations
* and store this info to columns 4-9 in jaPrinters
*****************************************************************
FOR i=1 TO ALEN(jaPrinters,1)
	jcPortlist=jaPrinters[i,2]
	jcPortlist=STUFF(jcPortList,1,AT(",",jcPortList),"")
	lnPortNo=0
	DO WHILE LEN(jcPortList) > 0
		lnPortNo=lnPortNo+1
		IF jcPortList="None"
			jaPrinters[i,lnPortNo+3]=jcPortList
		ELSE		
			jaPrinters[i,lnPortNo+3]=LEFT(jcPortList,AT(":",jcPortList))
		ENDIF
		jcPortList=STUFF(jcPortList,1,AT(":",jcPortList),"")
		IF LEFT(jcPortList,1)=","
			jcPortList=STUFF(jcPortList,1,1,"")
		ENDIF ( LEFT(jcPortList,1)="," )
		IF jcPortList = "None"
			jcPortList=""
		ENDIF
	ENDDO ( LEN(jcPortList) > 0 )
ENDFOR ( i )
*****************************************************************
* Convert logical values in array jaPrinters
* to (empty) character values
*****************************************************************
FOR ji = 1 to ALEN(jaPrinters)
	FOR jj = 1 to 9
		IF TYPE("jaPrinters[i,j]") = "L"
			STORE "" TO jaPrinters[i,j]
		ENDIF
	ENDFOR &&* jj = 1 to 9
ENDFOR &&* ji = 1 to ALEN(jaPrinters)
*****************************************************************
* Now copy all of the data we have accumulated in jaPrinters to a 
* table.  This table is intended to be located wherever the user stores
* their .TMP files, hence the use of the SYS(2023) function.
* Note that a) the current work area is stored for restoration when
* we are done, b) the code checks to see if a WINPRINT.DBF already 
* exists, and if not creates on, otherwise it opens the existing
* WINPRINT.DBF and ZAPs it.
*****************************************************************
jcCurrArea = ALIAS()
IF FILE(SYS(2023) + "\" + "WinPrint.DBF")
	IF USED("WinPrint")
		SELECT WinPrint
	ELSE
		SELECT 0
		USE (SYS(2023) + "\" + "WinPrint")
	ENDIF
	jcOldSafe=SET("SAFETY")
	SET SAFETY OFF
	ZAP
	SET SAFETY &jcOldSafe
ELSE
	CREATE TABLE (SYS(2023) + "\" + "WinPrint") ;
		(cprinter C(50), ;
		cparams C(45), ;
		cports C(45), ;
		cport_1 C(5), ;
		cport_2 C(5), ;
		cport_3 C(5), ;
		cport_4 C(5), ;
		cport_5 C(5), ;
		cport_6 C(5), ;
		cDefault C(45))
	USE (SYS(2023) + "\" + "WinPrint")
ENDIF
APPEND FROM ARRAY jaPrinters
*****************************************************************
* Determine which record in the table is the current "default" printer
* specified in WIN.INI, and record the string from the [Windows] device=
* item in the cDefault field of that record
*****************************************************************
LOCATE FOR cprinter = LEFT(jcDefault,AT(",",jcDefault)-1)
IF FOUND()
	REPLACE cDefault WITH jcDefault
ENDIF
IF ! EMPTY(jcCurrArea)
	SELECT (jcCurrArea)
ENDIF	
RETURN