*--------*---------*---------*---------*---------
*  Function..........: READINI
*) Description.......: Retrieves contents of a specified
*) ..................: portion of the WIN.INI file.
*) ..................: 
*  Syntax............: lnBytes = READINI([ExpC1],[ExpC2],[ExpC3],@[ExpC4],[ExpN1]
*  ..................: ExpC1 = the section of WIN.INI to look in 
*  ..................: 	(e.g. [Windows] or [Devices])
*  ..................: ExpC2 = The specific entry within that section to
*  ..................:  retrieve - a 0 returns *all* entries.
*  ..................: ExpC3 = The default value to return if the search
*  ..................:  is unsuccessful
*  ..................: ExpC4 = A "buffer" variable, initialized with some
*  ..................:  number of "null" characters (CHR(0)), enough to 
*  ..................:  hold the results.  If too small, the results are
*  ..................:  truncated to fit.
*  ..................: ExpN1 = The length of the buffer being passed
*  ..................: **NOTE** - be sure to pass the buffer variable by
*  ..................: *REFERENCE* by prepending a "@" to the variable name
*  Uses..............: FOXTOOLS.FLL
*  ..................: 
*  Returns...........: jnRetVal, Numeric, number of bytes retrieved
*  Calls.............: Windows API function GetProfileString()
*  ..................: OPENTOOL(), YNALERT()
*  Changes...........:
*  Called By.........: Generic
*--------*---------*---------*---------*---------
* FUNCTION READINI
PARAMETER pcSection, pcEntry, pcDflt, pcBuffer, pnBufLen
PRIVATE LIKE j*
IF OPENTOOL()
	jnFn = regfn("GETPROFILESTRING","CCC@CI","I")
	jnRetVal = callfn(jnFn,pcSection,pcEntry,pcDflt,@pcBuffer,pnBufLen)
ELSE
	=YNALERT("Couldn't open FOXTOOLS.FLL",3)
	jnRetVal = 0
ENDIF
RETURN jnRetVal
*EOF READINI
