*:*********************************************************************
*:
*: Procedure file: H:\FTCL\SPLITPTH.PRG
*:
*:         System: FoxPro 2.0 Change Log Database
*:         Author: Maurice Frank
*:      Copyright (c) 1991, Maurice Frank
*:  Last modified: 11/10/91     21:00
*:
*:  Procs & Fncts: SPLITPTH()
*:
*:      Documented 11/11/91 at 21:01               FoxDoc  version 2.10b
*:*********************************************************************

* Split a fully qualified pathname into component parts
* Returns a file's drive, path, base name, extension
* One to four parts can be returned as one variable
* Also returns individual parts if passed by reference

PARAMETERS mqfn, mparts, mdrive, mpath, mname, mext

PRIVATE mqfn, mparts, mlen, mlast_bs, mperiod, mfnm_beg, mfnm_len, mret_val

* default parameters
mqfn = IIF(EMPTY(mqfn),"*.*",ALLTRIM(mqfn))
mparts = IIF(EMPTY(mparts),"dpne",LOWER(mparts))

* use FoxPro's function to fully qualify the path
* this simplifies certain assumptions about where things are

mqfn = FULLPATH(mqfn)

* working variables used to splice parts
mlen = LEN(mqfn)                                   && length of fully wualified filename
mlast_bs = RAT("\",mqfn)                           && last backslash
mperiod = RAT(".",mqfn)                            && location of period before extension
mfnm_beg = mlast_bs+1
mfnm_len = IIF(mperiod>0,mperiod-mfnm_beg,mlen-mfnm_beg)

* parse out each part of the fully qualified filename
mdrive = LEFT(mqfn,1)
mpath = SUBSTR(mqfn,3,MAX(mlast_bs-3,1))           && 3 is location of first backslash
mname = SUBSTR(mqfn,mfnm_beg,mfnm_len)
mext = IIF(mperiod>0,SUBSTR(mqfn,mperiod+1),"")

* put it together

* intialize return variable
mret_val = ""

* colon is added after the drive
mret_val = mret_val + IIF("d"$mparts,mdrive+":","")

* add a trailing backslash if the path and filename are returned
mret_val = mret_val + IIF("p"$mparts,mpath+IIF("n"$mparts,"\",""),"")

* here is the base file name
mret_val = mret_val + IIF("n"$mparts,mname,"")

* a period is inserted between file name and ext if both are returned
mret_val = mret_val + IIF("e"$mparts,IIF("n"$mparts,".","")+mext,"")

RETURN mret_val
*: EOF: SPLITPTH.PRG
