* FoxPro 2.0 Function:
*	BEEP_MSG_()
* Author:
*	Tom O'Hare - Voice: 407-299-4268
*				  Data: 407-299-4268,,2222   (2400,N,8,1)
* Copyright (c) 1992, Tom O'Hare
* Date:
*	Jan. 24, 1992
* Revision:
*	
* Purpose:
*	Sound PC speaker & show user a message.
* Conditions(c_BMCond):
*	INFO, NORM, ERR, FATAL_ERR, (none), ?
* Message(c_BMMsg):
*	(Passed by calling program) Any text.
* Usage:
*	Beep_Msg("condition", "message")
* Local VARs:
*	c_BMCond		= Type of alarm bell to sound (ERR, INFO, etc.).
*	c_BMMsg			= Message to display in window.
*	c_NotifyStatus	= The previous NOTIFY status
*	c_TalkStatus	= The previous TALK status.
*	n_XCntr			= Counter variable.
*	n_XBell			= Frequency for beep.
*	n_XTime			= Length of beep.
* Calls VARs:
*	(none)
* Calls Programs:
*	(none)
* Returns:
*	.T. (True)
* Notes:
*	Values & conditions may be changed or added as needed.
*	"ERR" Requires a keypress to continue.  Allows user time to
*		 determine what happened.
*	"FATAL_ERR" with a message is the same as "ERR", without a message
*		it continues processing (i.e. continue with ON ERROR routine.)
* Comments:
*	I can be reached at the Silver Bullet BBS at 407-277-2007
******
function BEEP_MSG
*
parameters c_BMCond, c_BMMsg
*
private c_BMCond, c_BMMsg, c_NotifyStatus, c_TalkStatus, ;
	n_XCntr, n_XBell, n_XTime
* Begin setting up enviorment.
if set("TALK")="ON"				&& Get talk status
	c_TalkStatus="ON"
	set talk off
else
	c_TalkStatus="OFF"
endif
if set("NOTIFY")="OFF"				&& Get talk status
	c_NotifyStatus="OFF"
	set notify on
else
	c_NotifyStatus="ON"
endif
store 0 to n_XCntr,n_XBell,n_XTime
* Begin failsafe routines.
if type("c_BMCond")#"C"			&& Failsafe for valid var.
	release c_BMCond
	private c_BMCond
	c_BMCond=""
else
	c_BMCond=upper(alltrim(c_BMCond))	&& All functions should use &
endif									&&	and return uppercase text.
if type("c_BMMsg")#"C"			&& Failsafe for message.
	release c_BMMsg
	private c_BMMsg
	c_BMMsg=""
else
	c_BMMsg=upper(alltrim(c_BMMsg))
endif
if len(c_BMMsg)>72			&& 72 chars is max visible length.
	c_BMCond="FATAL_ERR"
	c_BMMsg="Beep_Msg() INTERNAL ERROR: MESSAGE LENGTH " ;
		+"EXCEEDS 72 CHARACTERS!"
endif
* Begin condition determination routine.
do case							&& Determines type of condition,
case c_BMCond="?"				&&	beeps and waits accordingly.
	set bell to 1000, 4
	?? chr(7)
	wait 'SYNTAX: Beep_Msg("condition","message")' window timeout 6
	set bell to 1000, 4
	?? chr(7)
	wait '"condition": NORM, INFO, ERR, FATAL_ERR or none.' ;
		window timeout 6
	set bell to 1000, 4
	?? chr(7)
	wait '"message": Any text desired or none.' window timeout 6
	set bell to 1000, 4
	?? chr(7)
	set bell to 1000, 4
	?? chr(7)
case c_BMCond="INFO"
	set bell to 1000, 4
	?? chr(7)
	wait (c_BMMsg) window timeout 6
case c_BMCond="NORM"
	set bell to 512, 6
	?? chr(7)
	wait (c_BMMsg) window timeout 2
case c_BMCond="ERR"
	set bell to 200, 8
	?? chr(7)
	wait (c_BMMsg) window
case c_BMCond="FATAL_ERR"
	set bell to 100, 19
	?? chr(7)
	if empty(c_BMMsg)
		wait (c_BMMsg) window timeout 0.1
	else
		wait (c_BMMsg) window
	endif
otherwise						&& Generic routine (failsafe)
	n_XBell=150					&&	if no or bad parameters were passed.
	n_XTime=2.5
	for n_XCntr=1 to 3
		n_XBell=(n_XBell*2)+100
		n_XTime=n_XTime-0.5
		set bell to n_XBell,n_XTime
		?? chr(7)
		=inkey(.1)
	endfor
	if !empty(c_BMMsg)
		wait (c_BMMsg) window timeout 5
	endif
endcase
* Begin cleanup routine.
set bell to						&& Reset bell to default.
if c_NotifyStatus="OFF"
	set notify off
endif
if c_TalkStatus="ON"			&& Reset Talk to previous.
	set talk on
endif
*
return(.T.)
*
* End of function Beep_Msg()