*:*********************************************************************
*:
*:        Program: MENUTEST.PRG
*:
*:         System: MIS Consulting
*:         Author: Charles Alan Butler
*:      Copyright (c) 1989, Charles Alan Butler
*:  Last modified: 08/12/89     15:24
*:
*:      Called by: DEMO.PRG                      
*:
*:          Calls: LOGO.PRG
*:               : POPBOX2.PRG
*:               : POPMENU.PRG
*:               : PM_LOGO.PRG
*:               : CLR2.PRG
*:
*:      Documented 08/12/89 at 15:34                SNAP!  version 3.12f
*:*********************************************************************
**  --  Test prg to call PopMenu

* --- dBASE default SETTINGS
SET STEP OFF
SET TALK OFF
SET ECHO OFF
SET ESCAPE OFF          && Can not interrupt the program in progress
SET EXACT ON            && Require Comparisons to Be Exact?
SET SCOREBOARD OFF      && We use the top line of the screen
SET STATUS OFF          && We don't want dBASE's status line

SET COLOR TO N/B
DO LOGO

**  Delay
CLEAR TYPEAHEAD
ans=INKEY(3)

SET COLOR TO W+/G
DO PopBox2 WITH 2,3,21,75
@ 2,28 SAY '<  MENU FOR FOXBASE >'
@ ROW()+2,7 SAY "This menu routine emulates the FoxBase 2.1 '@ Menu' command which"
@ ROW()+1,7 SAY 'is a pop up menu. However this routine allows more control over'
@ ROW()+1,7 SAY 'key strokes and supports multi-column menus and Lotus style menus.'
@ ROW()+1,7 SAY 'It also allows large arrays to be used as a pick list.'
@ ROW()+2,7 SAY 'Although there are three lines that use 2.1 commands, they may be'
@ ROW()+1,7 SAY 'deleted with little loss as they remove the cursor and get the '
@ ROW()+1,7 SAY 'screen color before changing it. Other than that it is FoxBase 2.0 '
@ ROW()+1,7 SAY 'compatible. I think any dBase that uses arrays can use it.'
@ ROW()+2,7 SAY 'The purpose of this routine is to gain more control over the menu'
@ ROW()+1,7 SAY 'than FoxBase allows. See the PopMenu.PRG file and the MENUTEST.PRG '
@ ROW()+1,7 SAY 'file for more details.'
@ ROW()+2,7 SAY 'Address any comments or suggestions to Charles Butler.'
@ ROW()+2,7 SAY '                         Thanks   CAB'
@ ROW()+1,10 SAY 'Press Any Key'

CLEAR TYPEAHEAD
ans=INKEY(90)
RESTORE SCREEN

** PopUp(nn) =      Menu items;  must be set up here
** PopMes(nn)=      Menu Message items; must be set up here if used
**  set up menu choice array
DIMENSION PopUp(25)
PopUp( 1)= 'A) One'
PopUp( 2)= '\-'    &&  display a line
PopUp( 3)= 'C) Three'
PopUp( 4)= 'D) Four'
PopUp( 5)= 'E) Five'
PopUp( 6)= 'F) Six'
PopUp( 7)= '\-'     &&  display a line
PopUp( 8)= 'a) Eight'
PopUp( 9)= 'b) Nine'
PopUp(10)= 'c) Ten'
PopUp(11)= 'd) Eleven'
PopUp(12)= 'e) Twelve'
PopUp(13)= 'f) Thirteen'+CHR(250)  &&  non selectable item
PopUp(14)= 'g) Fourteen'
PopUp(15)= 'h) Help'
PopUp(16)= 'i) Sixteen'
PopUp(17)= '\-'     &&  display a line
PopUp(18)= 'k) Eighteen'
PopUp(19)= 'l) Nineteen'
PopUp(20)= 'm) Twenty'
PopUp(21)= 'n) Twentyone'
PopUp(22)= 'o) Twentytwo'
PopUp(23)= 'p) Twentythree'+CHR(250)  &&  non selectable item
PopUp(24)= 'q) Twentyfour'
PopUp(25)= 'r) Twentyfive'


** --  Set up message array, if used, see flag
DIMENSION PopMes(25)
PopMes( 1)= 'Message  1 is the first menu item.  The auto center is on.'
PopMes( 2)= 'This will not be displayed'
PopMes( 3)= 'Message  3,  Message 2 is not displayed.'
PopMes( 4)= 'Message  4'
PopMes( 5)= 'Message  5'
PopMes( 6)= 'Message  6'
PopMes( 7)= 'This will not be displayed'
PopMes( 8)= 'Message  8'
PopMes( 9)= 'Message  9'
PopMes(10)= 'Message 10'
PopMes(11)= 'Message 11'
PopMes(12)= 'Message 12'
PopMes(13)= 'This will not be displayed'
PopMes(14)= 'Message 14'
PopMes(15)= 'Return to the calling prg for help.'
PopMes(16)= 'Message 16'
PopMes(17)= 'This will not be displayed'
PopMes(18)= 'Message 18'
PopMes(19)= 'Message 19'
PopMes(20)= 'Message 20'
PopMes(21)= 'Message 21'
PopMes(22)= 'Message 22'
PopMes(23)= 'This will not be displayed'
PopMes(24)= 'Message 24'
PopMes(25)= 'Message 25 is the last menu item'

DO PopBox2 WITH 2,3,10,75
@ 2,29 SAY '<  MENU FOR FOXBASE >'
@ ROW()+2,10 SAY 'This menu allows more than one selection. Press the Enter'
@ ROW()+1,10 SAY 'key to select and again to unselect. Press [Ctrl][End] to'
@ ROW()+1,10 SAY 'exit with selections. Press [ESC] to abort. Press [F1] for'
@ ROW()+1,10 SAY 'more help. Each of the next menus have 25 items. The items'
@ ROW()+1,10 SAY '13, 23 and bars are not selectable.'

**  =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
**                           Three Column Menu
**  =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
** --  Set up array for tagged items flag. This is not needed if OneChoice=.T.
DIMENSION PopTag(25)    &&  Array is already set to .F.

TRow    = 13         &&  Top row of menu  Note: -1 forces auto center
LCol    = -1         &&  Left column of menu
MRow    = 24         &&  Message row
MCol    = -1         &&  Message column
MOn     = .T.        &&  Message On flag  T = display messages
MAry    =  25        &&  Elements in array
MCrt    =  7         &&  Items on CRT at any time
MTitle  = '[ Test Menu 3 Columns Wide ]'   &&    Title of menu
SCrt    = .F.        &&  Save screen flag  T = restore screen
MColor  = 'g/n,n/g,r+/n,gr+/r' &&  Colors; Menu, Highlight, Selected, NonSelectable
SCol    = 3          &&  Number of columns on screen
MWait   = 300        &&  Number of seconds before time-out
KSel    = .T.        &&  Key press will select a menu item
OneC    = .F.        &&  One Choice Menu Flag

**  --  This variable must be set up here
MenuSel=0   && start menu with first item, <=1

DO PopMenu WITH TRow,LCol,MRow,MCol,MOn,MAry,MCrt,MTitle, ;
   SCrt,MColor,SCol,MWait,KSel,OneC

RESTORE SCREEN

IF MenuSel > 0
   DO PopBox2 WITH 2,29,3+MenuSel,47
   @ 2,33 SAY 'Tagged Items'
   cnt=1
   DO WHILE cnt <= MAry
      IF PopTag(cnt)
         @ ROW()+1,32 SAY PopUp(cnt)
      ENDIF PopTag(cnt)
      cnt = cnt +1
   ENDDO
   @ ROW()+1,34 SAY 'Press Key'
   CLEAR TYPEAHEAD
   ans=INKEY(0)
   RESTORE SCREEN
ENDIF MenuSel > 0
RELEASE PopTag       &&  no longer needed

DO PopBox2 WITH 2,3,9,75
@ 2,29 SAY '<  MENU FOR FOXBASE >'
@ ROW()+2,10 SAY 'This menu allows only one selection. Press the Enter key'
@ ROW()+1,10 SAY 'to select and exit. Press [ESC] to abort. Press [F1] for'
@ ROW()+1,10 SAY 'more help. Each of the next menus have 25 items. The items'
@ ROW()+1,10 SAY '13, 23 and bars are not selectable.'

**  =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
**                          Single Column Menu
**  =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
**  --  These variables were changed by the last call to PopMenu
**  --  and must be reset
TRow    = 12         &&  Top row of menu  Note: -1 forces auto center
LCol    = -1         &&  Left column of menu
MCol    = -1         &&  Message column
**  --  These variables will change the display
MTitle  = '[ Menu Title ]'   &&    Title of menu
SCol    = 1          &&  Number of columns on screen
MColor  = 'n/g,w/n,r/n,r+/g'  &&  Colors; Menu, Highlight, Selected, NonSelectable
OneC    = .T.        &&  One Choice Menu Flag

PopMes( 1)= 'This is a one column display with seven items showing'

MenuSel=0   && start menu with first item, <=1

DO PopMenu WITH TRow,LCol,MRow,MCol,MOn,MAry,MCrt,MTitle, ;
   SCrt,MColor,SCol,MWait,KSel,OneC

RESTORE SCREEN
DO PopBox2 WITH 2,3,8,75
@ 2,29 SAY '<  MENU FOR FOXBASE >'
@ ROW()+2,10 SAY 'This menu allows only one selection. Press the Enter key'
@ ROW()+1,10 SAY 'to select and exit. Press [ESC] to abort. Press [F1] for'
@ ROW()+1,10 SAY 'more help. There is no border on menus placed at row 0 or 24.'

**  =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
**                           LOTUS Style Menu
**  =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
**      LOTUS Style Menu : MaxCrt=1  TopRow=0  MaxCol>=will fit on CRT
**  --  These variables were changed by the last call to PopMenu
**  --  and must be reset
TRow    =  0         &&  Top row of menu  Note: -1 forces auto center
LCol    = -1         &&  Left column of menu
MCol    = -1         &&  Message column
**  --  These variables will change the display
MCrt    =  1         &&  Items on CRT at any time
SCrt    = .T.        &&  Save screen flag  T = restore screen
SCol    = 10         &&  Number of columns on screen
MColor  = 'n/rb,n/w,,gr+/rb' &&  Colors; Menu, Highlight, Selected, NonSelectable
PopMes( 1)= 'This is a LOTUS style menu'

MenuSel=0   && start menu with first item, <=1

DO PopMenu WITH TRow,LCol,MRow,MCol,MOn,MAry,MCrt,MTitle, ;
   SCrt,MColor,SCol,MWait,KSel,OneC

**  =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
**                           One Line Menu
**  =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
**      One Line Menu : MaxCrt=1  TopRow#0 or #24  MaxCol>=will fit on CRT
**  --  These variables were changed by the last call to PopMenu
**  --  and must be reset
TRow    =  12        &&  Top row of menu  Note: -1 forces auto center
LCol    = -1         &&  Left column of menu
MCol    = -1         &&  Message column
**  --  These variables will change the display
MCrt    =  1         &&  Items on CRT at any time
SCol    = 10         &&  Number of columns on screen
MColor  = 'w+/r,r/w,,gr+/r' &&  Colors; Menu, Highlight, Selected, NonSelectable
PopMes( 1)= 'This is a one line menu'

MenuSel=0   && start menu with first item, <=1

DO PopMenu WITH TRow,LCol,MRow,MCol,MOn,MAry,MCrt,MTitle, ;
   SCrt,MColor,SCol,MWait,KSel,OneC

RELEASE PopUp,PopMes

SET COLOR TO GR+/B
CLEAR
DO Pm_Logo

CLEAR TYPEAHEAD
ans=INKEY(0)
IF FILE('CLR2.PRG') .OR. FILE('CLR2.FOX')
   DO clr2
ENDIF
RETURN
*: EOF: MENUTEST.PRG
