* FOXTOOLS.PRG - program to demonstrate proper use of PROCEDUREs GETVAR and
*                TIMEMATH.
*
* (c) Copyright 1987, Lytle David Smith
*                     11427 N. Tazwell Drive
*                     Louisville, KY  40241
*                     502/425-9319
*
* Version 1.00  12/05/87
*
* 
* Usage notes:
*
* These PROCEDUREs are for use with FoxBASE+ version 2.00 or above.  With some
* modifications, they could be made to run under any dBASE compatible.  By
* avoiding overuse of the extremely slow macro expansions, these PROCEDUREs are
* relatively quick (at least in FoxBASE+).  The features of FoxBASE+ that are
* exploited here include arrays, VALID clauses, UDFs, INKEY(0), and speed.
* Everything else is straight dBASE III Plus.
*
* The PROCEDURE GETVAR provides display and/or entry of a variable at a
* designated position on the screen.  It is called with several parameters that
* provide it all information required.
*
* All four standard data types (ie.:  numeric, character, date, and logical)
* are supported, as well as two additional ones, TIME and PROMPT PAD.
*
* A time consists of a five character string with a colon in the middle.
* Values for the hour range from zero to 23.  Values for the minute range from
* zero to 59. All times are in 24-hour format.
*
* A prompt pad consist of a numeric variable with a twist.  There are several
* occasions when it is necessary to have an operator enter a 'code.'  Usually
* this is something like "1=smooth, 2=rough, 3=fuzzy."  The problem with this
* is it takes a lot of room on the screen, and the only alternative is to have
* it written done somewhere (very low-tech!).  Wouldn't it be nice if you could
* store the code as a very compact one- or two-digit number in your files, but
* everytime the operator sees it, it says, "fuzzy."  And when the operator has
* to select one of the codes, he/she doesn't have to look it up.  They can
* simply use the <left> and <right> arrow keys to see all of the possible
* choices.  Or, if they already know which choice they want, they can select it
* directly by typing one of the keys corresponding to that selection.
*
* There's a catch though.  All of that information has to be stored somewhere.
* It's stored in one character string and two numbers. The character string
* contains the options as they are displayed on the screen followed by the keys
* used to select the corresponding option.  The first number contains the
* length of the options, and the second number contains the length of the keys
* for each option.
*
* Example:
*                                 Options      Keys
*                           ĿĿ
*      Options and keys -  "smoothrough fuzzy SsRrFf"
*                           6            2
*      Option length -      6              
*      Key length    -      2 
*
*      Notice how options that are shorter than six characters are padded with
*      extra blanks.  The same goes for keys.  This is important!  For this
*      reason, <space> cannot be used as a direct selection key.
*
* This may seem a little confusing, so let me explain.  The prompt pad works by
* soliciting keystrokes from the operator through INKEY(0).  INKEY(0) waits for
* a single keystroke and then returns a number between zero and 255 which
* roughly corresponds to the ASCII equivalent of the keystroke pressed. I say
* "roughly" because there are several keys, <Home> and <End> for instance,
* which do not have an ASCII equivalent.  To these keys, Ashton-Tate has
* graciously assigned the first 32 characters of the ASCII alphabet.  What we
* are doing here is taking the keys that we want to use to select each option
* and storing the ASCII equivalents of those keys in a string.
*
* Example:
*
*      For ...   we would use ...  also known as ...
*          
*      "smooth"  "S" and "s"       chr(83) and chr(115)
*      "rough "  "R" and "r"       chr(82) and chr(114)
*      "fuzzy "  "F" and "f"       chr(70) and chr(102)
*
*      Don't worry about duplications.  If two selections have the same key,
*      the operator need only strike the key several times until the desired
*      option is found.
*
* The way in which the prompt pad is stored is a type of pseudo-array.  You may
* have seen other types of pseudo-arrays that make use of the macro expansion
* capabilities of dBASE.  I avoided using macros because of the large amount of
* time required to complete the macro expansion.  The downside is that you are
* limited by the maximum string length in dBASE of 254 characters.
*
* Be creative!  Maybe you would want to assign <Home> to one selection to use
* as a default, or something.  Simply use chr(1).  Or how about assigning
* <?>, or chr(63), to "unknown."  Or maybe you want both, <Home> and <?>, to
* mean "unknown."  Go ahead.  Get wild!
*
* Example:
*                                      Options                     KeysĿ
*                           ĿĿ  Ŀ
*      Options and keys -  "smooth rough  fuzzy  unknownSs  Rr  Ff  Uu?"+chr(1)
*                                                7              4
*      Option length -      7                  
*      Key length    -      4 
*
* The UDF TIMEMATH effectively provides you with a new data type.  It allows
* math and relational operations to be performed on time in exactly the same
* way as you can already do with dates.  The only difference is that with time,
* the unit of measure is not days, but minutes.
*
* It is called with three parameters:  Expr1, Operator, Expr2.  The table below
* shows the results obtained from different types of operations.
*
*      Expr1    Operators         Expr2     Results
*             
*      time     +                 minutes = time
*      minutes  +                 time    = time
*      time     -                 time    = minutes
*      time     -                 minutes = time
*      time     <,>,<=,>=,=,<>,#  time    = logical .T. or .F.
*
* 
* Main program:
*
* Every SET PROCEDURE TO command is followed directly by a CLEAR PROGRAM
* command.  This is necessary in FoxBASE+, because of the way in which it
* caches the program files.  Whenever you issue a DO command, FoxBASE+ first
* looks in its current memory for a PROCEDURE with that name.  If it finds one,
* it DOes it.  The problem is that you might have two PROCEDURE files that both
* have a PROCEDURE in them with the same name.
*
* Example:
*
*      * MAIN.PRG                  * PROC1.PRG        * PROC2.PRG
*      SET PROCEDURE TO PROC1      PROCEDURE SUB      PROCEDURE SUB
*      DO SUB                                         
*      SET PROCEDURE TO PROC2                         
*      DO SUB                                         
*      RETURN                      RETURN             RETURN
*
*      In this example, the PROCEDURE SUB in PROC1.PRG will more than likely be
*      DOne twice in a row.  And you will probably end up racking your brains
*      trying to figure out why PROCEDURE SUB in PROC2.PRG isn't working right.
SET PROCEDURE TO DEMO
CLEAR PROGRAM
* The arrays in the following statement are DIMENSIONed here, instead of
* in PROCEDURE SETUP, because they must be available to other PROCEDUREs.
* They cannot simply be PRIVATE to SETUP.
DIMENSION Pad(4),FieldTable(6,8),Buffer(6)
DO SETUP
DO INIT
DO DISPLAY
ExitKey=0
DO READ
DO SETDOWN
SET PROCEDURE TO
CLEAR PROGRAM
RETURN

PROCEDURE SETUP
     SET STATUS OFF
     SET SCOREBOARD OFF
     SET TALK OFF
     SET ESCAPE OFF
     SET CONFIRM ON
     CLEAR
   * The file CURSOR.BIN must be present for PROCEDURE GETVAR to work.  This
   * .BIN file turns the cursor on and off.  CALL CURSOR WITH "+" turns the
   * cursor on. CALL CURSOR WITH "-" turns the cursor off.  Leaving the cursor
   * off except during operator entry provides your programs with a much more
   * finished appearance.  It accomplishes this magic through service 1 of BIOS
   * interrupt 16.
     LOAD CURSOR
     CALL CURSOR WITH "-"
   * The prompt pad is stored in the array Pad().  The reason I store it in an
   * array is because I have a database of prompt pads, and when I am ready to
   * use them, I can access them quickly and easily by SEEKing the pad name and
   * SCATTERing it TO Pad().  It could also be stored in a .MEM file, if that's
   * your preference.
     Pad(1)="TESTPAD"
     Pad(2)="Add   ChangeDeleteRecallSearchAaCcDdRrSs"
     Pad(3)=6
     Pad(4)=2
   * The array FieldTable() is used to store all of the PARAMETERS required by
   * GETVAR for each corresponding field in Buffer().  This allows us to use
   * one statement to display all fields (see PROCEDURE DISPLAY) and one to
   * edit all fields (see PROCEDURE READ).  If FieldTable() was not used for
   * this, we would have to provide a separate line of code for each field.
     FieldTable(1,1)=2
     FieldTable(1,2)=13
     FieldTable(1,3)="N"
     FieldTable(1,4)="99999.99"
     FieldTable(1,5)=""
     FieldTable(1,6)=0
     FieldTable(1,7)=0
     FieldTable(1,8)=""
     FieldTable(2,1)=3
     FieldTable(2,2)=13
     FieldTable(2,3)="C"
     FieldTable(2,4)="XXXXXXXX"
     FieldTable(2,5)=""
     FieldTable(2,6)=0
     FieldTable(2,7)=0
     FieldTable(2,8)=""
     FieldTable(3,1)=4
     FieldTable(3,2)=13
     FieldTable(3,3)="D"
     FieldTable(3,4)="@D"
     FieldTable(3,5)=""
     FieldTable(3,6)=0
     FieldTable(3,7)=0
     FieldTable(3,8)=""
     FieldTable(4,1)=5
     FieldTable(4,2)=13
     FieldTable(4,3)="L"
     FieldTable(4,4)="Y"
     FieldTable(4,5)=""
     FieldTable(4,6)=0
     FieldTable(4,7)=0
     FieldTable(4,8)=""
     FieldTable(5,1)=6
     FieldTable(5,2)=13
     FieldTable(5,3)="T"
     FieldTable(5,4)=""
     FieldTable(5,5)=""
     FieldTable(5,6)=0
     FieldTable(5,7)=0
     FieldTable(5,8)=""
     FieldTable(6,1)=7
     FieldTable(6,2)=13
     FieldTable(6,3)="P"
     FieldTable(6,4)=Pad(2)
     FieldTable(6,5)=""
     FieldTable(6,6)=Pad(3)
     FieldTable(6,7)=Pad(4)
     FieldTable(6,8)=""
RETURN

PROCEDURE SETDOWN
     CALL CURSOR WITH "+"
     SET CONFIRM OFF
     SET ESCAPE ON
     SET TALK ON
     SET SCOREBOARD ON
     SET STATUS ON
RETURN

PROCEDURE INIT
   * The array Buffer() contains all of the variables to display and edit.
   * Since most of the time you will be editing records in a .DBF file, and
   * FoxBASE+ provides us with the SCATTER TO command, it is natural to take
   * advantage of it to place our record into an array.  Storing the fields of
   * a .DBF file to an array, and then editing the array, is superior to
   * directly editing the fields of the database because it allows us to more
   * completely validate the changes before committing them to the file.
     Buffer(1)=12345.67
     Buffer(2)="ABCDEFGH"
     Buffer(3)=DATE()
     Buffer(4)=.Y.
     Buffer(5)="12:34"
     Buffer(6)=1
RETURN

PROCEDURE DISPLAY
     PRIVATE FieldNo
     @  2, 0 SAY "Number:"
     @  3, 0 SAY "Character:"
     @  4, 0 SAY "Date:"
     @  5, 0 SAY "Logical:"
     @  6, 0 SAY "Time:"
     @  7, 0 SAY "Prompt pad:"
     @ 22, 0 SAY "Press <Esc> or <^End> to end."
     FieldNo=1
     DO WHILE FieldNo<=6
          DO GETVAR WITH FieldTable(FieldNo,1),FieldTable(FieldNo,2),Buffer(FieldNo),FieldTable(FieldNo,3),FieldTable(FieldNo,4),FieldTable(FieldNo,5),FieldTable(FieldNo,6),FieldTable(FieldNo,7),FieldTable(FieldNo,8),.F.,0
          FieldNo=FieldNo+1
     ENDDO
RETURN

PROCEDURE READ
   * PROCEDURE READ provides a simulated READ command.  It is used instead of
   * READ because it allows us to use DO GETVAR commands in it, instead of
   * simply @ <coord> GET commands.
     PRIVATE FieldNo,Temp
     FieldNo=1
     DO WHILE .T.
          DO CASE
               CASE FieldNo<1
                    FieldNo=6
                    LOOP
               CASE FieldNo>=1 .AND. FieldNo<=6
                    Temp=Buffer(FieldNo)
                    DO GETVAR WITH FieldTable(FieldNo,1),FieldTable(FieldNo,2),Temp,FieldTable(FieldNo,3),FieldTable(FieldNo,4),FieldTable(FieldNo,5),FieldTable(FieldNo,6),FieldTable(FieldNo,7),FieldTable(FieldNo,8),.T.,ExitKey
                    Buffer(FieldNo)=Temp
               CASE FieldNo>6
                    FieldNo=1
                    LOOP
          ENDCASE
          DO CASE
               CASE ExitKey=16 .OR. ExitKey=15 .OR. ExitKey=5    && Return, Down Arrow
                    FieldNo=FieldNo+1
               CASE ExitKey=4                                    && Up Arrow
                    FieldNo=FieldNo-1
               CASE ExitKey=12                                   && Esc
                    EXIT
               CASE ExitKey=14                                   && CtrlEnd
                    EXIT
               OTHERWISE
                    ??CHR(7)
          ENDCASE
     ENDDO
RETURN

PROCEDURE GETVAR
   * Row -        Screen row for get
   * Col -        Screen column for get
   * Var -        Variable to get
   * VarType -    Type of variable (N=numeric; C=character; D=date; L=logical;
   *                T=time; P=prompt pad)
   * Pict -       Picture clause
   * ValType -    Type of validation (RV=RANGE and VALID; R=RANGE; V=VALID; blank=none)
   * LoRange -    Lower limit for range clause
   * HiRange -    Upper limit for range clause
   * Valid -      Valid clause
   * Read -       Do READ or CLEAR GETS (.T.=READ; .F.=CLEAR GETS)
   * ExitKey -    Exit key returned to calling program
     PARAMETERS Row,Col,Var,VarType,Pict,ValType,LoRange,HiRange,Valid,Read,ExitKey
     PRIVATE Opt,OptKey,OptCount,OptSel
     DO CASE
          CASE UPPER(LEFT(VarType,1))="P"
             *
             * Pict -       options followed by option keys
             * LoRange -    option length
             * HiRange -    option key length
             * Example:  Pict="Add   ChangeDeleteRecallSearchAaCcDdRrSs"; LoRange=6; HiRange=2
               IF .NOT. Read
                    OptSel=SUBSTR(Pict,((LoRange+HiRange)*(Var-1))+1,LoRange)
                    @ Row,Col GET OptSel
                    CLEAR GETS
               ELSE
                  * Opt -        options
                  * OptKey -     option keys
                  * OptCount -   number of options
                  * OptSel -     currently selected option
                    OptCount=LEN(Pict)/(LoRange+HiRange)
                    Opt=LEFT(Pict,LoRange*OptCount)
                    OptKey=SUBSTR(Pict,LoRange*OptCount+1,HiRange*OptCount)
                    OptSel=SUBSTR(Opt,LoRange*(Var-1)+1,LoRange)
                    @ Row,Col GET OptSel
                    @ Row,Col SAY ""
                    CLEAR GETS
                    ExitKey=0
                    DO WHILE .T.
                         CALL CURSOR WITH "+"
                         ExitKey=INKEY(0)
                         CALL CURSOR WITH "-"
                         DO CASE
                              CASE AT(STR(ExitKey,4),"   5,  24,  18,   3,  27,  23,  13")<>0
                                 * The exit key is converted from INKEY() value
                                 * to its READKEY() equivalent.  This is
                                 * because the GETVAR is supposed to be
                                 * imitating a normal READ statement, which
                                 * used READKEY().
                                   ExitKey=VAL(SUBSTR("   4,   5,   6,   7,  12,  14,  16",AT(STR(ExitKey,4),"   5,  24,  18,   3,  27,  23,  13"),4))
                                   EXIT
                              CASE ExitKey=19
                                   Var=IIF(Var-1>=1,Var-1,OptCount)
                              CASE ExitKey=4
                                   Var=IIF(Var+1<=OptCount,Var+1,1)
                              CASE AT(CHR(ExitKey),OptKey)<>0 .AND. ExitKey<>32
                                   Var=MOD(INT((AT(CHR(ExitKey),SUBSTR(REPLICATE(LEFT(OptKey,OptCount*HiRange),2),Var*HiRange+1))-1)/HiRange)+Var,OptCount)+1
                              OTHERWISE
                                   ??CHR(7)
                                   LOOP
                         ENDCASE
                         OptSel=SUBSTR(Opt,LoRange*(Var-1)+1,LoRange)
                         @ Row,Col GET OptSel
                         @ Row,Col SAY ""
                         CLEAR GETS
                    ENDDO
               ENDIF
          CASE UPPER(LEFT(VarType,1))="N" .OR. UPPER(LEFT(VarType,1))="D"
               DO CASE
                    CASE ValType=""
                         @ Row,Col GET Var PICTURE Pict
                    CASE UPPER(ValType)="R"
                         @ Row,Col GET Var PICTURE Pict RANGE LoRange,HiRange
                    CASE UPPER(ValType)="V"
                         @ Row,Col GET Var PICTURE Pict VALID &Valid
                    CASE UPPER(ValType)="RV"
                         @ Row,Col GET Var PICTURE Pict RANGE LoRange,HiRange VALID &Valid
               ENDCASE
          CASE UPPER(LEFT(VarType,1))="C" .OR. UPPER(LEFT(VarType,1))="L"
               DO CASE
                    CASE UPPER(ValType)="R" .OR. ValType=""
                         @ Row,Col GET Var PICTURE Pict
                    CASE UPPER(ValType)="RV" .OR. UPPER(ValType)="V"
                         @ Row,Col GET Var PICTURE Pict VALID &Valid
               ENDCASE
          CASE UPPER(LEFT(VarType,1))="T"
               Var=IIF(Var<>"  :  ",STR(ABS(VAL(LEFT(Var,2))),2)+":"+SUBSTR(STR(100+ABS(VAL(RIGHT(Var,2))),3),2),Var)
               DO CASE
                    CASE ValType=""
                         @ Row,Col GET Var PICTURE "##:##" VALID (VAL(LEFT(Var,2))>=0.AND.VAL(LEFT(Var,2))<=23.AND.VAL(RIGHT(Var,2))>=0.AND.VAL(RIGHT(Var,2))<=59)
                    CASE UPPER(ValType)="R"
                         @ Row,Col GET Var PICTURE "##:##" VALID (VAL(LEFT(Var,2))>=0.AND.VAL(LEFT(Var,2))<=23.AND.VAL(RIGHT(Var,2))>=0.AND.VAL(RIGHT(Var,2))<=59).AND.(TIMEMATH(Var,">=",LoRange).AND.TIMEMATH(Var,"<=",HiRange))
                    CASE UPPER(ValType)="V"
                         @ Row,Col GET Var PICTURE "##:##" VALID (VAL(LEFT(Var,2))>=0.AND.VAL(LEFT(Var,2))<=23.AND.VAL(RIGHT(Var,2))>=0.AND.VAL(RIGHT(Var,2))<=59).AND.(&Valid.)
                    CASE UPPER(ValType)="RV"
                         @ Row,Col GET Var PICTURE "##:##" VALID (VAL(LEFT(Var,2))>=0.AND.VAL(LEFT(Var,2))<=23.AND.VAL(RIGHT(Var,2))>=0.AND.VAL(RIGHT(Var,2))<=59).AND.(TIMEMATH(Var,">=",LoRange).AND.TIMEMATH(Var,"<=",HiRange)).AND.(&Valid.)
               ENDCASE
     ENDCASE
     IF Read .AND. UPPER(LEFT(VarType,1))<>"P"
          CALL CURSOR WITH "+"
          READ
          CALL CURSOR WITH "-"
          ExitKey=MOD(READKEY(),256)
          IF UPPER(LEFT(VarType,1))="T"
               Var=IIF(Var<>"  :  ",STR(ABS(VAL(LEFT(Var,2))),2)+":"+SUBSTR(STR(100+ABS(VAL(RIGHT(Var,2))),3),2),Var)
               @ Row,Col GET Var PICTURE "##:##"
          ENDIF
     ENDIF
     CLEAR GETS
RETURN

PROCEDURE TIMEMATH
     PARAMETERS Expr1,Operation,Expr2
     PRIVATE Expr3
     DO CASE
          CASE Operation="<="
               Expr3=(VAL(LEFT(Expr1,2))*60+VAL(RIGHT(Expr1,2))<=VAL(LEFT(Expr2,2))*60+VAL(RIGHT(Expr2,2)))
          CASE Operation=">="
               Expr3=(VAL(LEFT(Expr1,2))*60+VAL(RIGHT(Expr1,2))>=VAL(LEFT(Expr2,2))*60+VAL(RIGHT(Expr2,2)))
          CASE Operation="<"
               Expr3=(VAL(LEFT(Expr1,2))*60+VAL(RIGHT(Expr1,2))<VAL(LEFT(Expr2,2))*60+VAL(RIGHT(Expr2,2)))
          CASE Operation=">"
               Expr3=(VAL(LEFT(Expr1,2))*60+VAL(RIGHT(Expr1,2))>VAL(LEFT(Expr2,2))*60+VAL(RIGHT(Expr2,2)))
          CASE Operation="="
               Expr3=(VAL(LEFT(Expr1,2))*60+VAL(RIGHT(Expr1,2))=VAL(LEFT(Expr2,2))*60+VAL(RIGHT(Expr2,2)))
          CASE Operation="<>" .OR. Operation="#"
               Expr3=(VAL(LEFT(Expr1,2))*60+VAL(RIGHT(Expr1,2))#VAL(LEFT(Expr2,2))*60+VAL(RIGHT(Expr2,2)))
          CASE Operation="+"
               DO CASE
                    CASE TYPE("Expr1")="C" .AND. TYPE("Expr2")="N"
                         Expr3=VAL(LEFT(Expr1,2))*60+VAL(RIGHT(Expr1,2))+Expr2
                         Expr3=STR(MOD(INT(Expr3/60),24),2)+":"+SUBSTR(STR(MOD(Expr3,60)+100,3),2)
                    CASE TYPE("Expr1")="N" .AND. TYPE("Expr2")="C"
                         Expr3=Expr1+VAL(LEFT(Expr2,2))*60+VAL(RIGHT(Expr2,2))
                         Expr3=STR(MOD(INT(Expr3/60),24),2)+":"+SUBSTR(STR(MOD(Expr3,60)+100,3),2)
               ENDCASE
          CASE Operation="-"
               DO CASE
                    CASE TYPE("Expr1")="C" .AND. TYPE("Expr2")="C"
                         Expr3=(VAL(LEFT(Expr1,2))*60+VAL(RIGHT(Expr1,2)))-(VAL(LEFT(Expr2,2))*60+VAL(RIGHT(Expr2,2)))
                    CASE TYPE("Expr1")="C" .AND. TYPE("Expr2")="N"
                         Expr3=VAL(LEFT(Expr1,2))*60+VAL(RIGHT(Expr1,2))-Expr2
                         Expr3=IIF(Expr3>=0,Expr3,Expr3+((INT(Expr3/-1440)+1)*1440))
                         Expr3=STR(MOD(INT(Expr3/60),24),2)+":"+SUBSTR(STR(MOD(Expr3,60)+100,3),2)
               ENDCASE
     ENDCASE
RETURN Expr3
