************************************************************************
** Demo program for FOXPCX.PLB   									   *
** (c) 1991-94 Master Creative Software, Inc.						   *
** Please feel free to use any or all of this code in your app		   *
************************************************************************
* Last Updated 10/27/94 1:45pm WSM


Clear all
Close All
Clear
Set Talk off
Set Echo Off
Set Escape off
set textmerge  show

Use DRIVERS

Public _MEMTYP,_LRGEBUF

Set sysmenu on
Define Window PRNWIND from 0,0 to 23,79 TITLE ;
" [ FOXPCX Documentation ]"  PANEL COLOR w/n,n/w,w/n
Set sysmenu off


Define Popup WhichDrv Prompt Field DESC Footer "Select Screen Driver"
On Selection POPUP WhichDrv DO View With Prompt(),PCX_FILE

DEFINE POPUP MEM MARGIN RELATIVE SHADOW COLOR SCHEME 4

DEFINE BAR 1 OF MEM PROMPT 'Use \<XMS Memory' 
DEFINE BAR 2 OF MEM PROMPT 'Use FOXPCX \<Virtual Memory System' 

ON SELECTION POPUP MEM	DO MEMchoice WITH BAR()

DEFINE POPUP BUF MARGIN RELATIVE SHADOW COLOR SCHEME 4
DEFINE BAR 1 OF BUF PROMPT 'Use Small 4K Page Buffer' 
DEFINE BAR 2 OF BUF PROMPT 'Use Large 8K Page Buffer' 
ON SELECTION POPUP BUF	DO BUFchoice WITH BAR()

Clear
Do Displogo
Wait Window
Do While .T.
	Clear
	Do Displogo
	PCX_file = GETFILE('PCX', 'Select PCX File to View',"Browse",1)
	if empty(PCX_FILE)
		exit
	Endif
	@24,0 say padc("Hit <Esc>-To Exit",80)
	activate popup MEM
	activate popup BUF
	Activate POPUP WhichDrv
Enddo

clear
modi file FOXPCX.DOC NOMOD WINDOW PRNWIND
Release Window PRNWIND
USE
Clear all
clear
Set Libr to
do displogo



***************************************************************
Procedure View
***************************************************************
Parameters DRV,PCX_FlE
Clear
Hide POPUP WhichDrv

@21,0 Say Padc("Will Display PCX File "+PCX_FLE+" With :"+DRV,80)
Wait "Strike any key to View PCX File" Window
Set Talk on

if "2.0" $version() 
	set libr to foxpcx20
else
    set libr to foxpcx
endif
	
_FRet=ViewPCX(PCX_FLE,@DRIVER,_MEMTYP,_LRGEBUF,0)
Set Talk off
Set Libr To
Clear
Wait "FoxPCX Returned "+Transf(_Fret,"999")+" = "+PCX_ERROR(_Fret) Timeout 2
Deactivate POPUP WhichDrv
Return


******************************************************************
PROCEDURE MEMchoice
******************************************************************
PARAMETERS _MT

_MEMTYP = _MT - 1

Deactivate POPUP MEM


******************************************************************
PROCEDURE BUFchoice
******************************************************************
PARAMETERS _MT

_LRGEBUF=_MT-1

Deactivate POPUP BUF


************************************
Procedure PCX_ERROR
***********************************
Parameters _ER

do case
Case _ER=0
	return "No Errors Detected"
	* Success !
Case _ER=100

	return "XMS driver not detected"
	** XMS Memory Requested and not available
	** XMS Driver may not be loaded or not enough XMS free
	** make sure HIMEM or a memory manager like QEMM is loaded

Case _ER=101
	return "Error allocating XMS memory block"
	** Probably not enough XMS.

Case _ER=102
	return "Error allocating VMS memory block"
	** Virtual memory manager failure. Check your disk space.

Case _ER=103
	return "Error writing XMS memory block"

Case _ER=104
	return "Error reading XMS memory block"
Case _ER=105
	return "Error writing VMS memory block"
	** Error Writing to Virtual memory Swap File. Check Disk Space.

Case _ER=106
	return "Error reading VMS memory block"
	** Error Reading Virtual memory Swap File. Check Disk .

Case _ER=107
	return "Error decoding PCX Image"
	** Error PCX Decoder Error. PCX file could be damaged.

Case _ER=108
	return "file i/o error"
Case _ER=109
	return "FOXPRO memory allocation error"
	** Remove TSR and/or other PLB files Etc..

Case _ER=110
	return "error loading screen driver"
	** Check to see if the driver is valid and exists.

Case _ER=111
	return "error calling screen driver"
Case _ER=112
	return "invalid driver "
	* Not a Supported Driver  OR
	* driver file probably damaged.

Case _ER=113
	return "error opening file"
Case _ER=114
	return "FOXPCX requires VGA or better"
Case _ER=115
	return "error opening PCX image"
Case _ER=116
	return "error allocating XMS"
Case _ER=117
	return "Error in Parameter 1"
Case _ER=118
	return "Error in Parameter 2"
Case _ER=119
	return "Error in Parameter 3"
Case _ER=120
	return "Error in Parameter 4"
Case _ER=121
	return "This is not a PCX file"
Case _ER=122
	return "driver load error (size)"
Case _ER=123
	return "error allocating driver resources"
Case _ER=124
	return "driver does not support > 256 Colors"
EndCase






 
 
 
 
 
 
*******************************
Procedure Displogo
*******************************
@7,0 Say ""
TEXT
                                        
                                           
                                            
                                           
                                                
                                          
                                             
ENDTEXT
@18,0 Say padc("FOXPCX DEMO Version 3.0",80)
@19,0 Say padc("(c) 1991-94 Master Creative Software, Inc",80)
@20,0 Say padc("Compuserve 70713,2002 BBS 201-585-7002",80)

Return







 


