***************************************************************************
*                                                                         *
* PROGRAM:   Fxmain.prg                                                   *
*            FoxIt start program                                          *
*                                                                         *
*            FoxIt means RAD (Rapid Application Development)              *
*                                                                         *
* (c)        Ajan Tietotekniikka ATT Oy 1992                              *
* Author     Tapani Isoranta                                              *
*                                                                         *
* Address    Itlahdenkatu 21 A                                           *
*            00210 Helsinki                                               *
*            Finland                                                      *
*                                                                         *
* Tel        (358)-0-671699                                               *
* Fax        (358)-0-671761                                               *
*                                                                         *
* Compuserve 100021,3453                                                  *
*                                                                         *
* Notes      All code is in lower mode. It is easy to format all FoxPro   *
*            words to UPPER with Walter Kennamer's snap SNIPFMT program   *
*            SNIPFMT is one of the FoxPro Goodies                         *
*                                                                         *
***************************************************************************

* FoxIt system databases use fx-prefix
*
* g_fx-beginning variables are FoxIt system variables
*

  public g_quit,;
         g_prog,;
         g_curmenu,;
         g_add,;
         g_edit,;
         g_interact,;
         g_browse,;
         g_fxproj,;
         g_fxlib,;
         g_fxmenu,;
         g_fxdata,;
         g_fxscreen,;
         g_fxreport,;
         g_fxhelp,;
         g_fxlookup

  * reset environment
  set talk off
  clear
  close database

  * check files definition in config.sys
  if val(sys(2010)) < 65
    ?? chr(7)
    wait "In config.sys FILES="+sys(2010)+" too low for FoxIt!";
        window timeout 2
  endif

  * set foxit global definitions
  g_fxresour   = "fxuser"              && foxit resource file
  g_fxproj     = "fxproj"              && project name
  g_fxlib      = "fxlib"               && general library
  g_fxmenu     = "fxmenu"              && main menu
  g_fxdata     = "fxdata"              && datadictionary db
  g_fxscreen   = "fxscreen"            && screen dictionary db
  g_fxreport   = "fxreport"            && report dictionary db
  g_fxhelp     = "fxhelp"              && help database
  g_fxlookup   = "fxlookup"            && generic lookup database

  * set menu
  push menu _msysmenu
  g_curmenu = set("sysmenu")
  set sysmenu automatic

  * old help
  g_oldhelp = set("help",1)

  * set foxit resource file
  if file(g_fxresour+".dbf")
    set resource to (g_fxresour)
    set color set to default
  endif

  * set procedure
  set procedure to (g_fxlib)

  * set help
  set help to (g_fxhelp)
  on key label F1 help

  * general sets
  set safety off
  set delete on
  ** set date to dmy          && european date !

  * exclusive off in shared database use
  set exclusive off

  set udfparms to reference

  * set error procedure
  on error do errproc with program(),lineno(),message(),error()

  * disable excape key
  on key label Escape ?? chr(7)
  on key label Ctrl+W ?? chr(7)

  g_quit = .F.  && exits foundation
  g_prog = ""   && program name

  * data entry status variables
  g_add        = .F.   && add a record
  g_edit       = .F.   && change a record
  g_browse     = .F.   && browse state
  g_interact   = .F.   && use interactively FP powertools

  * FX menu-system
  do (g_fxmenu)+".mpr"

  read valid eventhand()    && here is the foundation read

  * reset system again
  set talk on
  close database

  pop menu _msysmenu
  set sysmenu &g_curmenu

  if not empty(g_oldhelp)
    set help to (g_oldhelp)
  endif

  set exclusive on
  set procedure to
  on key
  on error
  clear all


* FUNCTION: eventhand
* General simple eventhandler
* Notes: program name is same as the window name
*

Function eventhand

  private l_temp,;
          l_curwin

  if g_quit
    return .T.
  endif

  if len(g_prog) > 0
    l_temp = g_prog
    g_prog = ""
    do &l_temp
    return .F.
  endif

  * window name match to window program name
  l_curwin = wontop()

  do case
    case file(l_curwin+".spr")
      do l_curwin+".spr"
    case file(l_curwin+".spx")
      do l_curwin+".spx"
    case file(l_curwin+".prg")
      do l_curwin+".prg"
  endcase
  return .F.
