*******************************************************************
*PROGRAM: FaxDemo    DATE WRITTEN: 07/28/94 BY: Chuck Milbourne
*                    LAST CHANGED:   /  /   BY:
*PURPOSE: Demonstrates how to fax a report from FoxPro for Windows
*         via DDE calls to WinFax.  Read the file WinFax for 
*         background and mea culpas.	
*CHANGE :
*******************************************************************
*
* SUSPEND execution if in debug mode.
*
   IF SET("ECHO")="ON"
     ACTIVATE WINDOW Trace
     SUSPEND
   ENDIF
*
   CLEAR
*
*  Allow up to five seconds for a response from WinFax.
*  (This is precautionary and almost certainly not needed.)
*
   bResult = DDESETOPTION("TIMEOUT",5000)
*
*  Establish channel to WinFax.  
*
*  (FAXMNG.EXE is the WinFax Program which I assume is in the
*   subdirectory \WINFAX.  I haven't figured out a way to suppress
*   the "yes/no" window which FoxPro displays when WinFax is not
*   already up and running -- but I didn't try very hard.  (Using
*   "RUN /n ..." results in the display of WinPro's main menu 
*   which I find confusing.)
*
   m.Directory = sys(2003)
   SET DEFAULT TO \WINFAX
   nChannel = DDEInitiate("FAXMNG","CONTROL")
   SET DEFAULT TO (m.Directory)
   DO TestDDECall WITH DDELASTERROR(),"DDEINITIATE"
*
*  Set "recipient" and "event" details (see Pg. 11-6 in WinFax
*  4.0 User's Guide).
*
   cFaxNo      = ALLTRIM("7161088")
   cTime       = time()          
   cDate       = DTOC(DATE()+365)          
   cName       = ALLTRIM("Ava Milbourne")       
   cCompany    = ALLTRIM("Real Estate Education Services")     
   cSubject    = "This is a test of WinFax."  
   cKeyWords   = "Test Ava"           
   cBillCodes  = "FOB "                  
* 
* Put all details together for subsequent DDE Poke ... 
*
  recipient = 'recipient("'+(cFaxNo)+'","'+(cTime)+'",;
     "'+(cDate)+'","'+(cName)+'","'+(cCompany)+'",;
     "'+(cSubject)+'","'+(cKeyWords)+'","'+(cBillCodes)+'")'
*
* Tell WinFax where the fax will be going.

  bResult = DDEPOKE(nChannel,"Sendfax",(recipient))  
  DO TestDDECall WITH DDELASTERROR(),"DDEPOKE"
*
* The variable cDefaultP is set by PrintSel() (see below).
* When set, it will hold the name of the printer just before the
* call to PrintSel (e.g., "HP LaserJet Plus on LPT1").
*
* [Note:  PrintSel() is from  Wayne A. Willingham/Survivor
*  Software (CIS: 76170,2016) -- thanks Wayne.]
*
   cDefaultP=''  
*
* When the report is "Printed", it will be intercepted and faxed
* (or scheduled) by WinFax.
*
   DO PRINTSEL WITH 'WINFAX'
*
* Just insert any report here. 
*
* (I gave up trying to use @...SAY despite two hours of trial
*  and error.  Despite every attempt to print the report to 
*  WinFax, these programs insisted on sending the report
*  to my printer.  I gave up. But "REPORT FORM ..." works great.)
* 
   ? "    This may take awhile."         FONT "MS SANS SERIF",24 
   ? " "
   ? "    Be patient."                   FONT "MS SANS SERIF",24
   ? " "
   ? "    When you receive the 'Done' "  FONT "MS SANS SERIF",24
   ? "    message, press <Enter>, then"  FONT "MS SANS SERIF",24
   ? "    switch to WinFax (<Alt><Tab>)" FONT "MS SANS SERIF",24
   ? "    and look in the 'Out Box'."    FONT "MS SANS SERIF",24
   ? 
*
   IF NOT USED("FaxDemo")
     USE FaxDemo IN 0
   ENDIF     
   REPORT FORM faxdemo TO PRINTER NOCONSOLE
*
* Restore printer.
*   
   DO PRINTSEL WITH cDefaultP
*
* Tell WinFax we're through.
*
   bResult=DDETERMINATE(nChannel)
   DO TestDDECall WITH DDELASTERROR(),"DDETERMINATE"
   WAIT WINDOW "DONE!"
*__________________________________________________________________
   Procedure TestDDECall
   PARAMETER nErrorCode,cCallName
   PRIVATE cError
   DO CASE
      CASE nErrorCode = 0
         cError=" "
         RETURN
*
* These codes are from Bob Gromme's book, _Inside FoxPro 2.5_,
* pages 1074 and 1075.  
*
      CASE nErrorCode = 1
         cError="Service busy" 
      CASE nErrorCode= 2
         cError="Topic busy" 
      CASE nErrorCode= 3
         cError="Channel busy" 
      CASE nErrorCode= 4
         cError="No such service" 
      CASE nErrorCode= 5
         cError="No such topic" 
      CASE nErrorCode= 6
         cError="Bad channel" 
      CASE nErrorCode= 7
         cError="Insufficient memory" 
      CASE nErrorCode= 8
         cError="Acknowledge timeout" 
      CASE nErrorCode= 9
         cError="Request timeout" 
      CASE nErrorCode= 10
         cError="No DDEInitiate()" 
      CASE nErrorCode= 11
         cError="Client attempted server transaction" 
      CASE nErrorCode= 12
         cError="Execute timeout" 
      CASE nErrorCode= 13
         cError="Bad parameter" 
      CASE nErrorCode= 14
         cError="Low memory" 
      CASE nErrorCode= 15
         cError="Memory error" 
      CASE nErrorCode= 16
         cError="Connect failure" 
      CASE nErrorCode= 17
         cError="Request failure" 
      CASE nErrorCode= 18
         cError="Poke time-out" 
      CASE nErrorCode= 19
         cError="Could not display message" 
      CASE nErrorCode= 20
         cError="Multiple synchronous transactions" 
      CASE nErrorCode= 21
         cError="Server died" 
      CASE nErrorCode= 22
         cError="Internal DDE error" 
      CASE nErrorCode= 23
         cError="Advise timeout" 
      CASE nErrorCode= 24
         cError="Invalid transaction identifier" 
      CASE nErrorCode= 25
         cError="Unknown DDE error" 
      CASE nErrorCode= 26
         cError="Cannot Establish Channel" 
   ENDCASE
   WAIT WINDOW "Error in DDE Call ("+cCallName+"):  "+cError+;
      ".  (DDE NO:"+ ALLTRIM(STR(nErrorCode))+")." 
   bResult=DDETERMINATE(nChannel)
   CANCEL
     
