********************************************************************************
*  CALC.PRG - This program is a floating point electronic calculator written   *
*             in the Dbase III + programming language. The program author      *
*             has placed this program in the Public Domain.     Dan Kenny 5/88 *
********************************************************************************
********************************************************************************
*  CALC.PRG - FoxBase+ version. This is a modified version of Dan Kenny's
*             program, altered to make use of FoxBase commands. A few
*             bells and whistles were added like square root, percentage,
*             the way decimals are handled, Mem + and Mem -, a flashier
*             screen, and flashing numbers. The Flash procedure uses
*             Attrib.bin. Attrib is just a routine that sets the character
*             attribute for a given area. CALL Attrib WITH
*             row,col,endrow,endcol,attr. Attrib writes directly to screen
*             memory, but you can modify it as you like.
*             No claims are made as to the elegance of the code here,
*             but if you like it, use it. It'll make your users happy.
*                                         Rick Gerlach    May, 1989
********************************************************************************
****************************
* Set environmentals       *
****************************
SET DEBUG OFF
SET ECHO OFF
SET TALK OFF
SET ESCAPE OFF
SET STEP OFF
SET BELL OFF
SET COLOR OFF
SET CONFIRM OFF
SET CONSOLE ON
SET DELETED ON
SET DELIMITER OFF
SET DOHISTORY OFF
SET HEADING OFF
SET HISTORY OFF
SET MENU OFF
SET PRINT OFF
SET SAFETY OFF
SET SCOREBOARD OFF
SET STATUS OFF
SET UNIQUE OFF
SET DECIMALS TO 2
SET FIXED ON
SET PROCEDURE TO Calc
LOAD Attrib
DO Main
PROCEDURE Main
****************************
* Define and Set variables *
****************************
esc=27
operand1 = 0
operand2 = 0
result   = 0
decount = 2
plus=43
minus=45
multiply=42
divide=47
eq=61
sq=251
percent=37
loperator = eq
key = 0
col  = 24
equalsmode = .T.
firstpass = .T.
memexist = .F.
oper2str = ""
memstr = ""
picstring = "9999999999.99"
****************************
* Build Screen Display     *
****************************
CLEAR
DO Cals.FMT
DO Sayer WITH 1
****************************
* Main program control     *
****************************
DO WHILE key # esc                           && Escape exits
   @ 6, col SAY ""
   key = 0
   key=INKEY(0)
   key=IIF(key=13,eq,key)                     && Xlate <cr> - =
   DO Flash WITH key
   key=IIF(key=112.OR.key=80,37,key)          && Xlate p - %, s - sqrt
   key=IIF(key=115.OR.key=83,251,key)
   ckey=IIF(key<0,"X",CHR(key))
   DO CASE
****************************
* Input = ESC              *
****************************
      CASE key=esc                            && LOOP on Escape
        LOOP
****************************
* Input = (*)(+)(/)(+)(=)  *
****************************
      CASE ckey $ "/+-*=%"                     && Operators (/,+,-,*,=)
           IF key = minus                                   && Minus Sign:
              IF ""=oper2str .AND. loperator # eq           && Assign '-' to
                 oper2str = "-"                             && input (neg val)
                 @  6, col SAY "-"
                 col = col + 1                          
                 LOOP
              ENDIF
              IF oper2str = "-"                             && Toggle IF already
                 oper2str = ""                              && one there and
                 @  6, col-1 SAY " "                        && change stacked
                 col = col - 1                              && operator to '-'
                 loperator = key
                 @ 3, 34 SAY CHR(loperator)
                 LOOP
              ENDIF
           ENDIF

           IF key = eq                                      && Equals Sign:
              @  3, 34 SAY " "
              IF equalsmode .AND. ""=TRIM(oper2str)         && Equals was last
                 loperator = key                            && key-no input
                 LOOP
              ELSE
                 equalsmode = .T.                           && Otherwise,
              ENDIF                                         && turn equalsmode
           ENDIF                                            && on-process input

           IF equalsmode                                    && Equalsmode:
              IF ""=TRIM(oper2str)                          && Blank out current
                 loperator = key                            && operator IF no
                 @ 3, 34 SAY IIF(key=eq," ",CHR(loperator)) && input; keep
                 LOOP                                       && equalsmode on
              ELSE
                 IF key # eq                                && Otherwise,
                    equalsmode = .F.                        && toggle off and   
                    firstpass = IIF(loperator=eq,.T.,.F.)   && process as a
                 ENDIF                                      && firstpass IF
              ENDIF                                         && IF last "mode"
           ENDIF                                            && was equalsmode
           
           IF firstpass                                     && Firstpass:
              firstpass = .F.                               && firstpass merely
              result = VAL(oper2str)                        && assigns input
              loperator = key                               && to result, and
              operand1 = 0                                  && stacks the
              operand2 = 0                                  && operator for 
             IF key=sq
              operand1 = VAL(oper2str)
              operand2 = 0
              result=SQRT(ABS(operand1))
             ENDIF
              DO Sayer WITH 2
              @  3, 34 SAY ckey
              col = 24
              @ 6, col SAY SPACE(13)
              operand1 = result
              oper2str = ""
              LOOP
           ENDIF

           IF ""=TRIM(oper2str).AND.key#sq                  && IF no input,
              loperator = key                               && then change the
              @ 3, 34 SAY CHR(loperator)                    && stacked operator
              LOOP                                          && LOOP to top
           ENDIF

           operand2 = VAL(oper2str)                         && Process operator:
           ops=operand2
           IF key=percent
             operand2=(operand2/100)
             IF loperator=plus.OR.loperator=minus
               operand2=operand2*operand1
             ENDIF
           ENDIF
           IF key=sq
             IF operand2=0.AND.result#0
               result=SQRT(ABS(result))
             ELSE
               result=SQRT(ABS(operand2))
             ENDIF
             loperator=key
           ENDIF
           DO CASE
              CASE loperator = multiply
                   result = operand1 * operand2
              CASE loperator = plus
                   result = operand1 + operand2
              CASE loperator = minus
                   result = operand1 - operand2
              CASE loperator = divide
                   result = operand1 / operand2
           ENDCASE
           operand2=ops
           DO Sayer WITH 1
           @  0, 34 SAY CHR(loperator)
           @  1, 34 SAY IIF(key#percent," ",ckey)
           @  3, 34 SAY IIF(key=eq.OR.key=percent," ",ckey) && Don't display (=)
           loperator = key
           col = 24
           @ 6, col SAY SPACE(13)                           && Set up for next
           operand1 = result                                && operation  
           oper2str = ""
           LOOP
****************************
* Input = (.) or (1 thru 9)*
****************************
      CASE key = 46 .OR. (key >= 48 .AND. key <= 57)        && Period (.) and
                                                            && numbers (1-9):
           IF LEN(oper2str) = 13                            && Upper limit of
              ?? CHR(7)                                     && input = 13 chrs
           ELSE
              IF key=46.AND."." $ oper2str                  && No more than
                LOOP                                        && one dec point
              ENDIF
              oper2str = oper2str + ckey                    && Otherwise, add
              @ 6, col SAY ckey                             && digit as char
              col = col + 1                                 && to input string
           ENDIF
           LOOP
****************************
* Input = Backspace       *
****************************
      CASE key = 8 .OR. key = 127                           && Backspace:

           IF ""=oper2str                                   && Beep IF there
              ?? CHR(7)                                     && ain't anything
           ELSE
              oper2str = LEFT(oper2str,LEN(oper2str)-1)     && Otherwise,
              col = col - 1                                 && shorten input 
              @ 6, col SAY " "                              && string
           ENDIF
           LOOP
****************************
* Input = A : Clear       *
****************************
      CASE ckey $ "aA"                                      && Clear:
           operand1 = 0                                     && Init values and
           operand2 = 0                                     && the input string
           result   = 0      
           oper2str = ""
           DO Sayer WITH 3
           firstpass = .T.                                  && Init more stuff
           loperator = eq
           col = 24
           @ 6, col SAY SPACE(13)
           LOOP
****************************
* Input = C : Clear Entry *
****************************
      CASE ckey $ "cC"                                      && Clear Entry:
           oper2str = ""                                    && Init input string
           col = 24
           @ 6, col SAY SPACE(13)
           LOOP
*****************************
* Input = F1 : Mem Recall   *
*****************************                               
      CASE key = 28                                         && Mem to Entry:
           oper2str = memstr                                && Replace input
           col = 24                                         && string with mem
           @ 6, col SAY SPACE(13)                           && string and
           @ 6, col SAY oper2str                            && display
           col = col + LEN(oper2str)
           LOOP
********************************
* Input = F2 or F3: Assign Mem *
********************************
      CASE key = -1 .OR. key = -2                           && Assign Mem:
           IF ! memexist                                    && IF mem isn't
              @  3, 44 SAY "  Memory Contents    "          && on, display
              @  4, 45 TO 6,61
              memexist = .T.
           ELSE                                             && Otherwise,
              @  5, 46 SAY SPACE(13)                        && clear existing
           ENDIF
           IF key = -1                                      && F2=Mem Add
              tmem=VAL(memstr)
              tmem=tmem+result
              memstr = TRIM(TRANSFORM(tmem,"@ZB "+picstring))
           ELSE                                             && F3=Mem Subtract
              tmem=VAL(memstr)
              tmem=tmem-result
              memstr = TRIM(TRANSFORM(tmem,"@ZB "+picstring))
           ENDIF
           @  5, 46 SAY memstr                              && Display
           LOOP
****************************
* Input = F4 : Clear Mem   *
****************************
      CASE key = -3                                         && Clear Mem:
           IF memexist                                      && Init mem string
              memstr = ""                                   && and clear mem
              @  3, 44 clear to 6,61                        && display
              memexist = .F.
           ENDIF
           LOOP
****************************
* Input = D : Decimals    *
****************************                                && Decimals:
      CASE ckey $ "dD"
           @ 6,25 SAY "Decimals? " GET decount PICTURE "9" range 0,9
           READ
           @ 6,25 SAY SPACE(13)                            && Get new number
           IF MOD(READKEY(),256) # 12
              IF decount # 0
                 picstring = REPLICATE("9",12-decount)+"."+REPLICATE("9",decount)
              ELSE
                 picstring = "9999999999999"
              ENDIF
              SET DECIMALS TO decount
              DO Sayer WITH 1
           ENDIF
           LOOP
*****************************
* Input = None of the Above *
*****************************           && Decimals:
      OTHERWISE                         && IF the keypress
           ?? CHR(7)                    && was bad, beep
   ENDCASE
ENDDO
CLEAR
RETURN && Main

PROCEDURE Flash
PARAMETER key
PRIVATE row,col,akey,roff,coff,st,cnt
akey=IIF(key>0,CHR(key),"X")
DO CASE
  CASE akey$"0147aASs"
    col=7
  CASE akey$"258/dD"
    col=12
  CASE akey$"369*.pP"
    col=17
  CASE akey$"cC".OR.key=28.OR.(key<0.AND.key>-4)
    col=29
  CASE akey$"-+="
    col=23
  OTHERWISE
    RETURN
ENDCASE
DO CASE
  CASE akey$"0.".OR.key=-3
    row=20
  CASE akey$"123=".OR.key=-2
    row=17
  CASE akey$"456".OR.key=-1
    row=14
  CASE akey$"789+".OR.key=28
    row=11
  CASE akey$"cCaA/*-"
    row=8
  CASE akey$"sSdDpP"
    row=5
ENDCASE
coff=4
roff=2
IF akey="0"
  coff=9
ENDIF
IF akey$"+="
  roff=5
ENDIF
IF key=28.OR.(key<0.AND.key>-4).OR.akey$"cC"
  coff=6
ENDIF
st=CHR(row)+CHR(col)+CHR(row+roff)+CHR(col+coff)+CHR(112)
CALL Attrib WITH st
cnt=0
DO WHILE cnt<40
 cnt=cnt+1
ENDDO
st=LEFT(st,4)+CHR(7)
CALL Attrib WITH st
RETURN && Flash

PROCEDURE Sayer
PARAMETER fmt
  DO CASE
    CASE fmt=1
      @  0,20 SAY operand1  PICTURE picstring
      @  1,20 SAY operand2  PICTURE picstring
      @  3,20 SAY result    PICTURE picstring
    CASE fmt=2
      @  0,20 SAY operand1  PICTURE picstring+"  "
      @  1,20 SAY result    PICTURE picstring+"  "
      @  3,20 SAY result    PICTURE picstring
    CASE fmt=3
      @  0,20 SAY operand1  PICTURE picstring+"  "
      @  1,20 SAY operand2  PICTURE picstring
      @  3,20 SAY result    PICTURE picstring+"  "
  ENDCASE
RETURN && Sayer
