*********************************************************************
* Skeleton Amortization Program                                     *
* E. Scott Jones                                                    *
* Public Domain                                                     *
*                                                                   *
* Term In Months example:    360 (30 years x 12 months)             *
* Interest Rate example:       9                                    *
* Loan Amount example:    100000                                    *
*                                                                   *
* FUNCTIONS: start_up()               - Initialization              *
*            amort_ize()              - Main body                   *
*            cy_cle(param, param)     - Loop thru payments          *
*            int_erest()              - Calculate mnthly interest   *
*            pri_ncipal(param)        - Calculate mnthly principal  *
*            bal_ance(param)          - Calculate remaining balance *
*            close_down()             - Clean up                    *
*                                                                   *
* UDFPARMS are SET TO REFERENCE because we are modifying params     *
*                                                                   *
*********************************************************************

= start_up()
= amort_ize()
= close_down()

RETURN
*******************************************************************
*                           START_UP                              *
*******************************************************************
FUNCTION start_up
PUBLIC lamount, rate, term, pmt
PRIVATE acol

CLEAR
SET TALK OFF

STORE 0 TO lamount, rate, term, pmt

@ 2, 5 SAY "Term In Months"
@ 4, 5 SAY "Interest Rate"
@ 6, 5 SAY "Loan Amount"

acol = 5 + LEN("Term In Months ")

@ 2, acol GET term    PICTURE "999"        SIZE 1, 10
@ 4, acol GET rate    PICTURE "99.999"     SIZE 1, 10
@ 6, acol GET lamount PICTURE "9999999999" SIZE 1, 10
READ

pmt = PAYMENT(lamount, rate/1200, term)

IF LASTKEY() == 27
	CLEAR
	CANCEL
ENDIF
RETURN
*******************************************************************
*                          AMORT_IZE                              *
*******************************************************************
FUNCTION amort_ize
PRIVATE header, x, arow

arow = 5

header = "Pmt #          Payment         Principal         Interest;
          Balance"

CLEAR

@ 2, 0 SAY PADC(header, 80, ' ')
@ 3, 0 TO 3, 79

@ 4, 65 SAY lamount PICTURE "9999999999.99"

SET UDFPARMS TO REFERENCE
FOR x = 1 TO term
	= cy_cle(arow, x)
ENDFOR
SET UDFPARMS TO VALUE
RETURN
*******************************************************************
*                              CY_CLE                             *
*******************************************************************
FUNCTION cy_cle
PARAMETER crow, iter
PRIVATE i, p, b

i = int_erest()
p = pri_ncipal( i )
b = bal_ance( p )

@ crow,  5 SAY iter PICTURE "999"
@ crow, 17 SAY pmt  PICTURE "9999.99"
@ crow, 32 SAY p    PICTURE "999999.99"
@ crow, 50 SAY i    PICTURE "999999.99"
@ crow, 65 SAY b    PICTURE "9999999999.99"

crow = crow + 1
IF crow >= 25 .OR. iter >= term
	crow = 5
	= INKEY(0, 'H')
	IF LASTKEY() == 27
		CLEAR
		CANCEL
	ENDIF
	@ 4, 0 TO 24,79 CLEAR
ENDIF
RETURN .T.
*******************************************************************
*                           INT_EREST                             *
*******************************************************************
FUNCTION int_erest
PRIVATE inter
inter = (lamount * rate)/1200
RETURN inter
*******************************************************************
*                           PRI_NCIPAL                            *
*******************************************************************
FUNCTION pri_ncipal
PARAMETER irate					&& Passing int_erest() as param
PRIVATE prin
prin = pmt - irate
RETURN prin
*******************************************************************
*                            BAL_ANCE                              *
*******************************************************************
FUNCTION bal_ance
PARAMETER pr					&& Passing pri_ncipal() as param
PRIVATE nbal
nbal = lamount - pr
lamount = nbal					&& Make sure to reset new balance
RETURN nbal
*******************************************************************
*                           CLOSE_DOWN                            *
*******************************************************************
FUNCTION close_down
SET TALK ON
CLEAR
RETURN

* ---> eof()
