FUNCTION ar_seek
PARAMETERS seek_str, ar_name, col_no
PRIVATE seek_str, ar_name, col_no, pcount, rvalue
PRIVATE a_len, one_dim, e_mess

************************************************************
*  ar_seek(<exp>,<expC>[,<expN>])                          *
*  Version # 1.0  FP          Date: 01-18-90               *
*  Programmed by: Malcolm C. Rubel                         *
*                                                          *
*  Copyright (c) 1990                                      *
*  Performance Dynamics Associates                         *
*  All Rights Reserved                                     *
*                                                          *
*  Note: Function seeks an exact match for <expC1> in the  *
*  first column of the array named in <expC2>.  If the     *
*  optional parameter <expN> is passed, the function will  *
*  seek in the specified column of the array.              *
*  This function assumes that all data in the specified    *
*  column is of the same data type as the search string.   *
************************************************************

IF parameters() = 2           &&  if no column was passed
  col_no = 1
  pcount = 3                  &&  for error routine
ELSE 
  pcount = parameters()       &&  parameters passed
ENDIF

rvalue = ''

IF type(ar_name+'[1,1]') = 'U'  &&  if not an array
  rvalue = parerror(ar_name,'a')
ENDIF

IF pcount # 3                 &&  if wrong number of params
  e_mess = pnumerr('ar_seek')
  = poperror(e_mess)
  rvalue = 'XXX'
ENDIF

IF len(rvalue) = 0            &&  if we have got this far

  a_len = ar_len(ar_name)     &&  array length

  IF type(ar_name+'[3600,1]') # 'U' && one-dimensional array
    one_dim = .t.
  ELSE
    one_dim = .f.
  ENDIF

***  if the array that we are working with is of only one 
***  dimension address it with a single subscript.

  IF one_dim

    FOR i = 1 to a_len

***  make sure that we are trying to match data of the same
***  data type

      IF type('seek_str') = type(ar_name + '[i]')

        IF seek_str == &ar_name[i] &&  if exact match
          rvalue = i
          EXIT                &&  exit immediately
        ENDIF

      ELSE                    &&  if a data type mismatch
        LOOP                  &&  go to the next element
      ENDIF

    ENDFOR

***  if the array is two-dimensional address it with both
***  subscripts and, if column coordinate has been passed
***  search for a match in the proper column

  ELSE

    FOR i = 1 to a_len

      IF type('seek_str') = type(ar_name + '[i,col_no]')

        IF seek_str == &ar_name[i,col_no] &&  if exact match
          rvalue = i
          EXIT                &&  exit immediately
        ENDIF

      ELSE                    &&  if a data type mismatch
        LOOP
      ENDIF

    ENDFOR

  ENDIF

  IF i > a_len                &&  if no match was found
    rvalue = 0                &&  return a 0
  ENDIF

ENDIF

RETURN(rvalue)