FUNCTION ar_clone
PARAMETERS ar_name, new_name, min_row, max_row, start_row
PRIVATE ar_name, new_name, min_row, max_row, start_row
PRIVATE pcount, alen, awid, i, j

************************************************************
*  ar_clone<expC1>,<expC2>)                                *
*  Version # 1.0  FP          Date: 06-29-90               *
*  Programmed by: Malcolm C. Rubel                         *
*                                                          *
*  Copyright (c) 1990                                      *
*  Performance Dynamics Associates                         *
*  All Rights Reserved                                     *
*                                                          *
*  Note: Function returns the TRUE if it has managed to    *
*  clone the array specified in <expC1>.  The function     *
*  does not care if any array or other memory variable     *
*  already exist with the target variable's name.  It just *
*  writes over it with the new target array.
************************************************************

IF type(ar_name + '[1,1]') = 'U'
  = poperror('Parameter passed to function AR_CLONE '+;
             'is not an array.  Function will '+;
             'return FALSE.')
  RETURN(.f.)
ENDIF

alen = ar_len(ar_name)        &&  how long is it
awid = ar_wid(ar_name)        &&  how wide is it

***  declare the target array

PUBLIC &new_name              && make it public

IF awid = 1
  DECLARE &new_name[alen]
ELSE
  DECLARE &new_name[alen,awid]
ENDIF

IF type(ar_name+'[3600,1]') # 'U'  && one-dimensional

***  copy from the source to target array as specified

  FOR i = 1 TO alen
    &new_name[i] = &ar_name[i]
  ENDFOR

ELSE                          &&  two-dimensional array

  FOR i = 1 TO alen

    FOR j = 1 TO awid
      &new_name[i,j] = &ar_name[i,j]
    ENDFOR

  ENDFOR

ENDIF

RETURN(.t.)