FUNCTION ar_wid
PARAMETERS ar_name
PRIVATE ar_name, a_len, rvalue, mn, md, mx

************************************************************
*  ar_wid(<expC>)                                          *
*  Version # 1.0  FP          Date: 01-18-90               *
*  Programmed by: Malcolm C. Rubel                         *
*                                                          *
*  Copyright (c) 1990                                      *
*  Performance Dynamics Associates                         *
*  All Rights Reserved                                     *
*                                                          *
*  Note: Function returns the width of the array named     *
*  in <expC>.                                              *
************************************************************

IF type(ar_name + '[1,1]') # 'U' &&  we have an array

  mn = 0
  mx = 4096                 &&  larger than max array width

  IF type(ar_name + '[3600,1]') # 'U' &&  one-dimension array
    rvalue = 1              &&  the width is one
  ELSE
    a_len = ar_len(ar_name)  && get array length

    DO WHILE .t.

      md = (mn + mx)/2

      IF type(ar_name+'[a_len,md]') # 'U'  && not undefined

***  If the next higher element is undefined then the width
***  of the array equals the mid value.

        IF type(ar_name+'[a_len,md+1]') = 'U'
          rvalue = md
          EXIT
        ELSE
          mn = md
        ENDIF

      ELSE                    &&  if array element exists
        mx = md
      ENDIF

    ENDDO

  ENDIF

ELSE                        &&  not an array

  = poperror('Parameter passed to function AR_LEN '+;
             'is not an array.  Function will '+;
             'return -1.')
  rvalue = -1

ENDIF

RETURN(rvalue)