FUNCTION ar_stru
PARAMETERS dbf_file
PRIVATE dbf_file, cur_comp, cur_buff, rvalue

************************************************************
*  ar_stru(<expC>)                                         *
*  Version # 1.0  FP          Date: 06-30-90               *
*  Programmed by: Malcolm C. Rubel                         *
*                                                          *
*  Copyright (c) 1990                                      *
*  Performance Dynamics Associates                         *
*  All Rights Reserved                                     *
*                                                          *
*  Note: Function takes an open data table or one that     *
*  is not open, but is located in the default path, and    *
*  loads it structure to a special array named AR_STRU.    *
*  AR_STRU returns the length of the array (number of      *
*  fields) to the calling program.                         *
************************************************************

rvalue = .f.

IF type('dbf_file') # 'C'     &&  invalid parameter type
  = poperror('Invalid parameter passed to AR_STRU.  '+;
             'Function will return a zero.')
  RETURN(0)
ENDIF

cur_comp = set('compat') = 'ON' &&  dBase IV compatibility
SET COMPAT off
cur_buff = select()
dbf_file = upper(trim(dbf_file))

IF alias() = upper(dbf_file)  &&  file in current work area
  rvalue = .t.
ELSE

  IF used(dbf_file)           &&  for each of the work areas
    SELECT(dbf_file)
    rvalue = .t.              &&  we found it!
  ENDIF

ENDIF

IF .not. rvalue               &&  still have not found it
  SELECT 0                    &&  go to an open buffer
  USE(dbf_file)               &&  open it
ENDIF

= make_stx()                  &&  make sure we have stru file
COPY TO stru_ext STRUCTURE EXTENDED     &&  load structure

IF .not. rvalue               &&  we opened dbf_file
  USE stru_ext                &&  open stru_ext on top of it
ELSE
  SELECT 0
  USE stru_ext
ENDIF

rvalue = reccount()

PUBLIC &dbf_file
DECLARE &dbf_file[rvalue,4]

COPY NEXT rvalue TO ARRAY &dbf_file
USE

SELECT(cur_buff)

IF cur_comp
  SET COMPAT on
ENDIF

RETURN(rvalue)
