FUNCTION ar_sort
PARAMETERS ar_name, col_no
PRIVATE ar_name, col_no, alen, awidth,i, j, k, l, is_1dim
PRIVATE jump, s_len, srt, m_temp

************************************************************
*  ar_sort(<expC>)                                         *
*  Version # 1.3  FP          Date: 03-12-90               *
*  Programmed by: Malcolm C. Rubel                         *
*                                                          *
*  Copyright (c) 1989,1990                                 *
*  Performance Dynamics Associates                         *
*  All Rights Reserved                                     *
*                                                          *
*  Note: Function changed to use Shell's method as         *
*  described by Knuth, Vol. 3 pgs. 84-95.  This method of  *
*  sorting is a minimum of three times faster than a       *
*  simple list insertion sort.  Care should be taken using *
*  this sort.  With numbers greater than 100, the sort     *
*  slows down noticeably.  Sort only works on a one-       *
*  dimensional array.  The function returns the length of  *
*  the array sorted.                                       *
*  Modified 1-19-90 to work with two-dimensional arrays.   *
*  Modified 3-12-90 so that sort column can be any column  *
*  in a two-dimensional array.
************************************************************

IF parameters() = 1           &&  only one parameter passed
  col_no = 1
ENDIF

IF type('col_no') # 'N'       &&  not passed as a numeric
  = poperror('Column parameter for AR_SORT must be '+;
             'numeric.  Function will return a '+;
             'divide overflow.')
  RETURN(1/0)
ENDIF

alen = ar_len(ar_name)

***  determine the proper jump sequence for the array size.

DO CASE

  CASE alen < 6
    DECLARE srt[1]            &&  jump sequence array
    slen = 1                  &&  jump sequence array length
    srt[1] = 1

  CASE alen < 40
    DECLARE srt[2]
    slen = 2
    srt[1] = 4                &&  jump sequence
    srt[2] = 1
   
  CASE alen < 121
    DECLARE srt[3]
    slen = 3
    srt[1] = 13               &&  bigger jump sequence
    srt[2] = 4
    srt[3] = 1

  CASE alen < 364
    DECLARE srt[4]
    slen = 4
    srt[1] = 40               &&  even bigger jump sequence
    srt[2] = 13
    srt[3] = 4
    srt[4] = 1

  CASE alen < 1093
    DECLARE srt[5]
    slen = 5
    srt[1] = 121 
    srt[2] = 40
    srt[3] = 13
    srt[4] = 4
    srt[5] = 1

  CASE alen < 3280
    DECLARE srt[6]
    slen = 6
    srt[1] = 364
    srt[2] = 121
    srt[3] = 40
    srt[4] = 13
    srt[5] = 4
    srt[6] = 1

  OTHERWISE
    DECLARE srt[7]
    slen = 7
    srt[1] = 1093             &&  biggest jump sequence
    srt[2] = 364
    srt[3] = 121
    srt[4] = 40
    srt[5] = 13
    srt[6] = 4
    srt[7] = 1

ENDCASE

IF type(ar_name+'[3600,1]') # 'U' &&  one-dimensional array
  is_1dim = .t.
ELSE
  is_1dim = .f.
ENDIF

***  Start Shell's Method 

IF is_1dim                    &&  if we have a 1D array

***  go through the loop the proper number of times

  FOR i = 1 to slen
    jump = srt[i]             &&  the proper jump interval

    FOR j = 1 to alen-jump    &&  go through the whole array

***  if element is out of place in array

      IF &ar_name[j] >= &ar_name[j+jump]
        m_temp = &ar_name[j]  &&  store big number to m_temp
        &ar_name[j] = &ar_name[j+jump]  &&  switch number
        &ar_name[j+jump] = m_temp  &&  write m_temp high
      
        k = j - jump

***  if element is still out of place in array  go through
***  the same process until it is in the right area

        DO while k > 0 .and. &ar_name[k] >= &ar_name[k+jump]
          m_temp = &ar_name[k]
          &ar_name[k] = &ar_name[k+jump]
          &ar_name[k+jump] = m_temp

          k = k - jump        &&  go back jump interval
        ENDDO

      ENDIF

    ENDFOR

  ENDFOR

  RETURN(alen)

ELSE                          &&  if two-dimensional array

  awidth = ar_wid(ar_name)

  IF col_no > awidth          &&  bad parameter
    = poperror('You specified a column number '+;
               'for AR_SORT to use that is greater '+;
               'than the width of the array.  '+;
               'Function will return a divide '+;
               'overflow.')
    RETURN(1/0)
  ENDIF

***  go through the loop the proper number of times

  FOR i = 1 to slen
    jump = srt[i]             &&  the proper jump interval

    FOR j = 1 to alen-jump    &&  go through the whole array

***  if element is out of place in array

      IF &ar_name[j,col_no] >= &ar_name[j+jump,col_no]

***  go through the array width and change each element with
***  the corresponding element in the switch spot.

        FOR l = 1 to awidth
          m_temp = &ar_name[j,l] && store big number to temp
          &ar_name[j,l] = &ar_name[j+jump,l] &&  switch
          &ar_name[j+jump,l] = m_temp   &&  write high 
        ENDFOR
      
        k = j - jump

***  if element is still out of place in array  go through
***  the same process until it is in the right area

        DO while k > 0 .and. &ar_name[k,col_no] >= ;
                             &ar_name[k+jump,col_no]

***  go through the array width and change each element with
***  the corresponding element in the switch spot.

          FOR l = 1 to awidth
            m_temp = &ar_name[k,l]
            &ar_name[k,l] = &ar_name[k+jump,l]
            &ar_name[k+jump,l] = m_temp
          ENDFOR

          k = k - jump        &&  go back jump interval
        ENDDO

      ENDIF

    ENDFOR

  ENDFOR

  RETURN(alen)

ENDIF