FUNCTION ar_size
PARAMETERS ar_name, ar_delta
PRIVATE ar_name, ar_delta, alen, awid, new_len, _work_ar
PRIVATE i, j

************************************************************
*  ar_size(<expC>[,<expN>>])                               *
*  Version # 1.0  FP          Date: 06-29-90               *
*  Programmed by: Malcolm C. Rubel                         *
*                                                          *
*  Copyright (c) 1990                                      *
*  Performance Dynamics Associates                         *
*  All Rights Reserved                                     *
*                                                          *
*  Note: Function increases or decreases the size of the   *
*  declared array by the specified amount.  If no          *
*  increment is given, the function assumes a value of +1. *
*  Function returns TRUE if the size change was successful.*
************************************************************

IF parameters() = 1           &&  if no delta amount
  ar_delta = 1                &&  use +1 as default
ENDIF

IF type(ar_name + '[1,1]') = 'U'   &&  not an array
  = poperror('The name passed to AR_SIZE is not an '+;
             'array.  Function will return FALSE.')
  RETURN(.f.)
ENDIF

alen = ar_len(ar_name)        &&  length of the source array
awid = ar_wid(ar_name)        &&  width of the source array
new_len = alen + ar_delta     &&  new length of our array

IF awid = 1                   &&  is one-dimensional array
  DECLARE _work_ar[new_len]   &&  temporary array

  FOR i = 1 TO iif(new_len> alen,alen,new_len)
    _work_ar[i] = &ar_name[i] &&  store to temp array
  ENDFOR

  DECLARE &ar_name[new_len]   &&  re-declare our array 

  FOR i = 1 TO new_len        &&  store from temp array
    &ar_name[i] = _work_ar[i]
  ENDFOR

ELSE                          &&  we have a two-dim. array

  DECLARE _work_ar[new_len,awid] &&  declare our temp array

  FOR i = 1 TO iif(new_len> alen,alen,new_len)

    FOR j = 1 to awid         &&  write row and col to temp
      _work_ar[i,j] = &ar_name[i,j]
    ENDFOR

  ENDFOR

  DECLARE &ar_name[new_len,awid]   &&  resize our array

  FOR i = 1 TO new_len        && store back to our new array

    FOR j = 1 to awid
      &ar_name[i,j] = _work_ar[i,j]
    ENDFOR

  ENDFOR

ENDIF

RETURN(.t.)