FUNCTION ar_len
PARAMETERS ar_name
PRIVATE ar_name, min, mid, max, rvalue

************************************************************
*  ar_len(<expC>)                                          *
*  Version # 1.2  FP          Date: 01-18-90               *
*  Programmed by: Malcolm C. Rubel                         *
*                                                          *
*  Copyright (c) 1989,1990                                 *
*  Performance Dynamics Associates                         *
*  All Rights Reserved                                     *
*                                                          *
*  Note: Function returns the length of the array named in *
*  <expC>.                                                 *
*  Modified 12-13-89 to add array test.                    *
*  Modified 1-18-90 to add proper test for two-dimensional *
*  array lengths.                                          *
************************************************************

IF type(ar_name + '[1,1]') # 'U'     &&  we have an array

  min = 0
  max = 4096                  &&  larger than max array size

  IF type(ar_name+ '[3600,1]') # 'U' &&  one-dimensional

    DO WHILE .t.

      mid = (max + min) / 2

***  If the next higher element is undefined then the length
***  of the array equals the mid value.

      IF type(ar_name+ '[mid]') # 'U' 

        IF type(ar_name + '[mid+1]') = 'U'
          rvalue = mid        &&  stuff rvalue
          EXIT
        ELSE
          min = mid
        ENDIF

      ELSE
        max = mid
      ENDIF

    ENDDO

  ELSE                        &&  if array is 2 dim

    DO WHILE .t.

      mid = (max + min) / 2

***  If the next higher element is undefined then the length
***  of the array equals the mid value.

      IF type(ar_name + '[mid,1]') # 'U' 

        IF type(ar_name + '[mid+1,1]') = 'U'
          rvalue = mid        &&  stuff rvalue
          EXIT
        ELSE
          min = mid
        ENDIF

      ELSE
        max = mid
      ENDIF

    ENDDO

  ENDIF

ELSE                          &&  not an array

  = poperror('Parameter passed to function AR_LEN '+;
             'is not an array.  Function will '+;
             'return -1.')
  rvalue = -1

ENDIF

RETURN(rvalue)