FUNCTION ar_ins
PARAMETERS ar_name, row_num
PRIVATE ar_name, row_num, alen, awidth, temp
PRIVATE place, rvalue, i, j, e_mess, rvalue

************************************************************
*  ar_ins(<expC>,<expN>)                                   *
*  Version # 1.0  FP          Date: 06-26-90               *
*  Programmed by: Malcolm C. Rubel                         *
*                                                          *
*  Copyright (c) 1990                                      *
*  Performance Dynamics Associates                         *
*  All Rights Reserved                                     *
*                                                          *
*  Note: Function inserts a row at the specified position  *
*  <expN> in the array <expC> and moves all information    *
*  in the array elements that come after the inserted      *
*  element back one row.  The last row is in the array is  *
*  lost.  If the specified row is not within the specified *
*  array, the function returns logical FALSE, otherwise it *
*  returns locigal TRUE.                                   *
************************************************************

rvalue = .f.

IF parameters() # 2
    = poperror(pnumerr(' ar_ins'))
  RETURN(.f.)
ENDIF

IF type(ar_name + '[1,1]') = 'U'
  = poperror('The parameter passed to the function '+;
             'AR_INS is not an array name.  '+;
             'The function will return FALSE.')
  RETURN(.f.)
ENDIF

IF type('row_num') # 'N'      &&  row number is not numeric
  = poperror('Row number passed to function AR_INS is '+;
             'not numeric.  Function will not insert a '+;
             ' row.')
  RETURN(.f.)
ENDIF

alen = ar_len(ar_name)        &&  how long is the array

***  check to make sure that we are going to insert a valid
***  row into the array.

IF row_num = 0 .or. row_num > alen
  = poperror('Row number passed to function AR_INS is '+;
             'not valid.  Function will not insert a '+;
             'row.')
  RETURN(.f.)
ENDIF

***  now that we have passed all of our hurdles, lets get 
***  to work!

IF type(ar_name+'[3600,1]') # 'U'  &&  one-dimensional
  place = &ar_name[row_num] &&  save the deleted row

  FOR i = alen to row_num + 1 STEP -1
    &ar_name[i] = &ar_name[i-1]  &&  move rows down
  ENDFOR

  DO CASE                   &&  put in new row values

    CASE type('place') = 'C'
      &ar_name[row_num] = ''

    CASE type('place') = 'N'
      &ar_name[row_num] = 0

    CASE type('place') = 'D'
      &ar_name[row_num] = ctod('00/00/00')

    OTHERWISE
      &ar_name[row_num] = .f.

  ENDCASE

  rvalue = .t.              &&  deletion successful
 
ELSE                          &&  if two-dimensional

  awidth = ar_wid(ar_name)    &&  how wide is the array

  declare place[awidth]     &&  for the deleted row

  FOR j = 1 to awidth
    place[j] = &ar_name[row_num,j] &&  save the row
  ENDFOR

  FOR i = alen  TO row_num + 1 STEP -1

    FOR j = 1 to awidth
      &ar_name[i,j] = &ar_name[i-1,j] &&  move rows down
    ENDFOR

  ENDFOR

  FOR j = 1 to awidth

    DO CASE                 &&  put in last value

      CASE type('place[j]') = 'C'
        &ar_name[row_num,j] = ''

      CASE type('place[j]') = 'N'
        &ar_name[row_num,j] = 0

      CASE type('place[j]') = 'D'
        &ar_name[row_num,j] = ctod('00/00/00')

      OTHERWISE
        &ar_name[row_num,j] = .f.

    ENDCASE

  ENDFOR

  rvalue = .t.              &&  deletion successful
 
ENDIF

RETURN(rvalue)