FUNCTION ar_fill
PARAMETERS ar_name, ar_col1, ar_val1, ar_col2, ar_val2,;
           ar_col3, ar_val3, ar_col4, ar_val4, ar_col5,;
           ar_val5
PRIVATE ar_name, ar_col1, ar_val1, ar_col2, ar_val2
PRIVATE ar_col3, ar_val3, ar_col4, ar_val4, ar_col5
PRIVATE ar_val5
PRIVATE c_count, alen, awid, num

************************************************************
*  ar_fill(<expC1>,<expN1>,<exp1>[,<expN2>,<exp2>;         *
*                [,<expN3>,<exp3>[,<expN4>,<exp4>;         *
*                [,<expN5>,<exp5>]]]])                     *
*                                                          *
*  Version # 1.0  FP          Date: 06-29-90               *
*  Programmed by: Malcolm C. Rubel                         *
*                                                          *
*  Copyright (c) 1990                                      *
*  Performance Dynamics Associates                         *
*  All Rights Reserved                                     *
*                                                          *
*  Note: Function fills up to five columns in an array     *
*  with the value specified in the accompanying            *
*  expression.  Function returns Logical TRUE if the fill  *
*  is successful, Logical FALSE if there was a problem.    *
************************************************************

c_count = (parameters() - 1)/2    &&  how many cols passed?

IF c_count # int(c_count)     &&  wrong number passed
  = poperror('Incorrect number of parameters passed to '+;
             'AR_FILL.  Function will not fill array '+;
             'with data and will return FALSE.')
  RETURN(.f.)
ENDIF

awid = ar_wid(ar_name)        &&  how wide is the array

***  check to see that we have passed nothing but numbers
***  for columns and that they are all for a column that
***  is included in the array

FOR i = 1 to c_count
  num = ltrim(str(i))

  IF type('ar_col&num') # 'N' .or. ar_col&num > awid
    = poperror('Invalid array column parameter passed to '+;
               'AR_FILL.  Function will not fill array '+;
               'with data and will return FALSE.')
    RETURN(.f.)
  ENDIF

ENDFOR

***  checking good?  fill the array

alen = ar_len(ar_name)

FOR i = 1 TO alen

***  here is a different way to conditionally process!

  IF c_count > 0
    &ar_name[i,ar_col1] = ar_val1

    IF c_count > 1
      &ar_name[i,ar_col2] = ar_val2

      IF c_count > 2
        &ar_name[i,ar_col3] = ar_val3

        IF c_count > 3
          &ar_name[i,ar_col4] = ar_val4

          IF c_count > 4
            &ar_name[i,ar_col5] = ar_val5
          ENDIF

        ENDIF

      ENDIF

    ENDIF

  ENDIF

ENDFOR

RETURN(.t.)
