FUNCTION ar_del
PARAMETERS ar_name, row_num
PRIVATE ar_name, row_num, alen, awidth, temp
PRIVATE place, rvalue, i, j, e_mess, rvalue

************************************************************
*  ar_del(<expC>,<expN>)                                   *
*  Version # 1.0  FP          Date: 01-19-90               *
*  Programmed by: Malcolm C. Rubel                         *
*                                                          *
*  Copyright (c) 1990                                      *
*  Performance Dynamics Associates                         *
*  All Rights Reserved                                     *
*                                                          *
*  Note: Function deletes the specified row <expN> from    *
*  the araray <expC> and moves all information in the      *
*  elements that come after the deleted element up one     *
*  row.  The last row becomes a empty row initialized to   *
*  the same data types as the information in the deleted   *
*  row.  If the specified row is not within the specified  *
*  array, the function returns .f., otherwise it returns   *
*  .t.                                                     *
************************************************************

rvalue = .f.

IF parameters() # 2
    = poperror(pnumerr(' ar_del'))
  RETURN(.f.)
ENDIF

IF type(ar_name + '[1,1]') = 'U'
  = poperror('The parameter passed to the function '+;
             'AR_DEL is not an array name.  '+;
             'The function will return FALSE.')
  RETURN(.f.)
ENDIF

IF type('row_num') # 'N'      &&  row number is not numeric
  = poperror('Row number passed to function AR_DEL is '+;
             'not numeric.  Function will not delete any '+;
             ' data.')
  RETURN(.f.)
ENDIF

alen = ar_len(ar_name)        &&  how long is the array

***  check to make sure that we are going to delete a valid
***  row from the array.

IF row_num = 0 .or. row_num > alen
  = poperror('Row number passed to function AR_DEL is '+;
             'not valid.  Function will not delete any '+;
             'data.')
  RETURN(.f.)
ENDIF

***  now that we have passed all of our hurdles, let's get 
***  to work!

IF type(ar_name+'[3600,1]') # 'U'  &&  one-dimensional array

  place = &ar_name[row_num] &&  save the deleted row

  FOR i = row_num to alen-1
    &ar_name[i] = &ar_name[i+1]  &&  move rows down
  ENDFOR

  DO CASE                   &&  put in last value

***  Note:  I could have put the DO CASE structure that 
***  generates null values into a separate function and 
***  tied it in to this program.  While this saves code,
***  calling a function in this manner takes twice the 
***  time that it does if you program it in-line.

    CASE type('place') = 'C'
      &ar_name[alen] = ''

    CASE type('place') = 'N'
      &ar_name[alen] = 0

    CASE type('place') = 'D'
      &ar_name[alen] = ctod('00/00/00')

    OTHERWISE
      &ar_name[alen] = .f.

  ENDCASE

  rvalue = .t.              &&  deletion successful
 
ELSE                          &&  if two-dimensional

  awidth = ar_wid(ar_name)    &&  how wide is the array


  declare place[awidth]     &&  for the deleted row

  FOR j = 1 to awidth
    place[j] = &ar_name[row_num,j] &&  save the row
  ENDFOR

  FOR i = row_num to alen-1

    FOR j = 1 to awidth
      &ar_name[i,j] = &ar_name[i+1,j] &&  move rows down
    ENDFOR

  ENDFOR

  FOR j = 1 to awidth

    DO CASE                 &&  put in last value

      CASE type('place[j]') = 'C'
        &ar_name[alen,j] = ''

      CASE type('place[j]') = 'N'
        &ar_name[alen,j] = 0

      CASE type('place[j]') = 'D'
        &ar_name[alen,j] = ctod('00/00/00')

      OTHERWISE
        &ar_name[alen,j] = .f.

    ENDCASE

  ENDFOR

  rvalue = .t.              &&  deletion successful
 
ENDIF

RETURN(rvalue)

