FUNCTION ar_copy
PARAMETERS ar_name, new_name, min_row, max_row, start_row
PRIVATE ar_name, new_name, min_row, max_row, start_row
PRIVATE pcount, alen, awid, i, j

************************************************************
*  ar_copy(<expC1>,<expC2>[,expN1>[,<expN2>],<expN3>]]])   *
*  Version # 1.0  FP          Date: 06-29-90               *
*  Programmed by: Malcolm C. Rubel                         *
*                                                          *
*  Copyright (c) 1990                                      *
*  Performance Dynamics Associates                         *
*  All Rights Reserved                                     *
*                                                          *
*  Note: Function returns the TRUE if it has managed to    *
*  copy data from the source array to the target array.    *
*  The function creates the target array if it does not    *
*  already exist.                                          *
************************************************************

pcount = parameters()         &&  how many parameters passed

IF type(ar_name + '[1,1]') = 'U'
  = poperror('Parameter passed to function AR_COPY '+;
             'is not an array.  Function will '+;
             'return FALSE.')
  RETURN(.f.)
ENDIF

alen = ar_len(ar_name)        &&  how long is it
awid = ar_wid(ar_name)        &&  how wide is it

DO CASE 

  CASE pcount = 2
    min_row = 1
    max_row = alen
    start_row = 1

  CASE pcount = 3
    max_row = alen
    start_row = 1

  CASE pcount = 4
    start_row = 1

  CASE pcount <= 1 .or. pcount > 5
    = poperror('Invalid parameters passed to AR_COPY.  '+;
               'Function will return FALSE.')
    RETURN(.f.)

ENDCASE

IF type(new_name + '[1,1]') = 'U'  && new array not there

  PUBLIC &new_name

  IF awid = 1
    DECLARE &new_name[max_row - min_row + 1]
  ELSE
    DECLARE &new_name[max_row - min_row + 1,awid]
  ENDIF

ENDIF

***  check to make sure that we can fit all the elements 
***  that we want to copy into the target array

IF ar_len(new_name) - start_row < max_row - min_row
  = poperror('There is not enough room in the target '+;
             'array for AR_COPY to copy over the '+;
             'specified range of records.  The '+;
             'function will return FALSE.')
  RETURN(.f.)
ENDIF

IF type(ar_name+'[3600,1]') # 'U'  && one-dimensional

***  copy from the source to target array as specified

  FOR i = min_row TO max_row
    &new_name[i-min_row+start_row] = &ar_name[i]
  ENDFOR

ELSE                          &&  two-dimensional array

  FOR i = min_row TO max_row

    FOR j = 1 TO awid
      &new_name[i-min_row+start_row,j] = &ar_name[i,j]
    ENDFOR

  ENDFOR

ENDIF

RETURN(.t.)