FUNCTION ar_1dim
PARAMETERS ar_name
PRIVATE ar_name, rvalue

************************************************************
*  ar_1dim(<expC>)                                         *
*  Version # 1.0  FP          Date: 01-18-90               *
*  Programmed by: Malcolm C. Rubel                         *
*                                                          *
*  Copyright (c) 1990                                      *
*  Performance Dynamics Associates                         *
*  All Rights Reserved                                     *
*                                                          *
*  Note: Function returns a logical TRUE if the array      *
*  passed as <expC> is one-dimensional.  Function returns  *
*  logical FALSE if the array is two-dimensional.          *
************************************************************

rvalue = ''

IF type(ar_name + '[1,1]') = 'U'
  = poperror('Parameter passed to AR_1DIM is not an '+;
             'array.  Function will return "*",')
  rvalue = '*'
ENDIF

IF len(rvalue) = 0

  IF type(ar_name+'[3600,1]') # 'U' &&  element exists
    rvalue = .t.              &&  we have a 1D array
  ELSE
    rvalue = .f.              &&  we have a 2D array
  ENDIF

ENDIF

RETURN(rvalue)
