* col17_h.prg
*& instant popups only on a mouse hit
SET TALK OFF
DIMENSION jobs(7)
jobs(1)="CONSULTANT"
jobs(2)="PROGRAMMER"
jobs(3)="MIS MANAGER"
jobs(4)="DP MANAGER"
jobs(5)="OWNER"
jobs(6)="TECH SUPPORT"
jobs(7)="OTHER"
DEFINE WINDOW survey FROM 1,0 TO 20,70 PANEL TITLE "SURVEY"
ACTIVATE WINDOW survey
@ 1,0 SAY "Name "
@ 2,0 SAY "Age "
@ 3,0 SAY "Occupation "
@ 4,0 SAY "Number of PCs "
@ 5,0 SAY "Salary "
STORE SPACE(10) TO name
STORE 0 TO age,numpcs,salary
STORE SPACE(20) TO job
STORE "" TO blocker
DO WHILE .T.
  @ 1,25 GET name
  @ 2,25 GET age PICTURE "###"
  @ 4,25 GET numpcs PICTURE "###"
  @ 5,25 GET salary PICTURE "###,###"
  * Put a "blocker" in front of the popup to prevent
  * access to the job field via the cursor keys, tab
  * key or other keyboard activity.
  @ 3,25 GET blocker VALID 3
  * Move popup to the "end" of the get list
  @ 3,25 GET job PICTURE "@!" WHEN jobpop(job)
  * When the user exits the popup, go to the numpcs field
  @ 3,25 GET blocker VALID -4
  READ
  IF LASTKEY()=27  && escape key pressed
    EXIT
  ENDIF escape
ENDDO process info

PROCEDURE jobpop
PARAMETERS thisjob
PRIVATE jobnum,retval
*$ see if the job is in the array
FOR jobnum = 1 TO 7
  IF jobs(jobnum)=ALLTRIM(thisjob)
    EXIT
  ENDIF found it
ENDFOR LOOK FOR the job
jobnum=MIN(7,jobnum)                 && "OTHER" by default
*$ set OTHER to include current occupation if necessary
jobs(7)=IIF(jobnum=7,"OTHER:"+ALLTRIM(thisjob),"OTHER")
@ 1,25 MENU jobs,7,7 TITLE "Occupations"
READ MENU TO jobnum
DO CASE
CASE jobnum=0.OR.jobnum=7  && escape key or "Other"
  *$ allow user to edit
  retval = .T.
OTHERWISE
  *$ put the value in job and display it
  job = PADR(jobs(jobnum),20)
  @ 3,25 GET job
  CLEAR GETS
  *$ don't make user edit the text he just selected
  retval= .F.
ENDCASE  what was selected
RETURN retval


*: EOF: COL17_H.PRG
