*****************************************************************************
*           Copyright (c) 1991, Micronix Inc., All rights reserved.
*
*   Micronix assigns you, the purchaser of this software, the right to
*   distribute, free of charge, the routines in this file along with other
*   code generated by FormCode/Gen as a forms package to be used only for
*   printing the designed forms,etc. In other words, your end users, or whoever
*   you distribute the combined forms software to, can only use the software
*   in this file to print the designs that you have created for them. The
*   best means of achieving this goal may be to distribute only the compiled
*   version of these routines (compiled by whatever dBASE compiler you use).
*   Under no circumstances should this software be distributed, whether for
*   a price or not, as a stand alone libarary for general purpose use.
*
*   NOTE: Under no circumstances should this copyright and license notice be
*   deleted from this file.
*
*
*****************************************************************************
*   This file contains all the printer driver routines. These routines
*   are called by the functions that FormCode/Gen generates for your design
*   namely FCGFIXOBJ, FIXVAROBJ, etc. There are two ways these routines can
*   be made accesible to these procedures:
*       1) By appending them to the file that contains the generated code.
*          FormCode/Gen does this for you if you select the Append Procedures
*          From PCLDRV option from the Page Setup dialog box.
*       2) By making these routines accesible to the generated procedures by
*          issuing a SET PROCEDURE TO. This is what FormCode/Gen does if you
*          do not check the Append Procedures From PCLDRV check box.
*
*   NOTE: The routines in this library can be called directly by code that you
*   write yourself also. To do this, make sure you call FCGSTART before any
*   other routines and call FCGEND after printing is done. You will also
*   need to declare the following global variables (use the PUBLIC statement):
*       FCGRSTVAR, FCGGTOVAR, FCGLINVAR, FCGRCTVAR, FCGMOVVAR, FCGEXTVAR
*  The best way to hand write code is to use generated code as a starting point.
*****************************************************************************

*****************************************************************************
*   Function: Initializes printer and sets up job paramets. Must be called
*	      before the start of a job
*   Parameters: fcgcopies - (numeric) number of copies (1-99)
*       	fcgorient - (numeric) sheet orientation. 0 means portrait,
*			    one means landscape
*		fcgsize - (numeric) paper size. Must be one of the following:
*			1 for Executive Size (7 1/4 x 10 1/2 in)
*			2 for Letter Size (8 1/2 x 11 in)
*			3 for Legal Size (8 1/2 x 14 in)
*		       26 for A4 Size (210mm x 297mm)
*		       80 for Monarch Size Envelope (3 7/8 x 7 1/2 in)
*		       81 for COM 10 Size Envelope (4 1/8 x 9 1/2 in)
*		       90 for DL Size Envelope (110mm x 220mm)
*		       91 for C5 Size Envelope (162mm 229mm)
*		fcgbin - (numeric) paper bin to use. Must be one of the following:
*			1 for Upper Tray
*			2 for Manual Feed
*			3 for Manual Envelope Feed
*			4 for Lower Tray
*			5 for Paper Deck
*			6 for Envelope Feeder
*		fcgres - (numeric) Raster Graphics Resolution (Dots Per Inch)
*			Must be one of the following values:
*			75, 100, 150, 300
*****************************************************************************
procedure fcgstart
parameters fcgcopies,fcgorient,fcgsize,fcgbin,fcgres

?? chr(27)+"E"+chr(27)+"&l"+ltrim(str(fcgcopies))+"x"+ ;
   ltrim(str(fcgorient))+"o"+ltrim(str(fcgsize))+"a4d1e42f"+ ;
   ltrim(str(fcgbin))+"h"+ltrim(str(fcgres))+"R"
?? chr(27)+"*v1O"
return


*****************************************************************************
*   Function: End the job by resetting the printer.
*****************************************************************************
procedure fcgend
?? chr(27)+"E"
return


*****************************************************************************
*   Function: Sets the public variable FCGGTOVAR to PCL cursor position
*             command to move cursor to specified coordinate position.
*	      Coordinates are specified in hundredths of inches, and point 0,0
*	      corresponds to the upper left corner of the physical page.
*   Parameters: fcgx,fcgy - (numeric) cursor position
*****************************************************************************
procedure fcggoto
parameters fcgx, fcgy

fcggtovar =  chr(27)+"*p"+ltrim(str(3*fcgx-75))+"x"+ltrim(str(3*fcgy-75))+"Y"
return


*****************************************************************************
*   Function: Sets the public variable FCGMOVVAR to PCL cusror position command
*             to move the PCL cursor horizontaly by specified relative ammount.
*	      Coordinates are specified in hundredths of inches, and point 0,0
*	      corresponds to the upper left corner of the physical page.
*   Parameters: fcgx, - (numeric) ammount to move cursor by
*****************************************************************************
procedure fcgmovby
parameters fcgx

fcgmovvar =  chr(27)+"*p+"+ltrim(str(3*fcgx))+"X"
return


*****************************************************************************
*   Function: Calculates extent of text based on font metric information.
*             Stores the calculated value in public variable FCGEXTVAR
*   Parameters: fcgfntl,fcgfntu - (character) font metric arrays (upper/lower)
*               fcgfntf - (numeric) first character in character set
*               fcgstr - (character) the character string
*   NOTE: The font metric information is generated by FormCode/Gen for fonts
*   that need this information.
*****************************************************************************
procedure fcgtxtext
parameters fcgfntl, fcgfntu, fcgfntf, fcgstr
private fcglen, fcgidx, fcgchidx

fcgextvar = 0
fcgidx = 1
fcglen = len(fcgstr)
do while fcgidx <= fcglen
    fcgchidx = asc(substr(fcgstr,fcgidx,1)) - fcgfntf + 1
    fcgextvar = fcgextvar + asc(substr(fcgfntl,fcgchidx,1)) + ;
        (asc(substr(fcgfntu,fcgchidx,1))-1) * 256
    fcgidx = fcgidx + 1
*    @0,0 say fcgfntf+chr(fcgchidx+fcgfntf-1)+fcgextvar
*    suspend
enddo
fcgextvar = int(fcgextvar / 10)
return


*****************************************************************************
*   Function: Draws a verticle or horizontal line between specified points.
*	      Coordinates are specified in hundredths of inches, and point 0,0
*	      corresponds to the upper left corner of the physical page. Line
*	      coordinates specify center line for thick lines.
*   Parameters: fcgx1,fcgy1 - (numeric) line starting position
*		fcgx2,fcgy2 - (numeric) line ending position
*		fcgthick - (numeric) line width in hundredths of inches
*   NOTE: The ending position must specify coordinates that are larger than
*	  or equal to start cordinates (i.e x2 >= x1, and y2 >= y1)
*****************************************************************************
procedure fcgline
parameters fcgx1, fcgy1, fcgx2, fcgy2, fcgthick
private fcgposx,fcgposy,fcgsizex,fcgsizey,fcgtmp

if fcgx1 = fcgx2
    fcgposx = fcgx1 - int(fcgthick/2)
    fcgposy = fcgy1
    fcgsizex = fcgthick
    fcgsizey = fcgy2 - fcgy1 + 1
else
    fcgposy = fcgy1 - int(fcgthick/2)
    fcgposx = fcgx1
    fcgsizey = fcgthick
    fcgsizex = fcgx2 - fcgx1 + 1
endif

do fcggoto with fcgposx,fcgposy
?? fcggtovar+chr(27)+"*c"+ltrim(str(3*fcgsizex))+"a" + ;
   ltrim(str(3*fcgsizey))+"b0P"
return


*****************************************************************************
*   Function: Draws a rectangle with or without a border and with or without a
*             fill. Coordinates are specified in hundredths of inches, and
*             point 0,0 corresponds to the upper left corner of the physical page.
*   Parameters: fcgleft,fcgtop - (numeric) upper left corner coordinates
*		fcgright,fcgbot - (numeric) lower left corner coordinates
*		fcgthick - (numeric) border width in hundredths of inches
*		fcgfillt - (numeric) fill type. Must be one of the following:
*			0 for black fill
*			1 for white fill
*			2 for HP defined gray shading pattern
*			3 for HP defined cross-hatched pattern
*                       4 for no fill
*		fcgfillp - (numeric) the fill pattern. Value depends upon the
*			value of fcgfillt (ignored for fcgfillt = 0 or 1)
*			for fcgfillt = 2, a gray shading percentage value from
*			the following (2,10,15,30,45,70,90,100)
*			for fcgfillt = 3, a number between 1 and 6 corresponding
*                       to the six predefined patterns.
*   NOTE: The ending position must specify coordinates that are larger than
*	  or equal to start cordinates (i.e x2 >= x1, and y2 >= y1)
*****************************************************************************
procedure fcgrect
parameters fcgleft,fcgtop,fcgright,fcgbot,fcgthick,fcgfillt,fcgfillp

if fcgfillt <> 4
    do fcggoto with fcgleft, fcgtop
?? fcggtovar+chr(27)+"*c"+ltrim(str(fcgfillp))+"g"+;
   ltrim(str((fcgright-fcgleft+1)*3))+"a"+ltrim(str((fcgbot-fcgtop+1)*3))+"b"+;
   ltrim(str(fcgfillt))+"P"
endif

if fcgthick > 0
    do fcgline with fcgleft,fcgtop,fcgright,fcgtop,fcgthick
    do fcgline with fcgleft,fcgbot,fcgright,fcgbot,fcgthick
    do fcgline with fcgleft,fcgtop-int(fcgthick/2),fcgleft, ;
		    fcgbot+int((fcgthick-1)/2),fcgthick
    do fcgline with fcgright,fcgtop-int(fcgthick/2),fcgright, ;
		    fcgbot+int((fcgthick-1)/2),fcgthick
endif
return


*****************************************************************************
*   Function: Draws a box with specified border width, type, sahdow, etc.
*	      Coordinates are specified in hundredths of inches, and point 0,0
*	      corresponds to the upper left corner of the physical page.
*   Parameters: fcgleft,fcgtop - (numeric) upper left corner coordinates
*		fcgright,fcgbot - (numeric) lower left corner coordinates
*		fcgthick - (numeric) border width in hundredths of inches
*		fcgfillt - (numeric) fill type. Must be one of the following:
*			0 for black fill
*			1 for white fill
*			2 for HP defined gray shading pattern
*			3 for HP defined cross-hatched pattern
*                       4 for no fill
*		fcgfillp - (numeric) the fill pattern. Value depends upon the
*			value of fcgfillt (ignored for fcgfillt = 0 or 1)
*			for fcgfillt = 2, a gray shading percentage value from
*			the following (2,10,15,30,45,70,90,100)
*			for fcgfillt = 3, a number between 1 and 6 corresponding
*                       to the six predefined patterns.
*		fcgborder - (numeric) if = 0, specifies a single border. If = 1
*			specifies a double border.
*		fcgshadow - (numeric) if = 0, specifies no shadow. If = 1
*			specifies a shadow.
*   NOTE: The ending position must specify coordinates that are larger than
*	  or equal to start cordinates (i.e x2 >= x1, and y2 >= y1)
*****************************************************************************
procedure fcgbox
parameters fcgbleft, fcgbtop, fcgbright, fcgbbot, fcgbthick, fcgbfillt, ;
    fcgbfillp, fcgbborder, fcgbshadow
private fcgbmargin,fcgft

fcgft = fcgbfillt
fcgbmargin = 2 * fcgbthick
if fcgbborder = 1
    do fcgrect with fcgbleft+fcgbmargin, fcgbtop+fcgbmargin, fcgbright-fcgbmargin, ;
	fcgbbot-fcgbmargin, fcgbthick, fcgft, fcgbfillp
    fcgft = 4
endif

do fcgrect with fcgbleft, fcgbtop, fcgbright, fcgbbot, fcgbthick, fcgft, fcgbfillp

if fcgbshadow = 1
    do fcgrect with fcgbleft+5-int(fcgbthick/2), fcgbbot+int(fcgbthick/2), ;
	fcgbright+5+int(fcgbthick/2), fcgbbot+5+int(fcgbthick/2), 1, 0, 0
    do fcgrect with fcgbright+int(fcgbthick/2), fcgbtop+5-int(fcgbthick/2), ;
	fcgbright+5+int(fcgbthick/2), fcgbbot+5+int(fcgbthick/2), 1, 0, 0
endif
return


*****************************************************************************
*   Function: Prints left justified text at specified position
*   Parameters:
*	fcgfnts - (character) Font selection string
*	fcgtlft,fcgttop - (numeric) Position of first character in string
*	fcgtext - (numeric) The text string to print
*       fcgfillt,fcgfillp - (numeric) the pattern to use to draw text. These
*                           parametrs are interpreted the same as in FCGBOX
*       fcgundlin - (logical) text is underlined if true
*   NOTE: PCL printer will place the baseline at fcgttop (not cell top)
*****************************************************************************
procedure fcgltxt
parameters fcgfnts, fcgtlft, fcgttop, fcgtext, fcgfillt, fcgfillp, fcgundlin

if len(fcgtext) = 0
    return
endif

do fcggoto with fcgtlft, fcgttop
?? fcgfnts+fcggtovar

if fcgfillt <> 0
    ?? chr(27)+"*c"+ltrim(str(fcgfillp))+"G"+chr(27)+"*v"+ltrim(str(fcgfillt))+"T"
endif
if fcgundlin
    ?? chr(27)+"&d0D"
endif

?? fcgtext
if fcgfillt <> 0
   ?? chr(27)+"*v0T"
endif
if fcgundlin
    ?? chr(27)+"&d@"
endif

return


*****************************************************************************
*   Function: Prints L/R justified single line text at specified position
*   Parameters:
*	fcgfnts - (character) Font selection string
*	fcgtlft,fcgttop - (numeric) Position of first character in string
*	fcgtext - (numeric) The text string to print
*       fcgfillt,fcgfillp - (numeric) the pattern to use to draw text. These
*                            parametrs are interpreted the same as in FCGBOX
*       fcgundline - (logical) text is underlined if true
*	fcgbrkxtra - (numeric) The break extra ammount to spread in breaks
*	fcgbrkcnt - (numeric) The number of break characters in string
*	fcgbrkch - (numeric) The actual break character for symbol set
*   NOTE: PCL printer will place the baseline at fcgttop (not cell top)
*****************************************************************************
procedure fcglrstxt
parameters fcgfnts, fcgtlft, fcgttop, fcgtext, fcgfillt, fcgfillp, fcgundlin, ;
    fcgbrkxtra, fcgbrkcnt, fcgbrk
private fcgbrkamt, fcgbrkrm, fcgstpos, fcgbrkch, fcgamt, fcgcurch, fcgstrlen

fcgstrlen = len(fcgtext)
if fcgstrlen = 0
    return
endif

fcgbrkch = chr(fcgbrk)
if fcgbrkcnt <> 0
    fcgbrkamt = int(fcgbrkxtra/fcgbrkcnt)
    fcgbrkrm = int(fcgbrkxtra - (fcgbrkamt * fcgbrkcnt))
endif
fcgstpos = 1

do fcggoto with fcgtlft, fcgttop
?? fcgfnts+fcggtovar
if fcgfillt <> 0
    ?? chr(27)+"*c"+ltrim(str(fcgfillp))+"G"+chr(27)+"*v"+ltrim(str(fcgfillt))+"T"
endif
if fcgundlin
    ?? chr(27)+"&d0D"
endif

do while fcgstpos <= fcgstrlen
    fcgcurch = substr(fcgtext,fcgstpos,1)
    ?? fcgcurch
    if fcgcurch = fcgbrkch
        fcgamt = fcgbrkamt
	if fcgbrkrm > 0
	    fcgamt = fcgamt + 1
	    fcgbrkrm = fcgbrkrm - 1
	endif
        if fcgamt > 0
	    do fcgmovby with fcgamt
            ?? fcgmovvar
        endif
    endif
    fcgstpos = fcgstpos + 1
enddo

if fcgfillt <> 0
   ?? chr(27)+"*v0T"
endif
if fcgundlin
    ?? chr(27)+"&d@"
endif
return


*****************************************************************************
*   Function: Prints multi line L/R justified dynamic text at specified position
*   Parameters:
*	fcgfnts - (character) Font selection string
*	fcgtlft, fcgttop - (numeric) center position of string
*	fcgtext - (numeric) The text string to print
*       fcgfillt,fcgfillp - (numeric) the pattern to use to draw text. These
*                           parameters are interpreted the same as in FCGBOX
*       fcgundlin - (logical) text is underlined if true
*       fcgfntl, fcgfntu - (character) text metric arrays
*       fcgfntf - (numeric) first character position in character set
*       fcgfnth - (numeric) font height
*       fcgfntbrk - (numeric) ascii value of the font break character
*       fcgextent - (numeric) text extent in hundredths of inches
*   NOTE: PCL printer will place the baseline at fcgttop (not cell top)
*****************************************************************************
procedure fcglrtxt
parameters fcgfnts, fcgtlft, fcgttop, fcgtext, fcgfillt, fcgfillp, fcgundlin, ;
    fcgfntl, fcgfntu, fcgfntf, fcgfnth, fcgfntbrk, fcgextent
private fcgcurpos, fcgendpos, fcgtmp, fcgword, fcgstrlen, fcgcurch, fcgbrkch
private fcgcurext, fcgwrdext, fcgchidx, fcgbrkext, fcgspxtra, fcgbrkcnt, fcgdone, ;
        fcglinend

if len(fcgtext) = 0
    return
endif

fcgcurpos = 1
fcgcurext = 0
fcgbrkcnt = 0
fcgextent = fcgextent * 10
fcgtmp = ""
fcgstrlen = len(fcgtext)
fcgbrkch = chr(fcgfntbrk)
fcgdone = .F.
fcgbrkext = asc(substr(fcgfntl,fcgfntbrk-fcgfntf+1,1)) + ;
	    (asc(substr(fcgfntu,fcgfntbrk-fcgfntf+1,1))-1) * 256
do fcggoto with fcgtlft, fcgttop
?? fcgfnts+fcggtovar
if fcgfillt <> 0
    ?? chr(27)+"*c"+ltrim(str(fcgfillp))+"G"+chr(27)+"*v"+ltrim(str(fcgfillt))+"T"
endif
if fcgundlin
    ?? chr(27)+"&d0D"
endif
do while .T.
*    suspend
    do while fcgcurpos <= fcgstrlen
        fcgcurch = substr(fcgtext,fcgcurpos,1)
        if fcgcurch <>  fcgbrkch
            exit
        endif
        fcgcurpos = fcgcurpos + 1
    enddo
    fcgendpos = fcgcurpos
    fcgwrdext = 0
    do while fcgendpos <= fcgstrlen
        fcgcurch = substr (fcgtext,fcgendpos,1)
        if fcgcurch = fcgbrkch .OR. fcgcurch = chr(13) .OR. fcgcurch = chr(10)
            exit
        endif
        fcgchidx = asc(fcgcurch) - fcgfntf + 1
        fcgwrdext = fcgwrdext + asc(substr(fcgfntl,fcgchidx,1)) + ;
	    (asc(substr(fcgfntu,fcgchidx,1))-1) * 256
        fcgendpos = fcgendpos + 1
    enddo
    if fcgcurext = 0
        fcgspxtra = 0
    else
        fcgspxtra = fcgbrkext
    endif
    if (fcgcurext + fcgwrdext + fcgspxtra <= fcgextent) .OR. ;
        (fcgcurext = 0 .AND. fcgwrdext >= fcgextent)
        if fcgcurext <> 0
            fcgtmp = fcgtmp + fcgbrkch
            fcgbrkcnt = fcgbrkcnt + 1
            fcgcurext = fcgcurext + fcgbrkext
        endif
        fcgtmp = fcgtmp + substr(fcgtext,fcgcurpos,fcgendpos-fcgcurpos)
        if fcgcurch = chr(10) .OR. fcgcurch = chr(13)
            fcglinend = .T.
        else
            fcglinend = .F.
        endif
*        @3, 5 say fcgtmp + "    CurCh["+fcgcurch+"]"
*        suspend
        fcgcurext = fcgcurext + fcgwrdext
        fcgcurpos = fcgendpos + 1
        if fcgcurch = chr(13) .AND. fcgcurpos <= fcgstrlen .AND. substr(fcgtext,fcgcurpos,1) = chr(10)
            fcgcurpos = fcgcurpos + 1
        endif
    else
        fcglinend = .F.
        fcgdone = .T.
    endif
    if fcgcurext >= fcgextent .OR. fcglinend .OR. fcgcurpos > fcgstrlen .OR. fcgdone
*        clear
*        @4,5 say fcgtmp
*        @6,5 say str(fcgextent,6)+str(fcgcurext,6)+str(fcgbrkcnt,6)
*        @7,5 say "CurCh["+fcgcurch+"]  Pos: "+str(fcgcurpos,4)+"  Len: "+str(fcgstrlen,4)
*        suspend
        if fcgcurpos > fcgstrlen .OR. fcglinend
	    do fcgltxt with "", fcgtlft, fcgttop, fcgtmp, 0, 0, .F.
	else
	    do fcglrstxt with "", fcgtlft, fcgttop, fcgtmp, 0, 0, .F., ;
            (fcgextent-fcgcurext)/10, fcgbrkcnt, fcgfntbrk
        endif
        fcgdone = .F.
        fcgcurext = 0
        fcgtmp = ""
        fcgbrkcnt = 0
        fcgttop = fcgttop + fcgfnth
        if fcgcurpos > fcgstrlen
            exit
        endif
    endif
enddo

if fcgfillt <> 0
   ?? chr(27)+"*v0T"
endif
if fcgundlin
    ?? chr(27)+"&d@"
endif
return


*****************************************************************************
*   Function: Prints center justified text at specified position
*   Parameters:
*	fcgfnts - (character) Font selection string
*	fcgtcnt, fcgttop - (numeric) center position of string
*       fcgfillt,fcgfillp - (numeric) the pattern to use to draw text. These
*                           parameters are interpreted the same as in FCGBOX
*       fcgundlin - (logical) text is underlined if true
*	fcgtext - (numeric) The text string to print
*       fcgfntl, fcgfntu - (character) text metric arrays
*       fcgfntf - (numeric) first character position in character set
*   NOTE: PCL printer will place the baseline at fcgttop (not cell top)
*****************************************************************************
procedure fcgctxt
parameters fcgfnts, fcgtcnt, fcgttop, fcgtext, fcgfillt, fcgfillp, fcgundlin, ;
    fcgfntl, fcgfntu, fcgfntf
private fcgtmp

if len(fcgtext) = 0
    return
endif

fcgtmp = trim(fcgtext)
do fcgtxtext with fcgfntl, fcgfntu, fcgfntf, fcgtmp
fcgtcnt = fcgtcnt - fcgextvar/2
do fcggoto with fcgtcnt, fcgttop
?? fcgfnts+fcggtovar

if fcgundlin
    ?? chr(27)+"&d0D"
endif
if fcgfillt <> 0
    ?? chr(27)+"*c"+ltrim(str(fcgfillp))+"G"+chr(27)+"*v"+ltrim(str(fcgfillt))+"T"
endif

?? fcgtmp

if fcgfillt <> 0
   ?? chr(27)+"*v0T"
endif
if fcgundlin
    ?? chr(27)+"&d@"
endif
return

*****************************************************************************
*   Function: Prints right justified text at specified position
*   Parameters:
*	fcgfnts - (character) Font selection string
*	fcgtrt, fcgttop - (numeric) center position of string
*       fcgfillt,fcgfillp - (numeric) the pattern to use to draw text. These
*                           parameters are interpreted the same as in FCGBOX.
*       fcgundlin (logical) text is underlined if true
*	fcgtext - (numeric) The text string to print
*       fcgfntl, fcgfntu - (character) text metric arrays
*       fcgfntf - (numeric) first character position in character set
*   NOTE: PCL printer will place the baseline at fcgttop (not cell top)
*****************************************************************************
procedure fcgrtxt
parameters fcgfnts, fcgtrt, fcgttop, fcgtext, fcgfillt, fcgfillp, fcgundlin, ;
    fcgfntl, fcgfntu, fcgfntf
private fcgtmp

if len(fcgtext) = 0
    return
endif

fcgtmp = trim(fcgtext)
do fcgtxtext with fcgfntl, fcgfntu, fcgfntf, fcgtmp
fcgtrt = fcgtrt - fcgextvar
do fcggoto with fcgtrt, fcgttop
?? fcgfnts+fcggtovar

if fcgfillt <> 0
    ?? chr(27)+"*c"+ltrim(str(fcgfillp))+"G"+chr(27)+"*v"+ltrim(str(fcgfillt))+"T"
endif
if fcgundlin
    ?? chr(27)+"&d0D"
endif

?? fcgtmp

if fcgfillt <> 0
   ?? chr(27)+"*v0T"
endif
if fcgundlin
    ?? chr(27)+"&d@"
endif
return

*****************************************************************************
*   Function: Defines printer macro with specified ID
*   Parameters:
*	fcgmacid - (character) macro id
*****************************************************************************
procedure fcgdefmac
parameters fcgmacid
?? chr(27)+"&f"+fcgmacid+"y0X"
return

*****************************************************************************
*   Function: Ends definition for a printer macro
*   Parameters: none
*****************************************************************************
procedure fcgendmac
?? chr(27)+"&f1X"
return

*****************************************************************************
*   Function: Executes printer macro with last ID
*   Parameters: none
*****************************************************************************
procedure fcgdomac
parameters fcgmacid
?? chr(27)+"&f2X"
return

*****************************************************************************
*   Function: Draws check box at specified location
*   Parameters: fcgleft, fcgtop (numeric) top left corner of box
*               fcgcheck (logical) check box checked or not ?
*****************************************************************************
procedure fcgchkbox
parameters fcgleft, fcgtop, fcgcheck
do fcgrect with fcgleft, fcgtop, fcgleft+15, fcgtop+15, 1, 4, 0
if .NOT. fcgcheck
    return
endif

do fcggoto with fcgleft+1, fcgtop+1
fcgbitmap = fcggtovar+chr(27)+"*t75R"+chr(27)+"*r11t11s1A"+chr(27)+"*b0M"
fcgbitmap = fcgbitmap + chr(27)+"*b2W" + chr(128) + chr(32)
fcgbitmap = fcgbitmap + chr(27)+"*b2W" + chr(64) + chr(64)
fcgbitmap = fcgbitmap + chr(27)+"*b2W" + chr(32) + chr(128)
fcgbitmap = fcgbitmap + chr(27)+"*b1W" + chr(16+1)
fcgbitmap = fcgbitmap + chr(27)+"*b1W" + chr(8+2)
fcgbitmap = fcgbitmap + chr(27)+"*b1W" + chr(4)
fcgbitmap = fcgbitmap + chr(27)+"*b1W" + chr(8+2)
fcgbitmap = fcgbitmap + chr(27)+"*b1W" + chr(16+1)
fcgbitmap = fcgbitmap + chr(27)+"*b2W" + chr(32) + chr(128)
fcgbitmap = fcgbitmap + chr(27)+"*b2W" + chr(64) + chr(64)
fcgbitmap = fcgbitmap + chr(27)+"*b2W" + chr(128) + chr(32)
?? fcgbitmap+chr(27)+"*rB"
return


*****************************************************************************
*   Function: Draws bitmap image at specified position
*   Parameters: fcgleft, fcgtop (numeric) top left corner of image
*               fcgname (character) name of bitmap file (must be in curr dir)
*   WARNING: This function uses the DOS COPY command (with the /b switch for
*   binary data) to copy the bitmap file to the printer. On systems other than
*   DOS (e.g Novel, Unix, etc) this needs to be changed. Also the file is
*   copied to standard printer PRN. If your printer is connected to a different
*   port you need to change this also !!!
*****************************************************************************
procedure fcgimage
parameters fcgleft, fcgtop, fcgname

* The following lines are dummy lines. They must be deleted by the user.
* Their only porpose is to serve as a reminder for the new user
clear
@12, 10 say "PCLDRV.PRG has not been modified as described in the users manual."
@13, 10 say "Please read the section on Printing Bitmaps to acomplish this."
return

do fcggoto with fcgleft, fcgtop
?? fcggtovar
* The next line should be changed so that it copies the file &fcgname to
* your printer port. The copy command works for DOS but may need to be
* changed for other systems such as Unix, Novel, etc.
run copy /b &fcgname prn
return
