*  FILE NAME:  FORMAT.PRG
*  BY:         TONY SCARPELLI
*  DATE:       10/30/92
*  REVISIONS:  1.00
*  CALLED BY:  
*  DATA FILES: NONE

*  DESC:  This program will format selected text.
*         Most parts are taken from SNIPFMT.PJX.
*         Parts between *** MODIFIED *** &
*                       ****************
*         are changes.

* MODIFICATIONS:
* 11/01/92  Creating program. TS

* ---------------------------------------------------------

*** MODIFIED ***
SET STEP OFF
SET TALK OFF

PUBLIC spacetab, caseind, abort, usetab, ;
   keywrdcap, varcap, fname, skipkw

* Change these variables to suit your output.
indentation = 'Spaces'
spacetab    =  3           && Spaces per indentation level
caseind     = .T.          && .t. for an extra indent underneath case
procind     = .F.          && .t. for an extra indent underneath procedures
abort       = .F.          && Abnormal termination?
usetab      = .F.          && Use tabs for indentation?
fname       = SPACE(100)   && Filename to document
****************

* The following two variables take a value of 1, 2, or 3. 1 means to
* convert to upper case.  2 means convert to lower case. 3 means
* leave it alone.
keywrdcap  = 1             && Capitalize key words

*** MODIFIED ***
varcap     = 3             && Leave variables alone
skipkw     = .F.           && Don't skip search for key words

SET SAFETY OFF
****************

m.keyfname = SYS(2004)+'PROWORDS.FXD'
IF !FILE(m.keyfname)
   m.keyfname = LOCFILE('PROWORDS.FXD','FXD','Locate the PROWORDS.FXD file')
   IF EMPTY(keyfname)
      m.abort = .T.
      DO bailout
   ENDIF
ENDIF

*** MODIFIED ***
IF .NOT. skipkw
****************
   IF FILE(m.keyfname)
      WAIT WINDOW 'Retrieving key words' NOWAIT
      CREATE TABLE keywords (keyname C(20))
      ZAP
      APPEND FROM (keyfname) SDF
      DELETE FOR INLIST(LEFT(keyname,1),'*') OR EMPTY(keyname)
      REPLACE ALL keyname WITH SUBSTR(keyname,2) FOR INLIST(LEFT(keyname,1),'%','!','@')
      PACK
      INDEX ON keyname TAG keyname
      WAIT CLEAR

*** MODIFIED ***
      CREATE TABLE filetemp (snipmemo m)
****************
      APPEND BLANK
   ELSE
      DO alert WITH "Could not find PROWORDS.FXD file.;Press any key to quit."
      m.abort = .T.
      DO bailout
   ENDIF
ENDIF

*** MODIFIED ***
DO fmt WITH 'FMTTEXT.TXT'
****************

abort = .F.    &&  ready for normal termination
DO bailout

* =============================================================

* Format a file

PROCEDURE fmt
*** MODIFIED ***
PARAMETERS filename
****************

* The characters in this string delimit words in the command statement
break_str = ' +-/\*$#@()[]{}^%!=<>,;'

*** MODIFIED ***
msg = "Formating " + filename

COPY FILE (filename) TO filetemp.prg
****************

fp = FOPEN('filetemp.PRG',0)
IF fp < 0
   DO alert WITH "Error "+ALLTRIM(STR(fp,4))+" opening filetemp.PRG"
   abort = .T.
   DO bailout
ENDIF

fp_out = FCREATE("filetemp.NEW",0)
IF fp_out < 0
   DO alert WITH "Error creating filetemp.NEW"
   abort = .T.
   DO bailout
ENDIF

thislevel = 0      && number of tab stops to indent
nextlevel = 0      && number of tab stops for next line
iscontin  = .F.    && is this line a continuation line?
hascontin = .F.    && does this line have a continuation?

gtlinecnt = 0     && grand total line count
WAIT WINDOW msg NOWAIT

DO WHILE !FEOF(fp)
   gtlinecnt = gtlinecnt + 1

   * Display status 
   IF gtlinecnt % 20 = 0
      WAIT WINDOW msg + ''+ALLTRIM(STR(gtlinecnt,6))+' lines' NOWAIT
   ENDIF

   s = FGETS(fp)

   * Write the comment as is, but don't echo earlier SNIPFMT headings.
   * Also, bypass template statements.
   firstchars = LEFT(ALLTRIM(s),2)
   IF LEFT(firstchars,1) = '*' OR firstchars == CHR(38)+CHR(38) ;
         OR UPPER(wordnum(s,1)) == 'NOTE' OR LEFT(firstchars,1) = '\'

      IF firstchars <> '*!'
         numbytes = FPUTS(fp_out,s)
      ENDIF
      LOOP
   ENDIF

   s = STRTRAN(s,CHR(9),SPACE(spacetab)) && convert tabs to spaces
   s = ALLTRIM(s)

   cmtpos = AT(CHR(38)+CHR(38),s)        && double ampersand
   IF cmtpos = 0
      cmtpos = 10000        && fake a big value for the comment position
   ENDIF

   * Scan the statement, capitalizating/lower-casing words as appropriate
   i = 1
   DO WHILE i <= LEN(s) AND i < cmtpos
      * Skip opening break characters
      DO WHILE i <= LEN(s) AND SUBSTR(s,i,1) $ break_str
         i = i + 1
      ENDDO

      * Skip over any quoted strings
      indblquote = .F.
      insngquote = .F.
      DO CASE
         CASE SUBSTR(s,i,1) = '"'
            indblquote = .T.
            i = i + 1
         CASE SUBSTR(s,i,1) = "'"
            insngquote = .T.
            i = i + 1
      ENDCASE
      DO WHILE insngquote AND i <= LEN(s) AND SUBSTR(s,i,1) <> "'"
         i = i + 1
      ENDDO
      DO WHILE indblquote AND i <= LEN(s) AND SUBSTR(s,i,1) <> '"'
         i = i + 1
      ENDDO

      * Skip past the closing quotation mark
      IF (insngquote OR indblquote) ;
            AND SUBSTR(s,i,1) $ (CHR(34) + CHR(39))
         i = i + 1
      ENDIF

      * Skip any break characters following the quoted string
      DO WHILE i <= LEN(s) AND SUBSTR(s,i,1) $ break_str
         i = i + 1
      ENDDO

      * Extract the next word
      word_start = i
      DO WHILE i <= LEN(s) AND !(SUBSTR(s,i,1) $ break_str) ;
            AND ! (SUBSTR(s,i,1) $ CHR(34) + CHR(39))
         i = i + 1
      ENDDO
      thisword = SUBSTR(s,word_start,i - word_start)

*** MODIFIED ***
      IF .NOT. skipkw
****************

      * Capitalize or lower case the word, as appropriate
         IF i < cmtpos     && don't change capitalization of comments

         * Allow for abbreviations
            IF !EMPTY(thisword) AND LEN(thisword) < 4
            * Pad so that it will match during the SEEK()
               thisword = PADR(thisword,4)
            ENDIF

            IF !EMPTY(thisword) AND SEEK(UPPER(thisword),"KEYWORDS")
               DO CASE
                  CASE keywrdcap = 1
                     thisword = ALLTRIM(UPPER(thisword))
                  CASE keywrdcap = 2
                     thisword = ALLTRIM(LOWER(thisword))
               ENDCASE
            ELSE
               DO CASE
                  CASE varcap = 1
                     thisword = ALLTRIM(UPPER(thisword))
                  CASE varcap = 2
                     thisword = ALLTRIM(LOWER(thisword))
*** MODIFIED ***
* This is needed to maintain variables less than 4 characters
                  OTHERWISE
                     thisword = ALLTRIM(thisword)
****************
               ENDCASE
            ENDIF
         ENDIF

      ENDIF

      * Advance the string index past this word
      DO CASE
         CASE word_start = 1
            s = thisword + SUBSTR(s,i)
         CASE i > LEN(s)
            s = SUBSTR(s,1,word_start-1)+thisword
         OTHERWISE
            s = SUBSTR(s,1,word_start-1)+thisword+SUBSTR(s,i)
      ENDCASE

   ENDDO

   * Indent the statement, if necessary
   IF !EMPTY(s)
      iscontin  = hascontin      && is this line itself a continuation?
      hascontin = RIGHT(TRIM(s),1) = ';'

      word1 = UPPER(wordnum(s,1))
      word2 = UPPER(wordnum(s,2))

      thislevel = nextlevel
      DO CASE
         CASE INLIST(word1,'IF','FOR','SCAN')
         nextlevel = thislevel + 1
      CASE word1 = 'CASE' OR word1 = 'OTHERWISE'
         thislevel = thislevel - 1
   	   nextlevel = thislevel + 1
	   CASE INLIST(word1,'ENDIF','ENDDO','ENDFOR','NEXT','ENDSCAN')
      	thislevel = thislevel - 1
	   	nextlevel = thislevel
		CASE word1 = 'DO' AND word2 = 'WHILE'
			nextlevel = thislevel + 1
		CASE word1 = 'DO' AND word2 = 'CASE'
			nextlevel = thislevel + 1
			IF caseind    && add an extra indent
				nextlevel = nextlevel + 1
			ENDIF
		CASE word1 = 'ELSE'
			thislevel = thislevel - 1
			nextlevel = thislevel + 1
		CASE word1 = 'ENDCASE'
			thislevel = thislevel - 1
			nextlevel = thislevel
			IF caseind      && take back the extra indent
		   	thislevel = thislevel - 1
				nextlevel = thislevel
			ENDIF
		ENDCASE

		DO CASE
   		CASE hascontin AND !iscontin
			   nextlevel = nextlevel + 1        && extra indent for continuations
			CASE iscontin AND !hascontin
				nextlevel = thislevel - 1        && take the indent back
		ENDCASE
		thislevel = MAX(thislevel,0)
		nextlevel = MAX(nextlevel,0)

*** MODIFIED ***
* The routine to put boxes around PROCEDURES & FUNCTIONS removed.
****************

		IF usetab
		   s = REPLICATE(CHR(9),thislevel)+LTRIM(s)
		ELSE
		   s = REPLICATE(SPACE(spacetab),thislevel)+LTRIM(s)
		ENDIF

	ENDIF
	numbytes = FPUTS(fp_out,s)

ENDDO

=FCLOSE(fp)
=FCLOSE(fp_out)
WAIT WINDOW msg + ''+ALLTRIM(STR(gtlinecnt,6))+' lines' NOWAIT

*** MODIFIED ***
COPY FILE filetemp.new TO (filename)

WAIT CLEAR
RETURN

* =============================================================

FUNCTION wordnum
PARAMETERS strg,w_num, bkstrg
PRIVATE strg,s1,w_num,ret_str,bkstrg
IF PARAMETERS() = 2
   bkstrg = ".,"
ENDIF
m->s1 = m->strg
m->s1 = CHRTRAN(m->s1,bkstrg,"  ")
m->s1 = ALLTRIM(m->s1)

DO WHILE AT('  ',m->s1) > 0
   m->s1 = STRTRAN(m->s1,'  ',' ')
ENDDO

DO CASE
   CASE m->w_num > 1
      DO CASE
         CASE AT(" ",m->s1,m->w_num-1) = 0  && no word w_num past end of string.
            m->ret_str = ""
         CASE AT(" ",m->s1,m->w_num) = 0    && word w_num is last word in string.
            m->ret_str = SUBSTR(m->s1,AT(" ",m->s1,m->w_num-1)+1,255)
         OTHERWISE                              && word w_num is in the middle.
            strt_pos = AT(" ",m->s1,m->w_num-1)
            m->ret_str = SUBSTR(m->s1,strt_pos,;
               AT(" ",m->s1,m->w_num)+1 - strt_pos)
      ENDCASE
   CASE m->w_num = 1
      IF AT(" ",m->s1) > 0        && get first word.
         m->ret_str = SUBSTR(m->s1,1,AT(" ",m->s1)-1)
      ELSE                        && there is only one word.  get it.
         m->ret_str = m->s1
      ENDIF
ENDCASE

m->ret_str = ALLTRIM(m->ret_str)

RETURN m->ret_str

* =============================================================

FUNCTION delfile
PARAMETER fname
PRIVATE fname

IF FILE(m.fname)
   DELETE FILE (m.fname)
ENDIF
RETURN 0

PROCEDURE bailout
IF NOT abort
   WAIT WINDOW "Normal termination" NOWAIT
ENDIF
RELEASE spacetab, caseind, abort, usetab, ;
   keywrdcap, varcap, fname, skipkw

SELECT keywords
USE
SELECT filetemp
USE
=delfile('filetemp.prg')
=delfile('filetemp.new')
=delfile('keywords.dbf')
=delfile('keywords.cdx')
=delfile('keywords.bak')
=delfile('filetemp.dbf')
=delfile('filetemp.fpt')
=delfile('filetemp.bak')
IF TYPE('in_error') <> 'U'
   ON ERROR &in_error
ENDIF
IF FILE('snipfmt.vue')
   SET VIEW TO snipfmt.vue
   IF SET('TALK') = 'ON'
      SET TALK OFF
      DELETE FILE snipfmt.vue
      SET TALK ON
   ELSE
      DELETE FILE snipfmt.vue
   ENDIF
ENDIF
CANCEL

* =============================================================

* EOF: FORMAT.PRG
