*
* ROUTINE TO SHOW A THERMOMETER BAR 
* 
* Author: Jeff Oliphant 
* Last modified: 11/08/92
* 
* call syntax:
* 
*  =FnTherm(<ExpC1> [,<ExpN1> [,<ExpC2> [,<ExpN2>;
*              [,<ExpN3>[,<ExpN4> [,<ExpN5>]]]]]])
*  
*    ExpC1 = Function - 'BEGIN',       - to define Thermometer window 
*                       'UPDATE',      - to update bar 
*                       'END'          - to remove Thermometer bar 
* 
*          ExpN1,ExpC2 and ExpN2 - ExpN5 are optional
* 
*    ExpN1 = # of iterations - Defaults to current DBF visible rec count 
*    ExpC2 = window title - Defaults to 'Progress'   
*    ExpN2 = upper left row of thermometer window - Defaults to 15
*    ExpN3 = upper left col of thermometer window - Defaults to 0 
*    ExpN4 = width of thermometer window - Defaults to 79 
*            max = 79, min = 7 
*    ExpN5 = Color Scheme - Defaults to 5 the Fox Standard 
*
*
* Example program for CUSTOMER database minimum parameter call: 
*
* PROCEDURE TPROG
* 
*   USE CUSTOMER 
*   =FnTherm("BEGIN")
* 
*   SCAN
*     =FnTherm("UPDATE")
*     && --- your processing here --- && 
*   ENDSCAN
*
*   =FnTherm("END")
* 
* RETURN
*
* PUBLIC vars created and released after 'END' operation:
* 
*   g_NbFlag
*   g_MaxCnt  
*   g_LoopCnt  
*   g_BarWidth  
*   g_Tscheme 
* 
*
FUNCTION FnTherm   
 parameters p_func,;
            p_MaxCnt,;
            p_title,;
            p_UlRow,;
            p_UlCol,;
            p_Twidth,;
            p_TScheme 
            
 private p_Func,;
         p_MaxCnt,;
         p_title,;
         p_UlCol,;
         p_Twidth,;
         p_TScheme,; 
         p_UlRow
                 
 do case 
    case Upper(p_Func) = "BEGIN"
         if SET('border') = 'NONE' 
            public g_NbFlag
            SET BORDER TO SINGLE
         endif    
         if parameters() < 2
            count to p_MaxCnt
            if p_MaxCnt = 0 
               wait window "You must use ExpN1 in FnTherm for this call, see Documentation"
               suspend 
            endif    
         endif    
         if parameters() < 3
            p_Title = 'Progress'  
         endif    
         if parameters() < 5
            p_UlRow = 15
            p_UlCol = 0 
         endif     
         if parameters() < 6
            p_Twidth = 78
         endif     
         if parameters() < 7
            p_Tscheme = 5  
         endif     
         =ThermSet(p_MaxCnt,p_Title,p_tWidth,p_Tscheme) 
    case Upper(p_Func) = "UPDATE"
         =ThermUp()
    case Upper(p_Func) = "END"
         =ThermEnd()
 endcase
 
RETURN .T.

*
* Create the window and display bar 
*
FUNCTION ThermSet
 PARAMETERS p_MaxCnt,;
            p_title,;
            p_twidth,;
            p_TScheme 
 if p_twidth < 7 
    wait window "Window too small for Thermometer Bar" 
    suspend 
 endif 
 PUBLIC g_MaxCnt,;
        g_LoopCnt,;
        g_BarWidth,;
        g_Tscheme 
 g_MaxCnt=p_MaxCnt
 g_LoopCnt = 0
 g_BarWidth = p_Twidth - 4 
 g_Tscheme = p_Tscheme 
 IF PARAMETERS()=1
    p_title='Progress'
 ENDIF 
 DEFINE WINDOW ThermoWin TITLE p_title;
  FROM p_UlRow,p_UlCol TO p_UlRow+6,p_UlCol+p_Twidth+1 color scheme g_Tscheme 
 ACTIVATE WINDOW ThermoWin
 @ 1,1,3,p_Twidth - 2 BOX
 @2,2 SAY REPL(CHR(176),g_BarWidth)
RETURN

*
* Update the thermometer bar 
*
FUNCTION ThermUp  
 g_LoopCnt=g_LoopCnt +1
 IF NOT WVISIBLE(' ')
    ACTIVATE WINDOW ThermoWin
 ENDIF 
 @2,2 SAY REPL(CHR(219),(int(g_BarWidth*g_LoopCnt)/g_MaxCnt));
    color scheme g_Tscheme
RETURN

*
* Remove the window 
*
FUNCTION ThermEnd
 WAIT WINDOW 'Progress' TIMEOUT .2
 RELEASE WINDOW ThermoWin
 RELEASE g_MaxCnt,g_LoopCnt,g_BarWidth,g_Tscheme 
 if type('g_NbFlag') <> "U"
    set border to NONE
 endif     
RETURN
