*   Message Box Function to call windows Message box DLL (User.exe)
*		Idea and some of the coding from Foxpro Adviser Premier Issue in the article
*		titled "Tap Windows DLLs as FoxPro for Windows Dialogs" by Jim Booth.
*
*		Call it with a Message to display, the type of message, the symbol to use, 
*		and the title.  The last tree parameters are optional.  Just call it from the command
*		window and you'll get a wait window with the params.  All params are strings. 
*		Please let me know of any inprovements that can be made.  This is just the beginning
*		I'm sure.
*		
*		Function returns a string with the selected buttons test in it.
*
*		Message Box ver 1.0 2/15/93
*
*		Initial coding 2/15/93 Ver 1.0
*
*		2/18/93 Ver 1.01
*		Changed params passed to CallFN. 2nd param now MainHWND() which tells MsgBix the 
*		correct Window:(Foxpros)  Changed made at Jum Booths suggestion.  
*		Also Changed name to FMsgBox do to possible conflict with the MSGBOX() function in
*		the DLL.
*
*		2/18/93 Ver 1.02
*		Removed CallFn() and RegFn() as I discovered from Jim Booth that MsgBox() is 
*		supported directly by FoxTool.Fll.  I left the code there so you have an example to 
*		call other dlls.
*
*		Leave Messages in FoxForum to 72050,3276  
*		Richard S Albrecht on my Boss Alex Machinis's Account.
*
Function FMsgBox
Param lcMsg,  lcType, lcSymbol, lcTitle 
Private msgH, lnResult, ;                
				lcOption, lnType, lnSymbol, lcResult		
lnResult = 0

if PARAMETERS() = 0
	wait window "msg, type=ok-okcancel-abort-ync-yn-retry, symbol=?-!-info-*-stop, title"
	return
endif	
* Buttons
#define Ok 					0
#define OkCan 			1
#define AbortReIg 	2
#define YNCancel 		3
#define YN 					4
#define RetryCan 		5

* ICons
#define Hand				16
#define Question 		32
#define Exclam			48
#define Astrix			64
#define Info				64
#define Stop				16

* Results
#define rOK					1
#define rCancel			2
#define rAbort			3
#define rRetry			4
#define rIgnore			5
#define rYes				6
#define rNo					7

If Type("lcType") = "L"
	lnType = Ok
Else
	Do Case
		Case lcType = "okcancel"
			lnType = OkCan
		Case lcType = "ok"
			lnType = Ok
		Case lcType = "abort"
			lnType = AbortReIg
		Case lcType = "ync"
			lnType = YNCancel
		Case lcType = "yn"
			lnType = YN
		Case lcType = "retry"
			lnType = RetryCan
	EndCase
endif			
	

If Type( "lcSymbol") = "L"
	lnSymbol = Info
Else
	Do Case
		Case lcSymbol = "info"
			lnSymbol = Info
		Case lcSymbol = "?"
			lnSymbol = Question
		Case lcSymbol = "!"
			lnSymbol = Exclam
		Case lcSymbol = "*"
			lnSymbol = Astrix
		Case lcSymbol = "stop"
			lnSymbol = Stop
	endcase
endif
If Type( "lcTitle") = "L"
	lcTitle = "Important Message!"
endif


Set Library to d:\fpw\foxtools.fll Additive

* msgH = RegFn("MessageBox", "ICCI", "I")   && Not needed


* CallFN not needed as FoxTool.fll supports the MsgBox() function directly.
* lnResult = CallFn( msgH, MainHWND(), lcMsg, lcTitle, lnType + lnSymbol) 
lnResult = MsgBox( lcMsg, lcTitle, lnType + lnSymbol)

Release Library d:\fpw\foxtools.fll

Do Case
	Case lnResult = rOK
		lcResult = "Ok"
	Case lnResult = rCancel			
		lcResult = "Cancel"
	Case lnResult = rAbort			
		lcResult = "Abort"
	Case lnResult = rRetry			
		lcResult = "Retry"
	Case lnResult = rIgnore			
		lcResult = "Ignore"
	Case lnResult = rYes				
		lcResult = "Yes"
	Case lnResult = rNo					
		lcResult = "No"
endcase

Return lcResult

