/*

Author:           DAVID -(FLASH)- GORDON     CompuServ ID - 75130,3664

Originally:       Program COPYRIGHT 1991, FlashPoint

Now and Forever:  Released into the Public Domain

Note:             FlashPoint is a Registered Trademark

Purpose:          Shadow() simply creates a non-destructive shadow around
                  your boxes.
*/

* Usage In Your Application
******************************************************************************

SetColor("B/B")
CLEAR
SHADOW(7,14,18,65)
SetColor("BG/B")
@  7,14 clear to 18,65
@  8,16 to 17,63 double

******************************************************************************

FUNCTION SHADOW( nTop, nLeft, nBottom, nRight )
    LOCAL cHide, cMask := REPLICATE( "X" + CHR(8), 79 )

    cHide = SAVESCREEN( nBottom + 1, nLeft + 2, nBottom + 1, nRight +1 )
    cHide = TRAN( cHide, LEFT( cMask, LEN( cHide ) ) )
    RESTSCREEN( nBottom + 1, nLeft + 2, nBottom + 1, nRight + 1, cHide )

    cHide = SAVESCREEN( nTop + 1, nRight + 1, nBottom + 1, nRight + 2 )
    cHide = TRAN( cHide, LEFT( cMask, LEN( cHide ) ) )
    RESTSCREEN( nTop + 1, nRight + 1, nBottom + 1, nRight + 2, cHide )
RETURN .T.
