* Program...: Fixeof.prg
* Author....: Charles Miedzinski
* Versions..: dBASE IV  1.5

* Clear memory and the screen and closing any open files
CLEAR
CLEAR ALL
* Saving the dBASE enviroment
mtalk = SET("TALK")
SET TALK OFF
mattrib = SET("ATTRIBUTES")
mbell = SET("BELL")
mesc = SET("ESCAPE")
msafe = SET("SAFETY")
mscorebrd = SET("SCOREBOARD")
mstatus = SET("STATUS")
* ----- Opening environment
SET BELL OFF
SET ESCAPE OFF
SET SAFETY OFF
SET SCOREBOARD OFF
SET STATUS OFF

* Ask for the corrupted file name
mexit = .F.
DO WHILE .NOT. LASTKEY() = 27
   mfile = SPACE(8)
   mtofile = SPACE(8)
   mok = .T.
   CLEAR
   @ 2,3 SAY center("End of File Marker Repair Utility", 77)
   @ 3,3 SAY center("Press <ESC> to EXIT to dBASE", 77)
   @ 5,5 TO 20,75 DOUBLE
   DO flist
   IF ISBLANK(mfile)  && Use this method for dBASE IV Version 1.5
      DO wrapup
      EXIT
   ENDIF
   DO WHILE mok
      @ 7,10 SAY "Input File you wish to Restore  : "  +  ;
             IIF(LEN(mfile)>30,'...'+RIGHT(mfile,27),mfile)
      @ 8,10 SAY "Output File You wish to Copy to :";
         GET mtofile PICTURE "@!XXXXXXXX"
      @ 24,0 SAY center( ;
      "Enter Output File Name Only - WITHOUT the file extention.", 80)
      READ
      IF LASTKEY() = 27
         DO wrapup
         mexit = .T.
         EXIT
      ENDIF
      IF ISBLANK(mtofile)
         DO warn WITH 60, 19
         @ 23,0 SAY center("ENTER a NAME for you RESTORED file.", 80);
                COLOR R+/B
         @ 24,0 SAY center("Press any key to continue or <ESC> to Exit",80);
                COLOR R+/B
         mkey = INKEY(0)
         @ 23,0 CLEAR
         IF mkey = 27
            DO wrapup
            mexit = .T.
            EXIT
         ELSE
            LOOP
         ENDIF
      ENDIF
      * Check if the file is really there
      * and format the file handle to dBASE spec
      mtofile = LTRIM(TRIM(mtofile)) + ".DBF"
      IF FILE(mtofile)
         DO warn WITH 60, 19
         mtofile = SPACE(8)
         @ 23,0 SAY center("Output File Name Already Exists", 80) COLOR R+/B
         @ 24,0 SAY center( ;
            "Press any key to re-enter file name or <ESC> to exit.",80);
            COLOR R+/B
         mkey = INKEY(0)
         IF mkey = 27
            DO wrapup
            mexit = .T.
            EXIT
         ENDIF
         @ 23,0 CLEAR
      ELSE
         mok=.F.
         @ 23,0 CLEAR
      ENDIF
   ENDDO
   IF mexit
      EXIT
   ENDIF

   * Test for <eof> markers
   ON ERROR SKIP
   * Copy good data to temporary files
   * Copy production .mdx file to first temp file
   mrecs = RECCOUNT()
   COPY TO temp1 WITH PRODUCTION
   counter = 1
   DO WHILE RECNO() <= mrecs .AND. counter < 10000
      counter = counter + 1
      COPY REST TO ("temp"+LTRIM(STR(counter)))
   ENDDO
   numfiles = counter
   * Release ON ERROR
   ON ERROR

   @ 13,15 SAY LTRIM(STR(numfiles)) + " Temporary Files Created"
   * Rebuild recovered DBF
   USE temp1
   counter = 1
   DO WHILE counter < numfiles
      counter = counter + 1
      APPEND FROM ("temp" + LTRIM(STR(counter)))
   ENDDO
   COPY TO (mtofile) WITH PRODUCTION
   CLOSE DATABASES
   * Remove temporary files
   counter = 0
   DO WHILE counter < numfiles
      counter = counter + 1
      USE ("temp" + LTRIM(STR(counter))) NOSAVE
      USE
   ENDDO
   @ 14,15 SAY "All File(s) Restored to " + mtofile
   @ 23,0 SAY center("Press Any Key to Continue", 80)
   mkey = INKEY(0)
ENDDO
RETURN

*- PROCEDURE Section
PROCEDURE wrapup
   SET BELL &mbell
   SET SCOREBOARD &mscorebrd
   SET STATUS &mstatus
   SET ESCAPE &mesc
   SET TALK &mtalk
   CLEAR ALL
RETURN

PROCEDURE warn
   PARAMETERS freq, duration
   SET BELL TO freq, duration
   @ 24,0 SAY CHR(7)
RETURN

* Pick file list
PROCEDURE flist
   SAVE SCREEN TO sfile
   SET BORDER TO DOUBLE
   SET COLOR TO W/R
   DEFINE POPUP pfile FROM 3, 9 TO 18,24 PROMPT FILES LIKE *.dbf ;
      MESSAGE "Select the Corrupted Database file to Recover"
   ON SELECTION POPUP pfile DEACTIVATE POPUP
   @ 4,11 FILL TO 19,26 COLOR N+/N
   ACTIVATE POPUP pfile
   IF .NOT. ISBLANK(PROMPT())
      mfile = PROMPT()
      USE (mfile)
   ENDIF
   SET COLOR TO &mattrib
   RESTORE SCREEN FROM sfile
   RELEASE SCREEN sfile
   RELEASE POPUP pfile
RETURN

*-  UDF Section
FUNCTION center
   PARAMETER mstring, mlength
RETURN STUFF(SPACE(mlength), (mlength - LEN(mstring))  / 2,;
       LEN(mstring), mstring)
