* Program: FixCnt.prg
*
* Author: Jim Booth
*
* Purpose: Repair an incorrect record count in a
*          .DBF file header
* Parameter: lcFileName Type Char the name of the
*            file to be repaired
* Returns:  Logical .T. Repair was successfull
*                   .F. Error during attempted
*                       repair
*

PARAMETERS lcFileName    && File to be tested/fixed

IF TYPE("lcFileName") <> "C"  
	* If the file name is the wrong type or missing
   WAIT WINDOW "FIX RECORD COUNT: Invalid " + ;
     "parameter passed or parameter missing"
	RETURN .F.
ENDIF

* Trim any leading or trailing spaces off of the
*  file name
lcFileName = ALLTRIM(lcFileName)

* Check for an extension on the file name
IF RAT(".",lcFileName) = 0 .OR. ;
   (LEN(lcFileName)-1) - RAT(".",lcFileName) > 4
	* If an extention was not supplied default to .DBF
	lcFileName = lcFileName + ".dbf"
ENDIF

IF !FILE(lcFileName)
   * If the file does not exist display error message
   * and return .F.
   WAIT WINDOW "FIX RECORD COUNT: File " + ;
     lcFileName + " not found"
	RETURN .F.
ENDIF

* Get the DOS directory information for the file
=ADIR(laDIR,lcFileName)

* Open the file for low level access
lnHandle=fopen(lcFileName,2)

IF lnHandle < 0
   * If error in opening file display message and 
   * return .F.
   WAIT WINDOW "FIX RECORD COUNT: " + ;
     "Error opening file " + lcFileName
	RETURN .F.
ENDIF

* Read the first 12 bytes from the file header
lcString = FREAD(lnHandle,12)

* Get offset to first byte of data from string
lc1stByte = SUBSTR(lcString,9,2)
lnOffset  = ASC(SUBSTR(lc1stByte,1,1))
lnOffset  = lnOffset + (ASC(SUBSTR(lc1stByte,2,1))*256)    

* Get Record length from header
lcRecSize = SUBSTR(lcString,11,2)
lnRecSize = ASC(SUBSTR(lcRecSize,1,1))
lnRecSize = lnRecSize + (ASC(SUBSTR(lcRecSize,2,1))*256)   


* Calculate the actual number of records
* Take the file size and subtract the header
* Divide the result by the record size
lnActRecs = INT((laDir(2) - lnOffset) / lnRecSize)

DIMENSION laByte(4)

* Convert to base 256 for the actual record count
laByte(4) = INT(lnActRecs/256^3)
lnActRecs = lnActRecs - (laByte(4) * 256^3)

laByte(3) = INT(lnActRecs/256^2)
lnActRecs = lnActRecs - (laByte(3) * 256^2)

laByte(2) = INT(lnActRecs/256)             
laByte(1) = lnActRecs - (laByte(2) * 256)  

* Build the string
lcActCnt = ""
FOR lnX = 1 TO 4
	lcActCnt = lcActCnt + CHR(laByte(lnX))
ENDFOR

* Position pointer in the file for the write 
* operation
=FSEEK(lnHandle,4)

* Write the calculated record count to the file
=FWRITE(lnHandle,lcActCnt)

* Close the file
=FCLOSE(lnHandle)

* Return .T. to indicate success
RETURN .T.
