
********************
* Name     FIN_FUNC.PRG
* Author   Lee Thompson
* Notice   Copyright (c) 1988 Lee Thompson
* Date     June 25, 1988
* Updates  August 2, 1988
* Compile  Clipper FIN_FUNC -m
* Link     
* Note     These functions perform identically to functions of
*          the same name as calculated by Lotus 1-2-3, Hewlett-Packard
*          line of business and financial calculators, and others.
********************

FUNCTION PMT                      && Calculates loan payments based on
                                  && given principal, per-period interest
                                  && rate and number of periods/payments
                                  && of loan

    PARAMETERS prin, int, term    && prin - principal
                                  && int  - periodic interest rate
                                  && term - number of terms/compounding 
                                  &&        periods/payments 



    RETURN(round(prin * (int/(1-(int+1)**-term)),2))


**************************

FUNCTION PV                       && Calculates the present value of a series
                                  && of equal payments (each of amount, pmt),
                                  && discounted at a periodic interest rate
                                  && (int), over the number of periods (term).

    PARAMETERS pmt, int, term



    RETURN(round(pmt * (1-(1+int)**-term)/int,2))

*********************

FUNCTION TERM                     && Returns the number of payment periods in
                                  && the term of an ordinary annuity necessary
                                  && to accumulate a future value (prin), 
                                  && earning a periodic interest rate (int)
                                  && with equal payments (pmt).

                                  && To calculate the number of equal payments
                                  && (pmt) required to payoff/amortize a
                                  && loan amount (prin) at the periodic
                                  && interest rate (int), enter the principal
                                  && loan balance AS A NEGATIVE NUMBER!!!!

    PARAMETERS prin, int, pmt

    RETURN(ABS(INT(ROUND(LOG(1+(prin*int/pmt))/LOG(1+int),0))))

* TERM(100000,.10,2000) returns 19, the number of years it will take to
* accumulate $100,000 at 10% a year, compounded annually, if you deposit
* $2,000 a year into the account.
*
* TERM(-1650000,.1125/12,19013.69) returns 180 indicating that it will take
* 180 monthly payments of $19,013.69 to repay a $1,650,000 loan at the 
* interest rate of of 11.25%.  (For monthly payments, the interest is input
* into the FUNCTION() as 11.25/12/100 to get MONTHLY interest in a decimal
* equivalent.
*
* ALWAYS BE SURE TO EXPRESS THE INTEREST RATE IN THE SAME PERIODIC TERMS AS 
* THE PAYMENTS:  annually, semi-annually, quarterly, monthly, etc.

*******************************************

FUNCTION FV                       && Returns the future value of an investment
                                  && based on a series of equal payments, each
                                  && of amount pmt, earning periodic interest
                                  && rate (int) for the number of periods in
                                  && term.  FV assumes the investment is an
                                  && ordinary annuity.

    PARAMETERS pmt, int, term

    RETURN(pmt*((1+int)**term-1)/int)

********************************************

FUNCTION FV_ANN_DUE               && Returns the future value of an annuity
                                  && due, i.e., the payment/deposit is made
                                  && on the first day of a compounding period
                                  && rather than the last day as in an ordinary
                                  && annuity.

    PARAMETERS pmt, int, term

    RETURN((pmt*((1+int)**term-1)/int)*(1+int))

*********************************************
*EOF - FIN_FUNC.PRG/ljt
*********************************************
