;** Structure Finder v1.10
;** findstru.m
;** For dbase-style languages
;** 02/22/90   Roy H. Jennings
;** Copyright 1990, Roy H. Jennings, All Rights Reserved
;**
;** You are allowed and encouraged to distribute these macros to anyone
;** and everyone as long as no charge is associated with the distribution
;** In addition, please do not distribute modified copies of the source files
;**
;** I would be interested in seeing any modifications that you might make
;** and if truly useful I will include in next version along with credits
;**
;** Send on diskette to:
;** Roy H. Jennings
;** 5012 Selena Street
;** Winston-Salem, NC  27106-2329
;**
;** tested only with brief  V3.0
;**
;** The purpose of these macros is to facilitate finding the beginning or
;** end of program structures.
;** The following structures are supported.
;** IF/ELSE/ENDIF  DO CASE/ENDCASE  DO WHILE/ENDDO  BEGIN SEQU/END
;**
;** There are four basic commands that call two macros to perform the work
;**
;** Place your cursor on a line with one of the following commands
;** IF  ELSE  DO CASE  CASE  DO WHILE  BEGIN
;** press the F10 key and type  "fwdstru"  (no quotes)
;** your cursor will be positioned on the end of the current structure
;** regardless of how deep other structures are nested.
;** IF you press a key to interrupt or if somehow you have a mismatched
;** structure then your cursor will return to the line in the buffer where
;** you began the search.
;**
;** Likewise you can search backward from the following lines
;** ELSE  ENDIF  CASE  ENDCASE  ENDDO  END
;** press the F10 key and type "backstru"  (no quotes) operation is the
;** same as fwdstru but in reverse.
;**
;** the two remaining commands find the ELSE part of an IF/ENDIF structure
;** if one exists.  They are  "fwdelse"/"backelse" and as you would think
;** operate only from a line that begins with IF/ENDIF.  You go forward from
;** the IF and backward from the ENDIF.
;**
;** Uppercase equivalents of the macro names are included in this file
;** and only need to be autoloaded in your initials macro.  A commented
;** block of code is included below to make this as easy as a block copy.
;** 
;** Of course these macros can be assigned to keys and executed the easy
;** way.  Sample assignment statements are below.  Be sure to autoload
;** before assigning or brief will return an error.
;**
;**  put this file in your brief\macros directory and compile
;**  by typeing  cm strufind
;**
;**  remember to recompile your initials macro also.
;**
;**  Put the following command in your initials macro to autoload
;**  the macros.  This also takes care of upper/lower case conversion
;**      (autoload "findstru"    "backstru"
;**                              "BACKSTRU"
;**                              "fwdstru"
;**                              "FWDSTRU"
;**                              "fwdelse"
;**                              "FWDELSE"
;**                              "backelse"
;**                              "BACKELSE"
;**                              "fwdstruct"
;**                              "backstruct"
;**      )
;****  the macros can be assigned to keys to reduce typing.  these are the
;****  assignments that I use and are not required for proper operation.
;**
;**      ;** set up key for matching structure macros
;**      (assign_to_key "<Ctrl-O><f>" "fwdstru")
;**      (assign_to_key "<Ctrl-O><F>" "fwdstru")
;**      (assign_to_key "<Ctrl-O><b>" "backstru")
;**      (assign_to_key "<Ctrl-O><B>" "backstru")
;**
;** I know, it looks like something from wordstar.  Well, you're right.
;** Notice there are two statements for each key combination.  this is 
;** because assign_to_key is case sensitive.
;**********************************************************************
;** Version History
;** V1.00  Initial creation.  Consisted of four macros to perform four
;** different types of searches
;**
;** V1.10  Modified to use parameters to determine type of search and
;** thus eliminate need for two of the original macros.  Cut compiled
;** code size in half.
;**********************************************************************
;**
;** make an uppercase version
(macro BACKSTRU
   (backstruct 0)
)
(macro backstru
   (backstruct 0)
)
(macro FWDSTRU
   (fwdstruct 0)
)
(macro fwdstru
   (fwdstruct 0)
)
(macro fwdelse
   (fwdstruct 1)
)
(macro FWDELSE
   (fwdstruct 1)
)

(macro backelse
   (backstruct 1)
)

(macro BACKELSE
   (backstruct 1)
)

;** the actual macros
;**  this macro searches forward
(macro fwdstruct
	(
		(int			srchtype
                  rhj_curr_line
						last_line
                  rhj_level
                  userstop
                  rhj_dummy
		)
		(string     orig_line
						token
                  tokenlist
                  tokenstring
		)
      ;** get parameter passed
      ;** 0 is for normal search, 1 is to search for ELSE only
      (get_parm 0 srchtype)
      ;** set initial values for our flags
      (= tokenstring "DO BEGI CASE IF ELSE FOR ")
      (= tokenlist " ")
      (= rhj_dummy 0)
      (= rhj_level 0)
      (= userstop 0)

		(message "Searching, press any key to abort...")

            (beginning_of_line)           ; move to start of line
				(save_position)               ; save line position
				(inq_position rhj_curr_line)  ; load into rhj_curr_line
				(end_of_buffer)               ; go to end of buffer
				(inq_position last_line)      ; get last line number
            (restore_position)            ; back to starting line to begin
            (save_position)               ; save position and begin search

		;**   Begin a search through each line of buffer for conditional
		;**   commands.  Any key press will abort.

				(= orig_line (trim (ltrim (read))))
				(= token (substr (upper orig_line) 1 4))

            ;** remove some more whitespace
				(if (= rhj_dummy (search_string "[ \\t]" token NULL 1))
					(= token (substr token 1 (-- rhj_dummy)))
				)
				;**	Ignore the line if token not in our list

				(if (&& (strlen token) (index tokenstring (+ token " ")))

					(switch token
                  ;** here we determine what our valid token list will be

						"DO" (
								   (if (search_string "DO[ \t]+WHIL" orig_line NULL 1 0)
                              (
                                 (= tokenlist "DO ENDC ENDD ")
                              )
								   )
								   (if (search_string "DO[ \t]+CASE" orig_line NULL 1 0)
                              (
                                 (= tokenlist "DO ENDC ENDD ")
                              )
								   )
							  )

						"BEGI" (
                           (= tokenlist "BEGI END ")
                         )

						"IF"   (
                           (if (== srchtype 1)
                              (= tokenlist "IF ELSE ENDI ")
                              (= tokenlist "IF ENDI ")
                           )
                         )
                  "FOR" (
                           (= tokenlist "FOR NEXT ")
                        )
                  ;** we set a false level here so rhj_level will be
                  ;** non zero first time through processing loop
                  "ELSE" (
                           (= tokenlist "IF ENDI ")
                           (= rhj_level 1)
                         )
                  "CASE" (
                           (= tokenlist "DO ENDC ENDD ")
                           (= rhj_level 1)
                         )

					)
				)


		(while (&& (<= rhj_curr_line last_line)(! (inq_kbd_char)))
			(
				;**	We read the current line into orig_line (after
				;**	trimming whitespace) and put a the first 4 chars
				;**	in token and convert to upper case and trim blanks

				(= orig_line (trim (ltrim (read))))
				(= token (substr (upper orig_line) 1 4))

            ;** remove some more whitespace
				(if (= rhj_dummy (search_string "[ \\t]" token NULL 1))
					(= token (substr token 1 (-- rhj_dummy)))
				)
				;**	Ignore the line if token not in our list

				(if (&& (strlen token) (index tokenlist (+ token " ")))

					(switch token

						;**	If DO is followed by CASE or WHILE we increase
						;**	the level count by 1

						"DO"
							(
								(if (search_string "DO[ \t]+WHIL" orig_line NULL 1 0)
                           (
                              (+= rhj_level 1)
                           )
								)
								(if (search_string "DO[ \t]+CASE" orig_line NULL 1 0)
                           (
                              (+= rhj_level 1)
                           )
								)
							)

                  "FOR"  NULL
						"BEGI" NULL
						"IF"   (
                           (+= rhj_level 1)
                         )

                  ;** these tokens decrease the current level by 1
                  "ELSE" NULL
                  "NEXT" NULL
						"END"  NULL
						"ENDD" NULL
						"ENDI" NULL
                  "ENDC" (
                           (-= rhj_level 1)
                         )

					)
				)

            ;** test to see if back to original level and if so
            ;** exit this loop
            (if (== rhj_level 0)
               (break)
            )
            ;**  move to next line and show cursor movement
				(move_abs (++ rhj_curr_line) 1)
				(refresh)

			)
		)
      (if (inq_kbd_char)
         (= userstop 1)
      )
		(keyboard_flush)
      (if (== rhj_level 0)
         (
            ;* -- tell user we found the line
               (message "Found.")
         )
         ;else
         (
            ;** back to original position if keypressed or 
            ;   show error message if match not found
            (if (== userstop 0)
               ( error "No match found for this structure" )
               ;else
               ( message "Search aborted...")
            )
            (restore_position)
         )
      )
	)
)

;** this macro searches backward
(macro backstruct
	(
		(int			srchtype
                  rhj_curr_line
						last_line
                  rhj_level
                  userstop
                  rhj_dummy
		)
		(string     orig_line
						token
                  tokenlist
		)
      ;** set initial values for our flags
      ;** 0 is for normal search, 1 is to search for ELSE only
      (get_parm 0 srchtype)
      (= tokenlist " ")
      (= rhj_dummy 0)
      (= rhj_level 0)
      (= userstop 0)

		(message "Searching, press any key to abort...")

            (beginning_of_line)           ; move to start of line
				(save_position)               ; save line position
				(inq_position rhj_curr_line)  ; load into rhj_curr_line
				(top_of_buffer)               ; go to top of buffer
				(inq_position last_line)      ; get first line number
            (restore_position)            ; back to starting line to begin
            (save_position)               ; save position and begin search

		;**   Begin a search through each line of buffer for conditional
		;**   commands.  Any key press will abort.

				(= orig_line (trim (ltrim (read))))
				(= token (substr (upper orig_line) 1 4))

            ;** remove some more whitespace
				(if (= rhj_dummy (search_string "[ \\t]" token NULL 1))
					(= token (substr token 1 (-- rhj_dummy)))
				)
				;**	Ignore the line if token not in our list

				(if (&& (strlen token) (index "CASE ELSE END ENDD ENDI ENDC NEXT "
                  (+ token " ")))

					(switch token

						;**	We build our valid token list here

						"ENDD" NULL
						"ENDC" (
                            (= tokenlist "DO ENDC ENDD ")
							    )

						"END" (
                           (= tokenlist "BEGI END ")
                         )
                  "NEXT" (
                           (= tokenlist "FOR NEXT ")
                         )

						"ENDI" (
                           (if (== srchtype 1)
                              (= tokenlist "IF ELSE ENDI ")
                              (= tokenlist "IF ENDI ")
                           )
                         )
                  ;** we set a false level here so rhj_level will be
                  ;** non zero first time through processing loop
                  "ELSE" (
                           (= tokenlist "IF ENDI ")
                           (= rhj_level 1)
                         )
                  "CASE" (
                           (= tokenlist "DO ENDC ENDD ")
                           (= rhj_level 1)
                         )

					)
				)


		(while (&& (>= rhj_curr_line last_line)(! (inq_kbd_char)))
			(
				;**	We read the current line into orig_line (after
				;**	trimming whitespace) and put a the first 4 chars
				;**	in token and convert to upper case and trim blanks

				(= orig_line (trim (ltrim (read))))
				(= token (substr (upper orig_line) 1 4))

            ;** remove some more whitespace
				(if (= rhj_dummy (search_string "[ \\t]" token NULL 1))
					(= token (substr token 1 (-- rhj_dummy)))
				)
				;**	Ignore the line if token not in our list

				(if (&& (strlen token) (index tokenlist (+ token " ")))

					(switch token
                  ;**   these tokens decrease the current level by 1
						;**	If DO is followed by CASE or WHILE we increase
						;**	the level count by 1

						"DO"
							(
								(if (search_string "DO[ \t]+WHIL" orig_line NULL 1 0)
                           (
                              (-= rhj_level 1)
                           )
								)
								(if (search_string "DO[ \t]+CASE" orig_line NULL 1 0)
                           (
                              (-= rhj_level 1)
                           )
								)
							)

                  "ELSE" NULL
                  "FOR"  NULL
						"BEGI" NULL
						"IF"   (
                           (-= rhj_level 1)
                         )

                  ;** these tokens increase the current level by 1

                  "NEXT" NULL
						"END"  NULL
						"ENDD" NULL
						"ENDI" NULL
                  "ENDC" (
                           (+= rhj_level 1)
                         )

					)
				)

            ;** test to see if back to original level and if so
            ;** exit this loop
            (if (== rhj_level 0)
               (break)
            )
            ;**  move to next line and show cursor movement
				(move_abs (-- rhj_curr_line) 1)
				(refresh)

			)
		)
      (if (inq_kbd_char)
         (= userstop 1)
      )
		(keyboard_flush)
      (if (== rhj_level 0)
         (
            ;* -- tell user we found the line
               (message "Found.")
         )
         ;else
         (
            ;** back to original position if keypressed or 
            ;   show error message if match not found
            (if (== userstop 0)
               ( error "No match found for this structure" )
               ;else
               ( message "Search aborted...")
            )
            (restore_position)
         )
      )
	)
)



