 *****************************************************************************
 ***           T H E  I R O N  C L A D  S T E E L  S I E V E               ***
 *****************************************************************************

**     This program will validate a freeform DRIVE\PATH\FILENAME combination
** in order to assure that an invalid character occurrence is not present
** when a user is permitted to type in a complete DOS Filespec including
** the LETTER and PATH.   The only reason you would even have to allow this
** would be in the case of a Download, ASCII Extract or Upload situation where
** the user may be given the opportunity to enter a User-Selected Filename and
** may have a tendency to use invalid characters while attempting to FREE-FORM 
** the complete MS-DOS File Specification including sub-directory and slashes.

** Rather than having a complete bomb-out to DOS occur because of an Error,
** this routine will trap almost all possible problems until the user creates
** a completely ERROR-FREE single sub-directory File Specification for MS-DOS.

** It is not possible, to the best of my knowledge, to re-create an old
** error that was previously corrected without having this system trap it
** on the second and all subsequent attempts.

** If you are able to find a File naming convention Error which slips through
** this supposedly Iron Clad Steel Sieve please let me know about it and I
** will attempt to fix it in subsequent upgrades.  If you have a suggested fix
** please do not hesitate to suggest it.

**     Written entirely in Clipper, this routine will also assure that
** the Sub-Directory Path and Drive Letter are valid, that the filename does
** not exist already and other goodies which usually have to be done using
** Assembly, C or some other arcane methodology.

** LAST MODIFIED DATE: 11/07/88
** BY: John Bevilaqua  Compuserve:  76057,1576
** Written for Brookvale Associates, Inc. 
** All Rights Reserved - Copyright 1988,1989 Brookvale Associates, Inc.
************************************************************************
TEXT

 You should create a subdirectory C:\RAMSES or RENAME this reference in the
 following program to something more appropriate, if you so desire.

ENDTEXT

@ 0,0 CLEAR

SET PATH TO C:\RAMSES
STORE .T. TO ERRORS

STORE "                    " TO FILENAME
PATH_SET = GETE("CLIP_PATH")
STORE "C:\RAMSES\          " TO PATH_SET
@ 0,0 CLEAR

@ 2,25 SAY "Brookvale Associates, Inc."
@ 4,25 SAY "-The Iron Clad Steel Sieve"
*************
STORE 10 TO J
*************
@ J,1 SAY;
"Enter the DRIVE LETTER and PATH NAME only if different than the current one"
STORE J + 1 TO J
STORE RTRIM(PATH_SET) TO PATHNAME
@ J,1 SAY;
"The current DOS PATH will default to: &PATHNAME unless you enter another one"
STORE J + 1 TO J
STORE PATH_SET + SPACE(24-LEN(TRIM(PATH_SET))) TO FILENAME
DO WHILE ERRORS = .T.
STORE 4 TO J
STORE FILENAME + SPACE(24-LEN(TRIM(FILENAME))) TO FILENAME
STORE J + 2 TO J
@ J,1 SAY;	
"Enter the Drive:\Path\Filename WITH NO Extension:";
GET FILENAME PICT "!!!!!!!!!!!!!!!!!!!!"
STORE J + 1 TO J

@ J,1 SAY;	
"As an EXAMPLE, you might use this PATH FORMAT:    C:\RAMSES\JUL27DAT        "
STORE J + 1 TO J

@ J,1 SAY;
"where 'C:' is the DRIVE, '\RAMSES\' the DIR PATH and 'JUL27DAT' the FILENAME"
STORE J + 2 TO J

@ J,5 SAY;
 "  -OR- Type in the word 'EXIT' to abandon this operation...                "
STORE J + 2 TO J

@ J,1 SAY;
 "The System will ADD the '.TXT' extension to the complete filename later"
STORE J + 1 TO J

IF INKEY() = 28
SAVE SCREEN

STORE J + 1 TO J
@ J,1 SAY;
 "You must follow ALL of the MS-DOS File naming conventions and rules:"
STORE J + 2 TO J
@ J,5 SAY;
 "1. Filenames must be a MAXIMUM of 8 Numbers or Characters in Length"
STORE J + 1 TO J
@ J,5 SAY;
 "2. Do NOT use Wildcard (* ?) Characters anywhere in the Name"
STORE J + 1 TO J
@ J,5 SAY;
 '3. Do NOT use Extraneous Characters like: { [ : " | + = } ] \'
STORE J + 1 TO J
@ J,5 SAY;
 "4. Do NOT BEGIN or END a Filename with a / or \ to avoid confusion"
STORE J + 1 TO J
@ 19,5 SAY;
"5. Any other DRIVE\PATH\FILENAME conventions established in DOS"
ACCEPT "...Press any key to continue" TO ANS
RESTORE SCREEN
ENDIF INKEY() = 28

READ

IF FILENAME = "EXIT   "	
  EXIT
ENDIF

FILENAME = TRIM(UPPER(FILENAME))
STRLEN = LEN(FILENAME)

DO WHILE STRLEN > 0 .AND. .NOT. SUBSTR(FILENAME,STRLEN,1) $ '"[]/<>+=;{},'
  STRLEN = STRLEN-1
ENDDO

STORE "The File Name contains valid characters for DOS file formats now!" ;
 TO ERRMSG  					

*****************
STORE J + 10 TO J
*****************

@ J,0

DO CASE

CASE LEN(FILENAME) = 0 .OR. AT(":",FILENAME) = LEN(FILENAME)
ERRMSG = "You must enter a Path and File Name or 'EXIT' to leave this routine"
@ J,0 SAY ERRMSG + SPACE(80-LEN(TRIM(ERRMSG)))
LOOP

CASE SUBSTR(FILENAME,LEN(FILENAME),1) = "\"
ERRMSG = "You Cannot End the File Name with a '\' ...Enter Filename or EXIT <CR>"
@ J,0 SAY ERRMSG + SPACE(80-LEN(TRIM(ERRMSG)))
LOOP

CASE RTAT(".",FILENAME) > RTAT("\",FILENAME)
ERRMSG = "Do not enter a Period (.) or File Name Extension like .TXT or .PRN"
@ J,0 SAY ERRMSG + SPACE(80-LEN(TRIM(ERRMSG)))
LOOP

CASE "\\" $ FILENAME
ERRMSG = "Error: Do not use two consecutive '\\' backslashes in filenames"
@ J,0 SAY ERRMSG + SPACE(80-LEN(TRIM(ERRMSG)))
LOOP

CASE STRLEN > 0
ERRMSG='Invalid Character(s) in Name - Do not use: " [ ] / < > + = { } ; , |'
@ J,0 SAY ERRMSG + SPACE(80-LEN(TRIM(ERRMSG)))
LOOP

CASE "*" $ FILENAME .OR. "?" $ FILENAME
ERRMSG = "Error: Do NOT use Wildcard Symbols like '*' or '?' in the File Name"
@ J,0 SAY ERRMSG + SPACE(80-LEN(TRIM(ERRMSG)))
LOOP

CASE ":" $ FILENAME .AND. (AT(":",FILENAME) <> 2 .OR. RTAT(":",FILENAME)<>2)
ERRMSG="The Colon ':' is NOT in correct location - use ONLY after a DRIVE letter"
@ J,0 SAY ERRMSG + SPACE(80-LEN(TRIM(ERRMSG)))
LOOP

CASE ":" $ FILENAME .AND. AT(":",FILENAME)=2 .AND. SUBSTR(FILENAME,1,1)= " "
IF LEN(TRIM(NETNAME())) = 0
ERRMSG="The Drive designation Letter must NOT be LEFT BLANK - Use A->L for DOS"
  ELSE
ERRMSG="The Drive designation Letter must NOT be LEFT BLANK - Use A->Z for PC N/W"
ENDIF LEN(TRIM(NETNAME())) = 0
@ J,0 SAY ERRMSG + SPACE(80-LEN(TRIM(ERRMSG)))
LOOP

CASE ":" $ FILENAME .AND. AT(":",FILENAME)=2 .AND.;
 SUBSTR(FILENAME,1,1) $ "ABCDEFGHIJKL" = .F. .AND. LEN(TRIM(NETNAME())) = 0
ERRMSG="The Drive designation Letter must be in the Range from 'A' thru 'L'"
@ J,0 SAY ERRMSG + SPACE(80-LEN(TRIM(ERRMSG)))
LOOP

CASE ":" $ FILENAME .AND. AT(":",FILENAME)= 2 .AND. SUBSTR(FILENAME,1,1);
 $ "ABCDEFGHIJKLMNOPQRSTUVWZYZ" = .F. .AND. LEN(TRIM(NETNAME())) <> 0
ERRMSG="The Drive designation Letter must be in the Range from 'A' thru 'Z'"
@ J,0 SAY ERRMSG + SPACE(80-LEN(TRIM(ERRMSG)))
LOOP

OTHERWISE

@ J-1,0 CLEAR

ENDCASE

@ J,0

*** colon position
COLONPOS= 0

*** first slash
FIRSTSL = 0

*** last slash
LASTSL  = 0

*** first blank
FIRSTBL = 25
*** SET TO 25 TO CATCH LONG FILENAME AFTER REGULATION DIR NAME

STORE "The File Name and/or Directory Name are the right Length now " to LENMSG

COLONPOS = AT(":",FILENAME)

FIRSTSL =  AT("\",FILENAME)

LASTSL  =  RAT("\",FILENAME)

FIRSTBL =  LEN(RTRIM(FILENAME)) + 1

FILENAME = TRIM(UPPER(FILENAME))
FILELEN = FIRSTBL -1

DO WHILE FILELEN > 0 .AND. .NOT. SUBSTR(FILENAME,FILELEN,1) = " "
  FILELEN = FILELEN-1
ENDDO

@ J,0

DO CASE

*** ERROR CASE WITH D:\ AND EMBEDDED BLANKS IN FILENAME:
CASE FILELEN > 0
STORE "Error: The PATH and/or FILE Name contains embedded BLANKS" TO LENMSG
@ J,0 SAY LENMSG + SPACE(80-LEN(TRIM(LENMSG)))
STORE .T. TO ERRORS
LOOP

*** THE OK CASE WITH D:\ AND NO SUB-DIRECTORY:
CASE FIRSTBL <= 12 .AND. FIRSTSL = 3 .AND. COLONPOS = 2
STORE "OK: File Name Length has 8 or fewer valid characters " TO LENMSG
STORE .F. TO ERRORS

*** THE ERROR CASE WITH D:\ AND NO SUB-DIRECTORY:
CASE FIRSTBL > 12 .AND. FIRSTSL = 3 .AND. COLONPOS = 2 .AND. LASTSL = FIRSTSL
LENMSG="Error: File Name has MORE THAN than 8 Characters. It will be shortened"
@ J,0 SAY LENMSG + SPACE(80-LEN(TRIM(LENMSG)))
STORE .T. TO ERRORS
LOOP

*** THE ERROR CASE WITH D: AND NO SUB-DIRECTORY:
CASE FIRSTBL > 11 .AND. FIRSTSL = 0 .AND. COLONPOS = 2 .AND. LASTSL = 0
LENMSG="Error: File Name has MORE THAN than 8 Characters. It will be shortened"
@ J,0 SAY LENMSG + SPACE(80-LEN(TRIM(LENMSG)))
STORE .T. TO ERRORS
LOOP

*** THE ERROR CASE WITH D:\ AND A SUB-DIRECTORY:
CASE FIRSTBL > 12 .AND. FIRSTSL=3 .AND. COLONPOS=2 .AND. LASTSL >= FIRSTSL;
.AND. LASTSL - FIRSTSL > 9    								
LENMSG="Error: Directory Name has MORE THAN than 8 Characters. It will be shortened"
@ J,0 SAY LENMSG + SPACE(80-LEN(TRIM(LENMSG)))
STORE .T. TO ERRORS
LOOP

*** THE ERROR CASE WITH D\SUB\FILENAME AND NO COLON :
CASE  FIRSTSL <> 1 .AND. FIRSTSL <> 3 .AND. COLONPOS = 0
STORE "Error: There must be a Colon ':' present AFTER the Drive Letter" TO LENMSG
@ J,0 SAY LENMSG + SPACE(80-LEN(TRIM(LENMSG)))
STORE .T. TO ERRORS
LOOP

*** THE ERROR CASE WITH D:SUB\FILENAME AND NO FIRST SLASH:
CASE  FIRSTSL <> 3 .AND. COLONPOS = 2
STORE "Error: There must be a Slash '\' present AFTER the Drive Colon" TO LENMSG
@ J,0 SAY LENMSG + SPACE(80-LEN(TRIM(LENMSG)))
STORE .T. TO ERRORS
LOOP

*** ERROR CASE WITH D:\ AND NO SUB-DIRECTORY:
CASE FIRSTBL > 12 .AND. FIRSTSL = 3 .AND. LASTSL = 0
LENMSG="Error: File Name has MORE THAN than 8 Characters. It will be shortened"
@ J,0 SAY LENMSG + SPACE(80-LEN(TRIM(LENMSG)))
STORE .T. TO ERRORS	 				
LOOP

*** ERROR CASE WITH D: AND NO SUB-DIRECTORY
CASE ":" $ FILENAME = .F. .AND. FIRSTSL = 0 
LENMSG="Error: Missing the Drive Name 'C:' and/or the leading '\' in the Path"
@ J,0 SAY LENMSG + SPACE(80-LEN(TRIM(LENMSG)))
STORE .T. TO ERRORS
LOOP

*** ERROR CASE WITH D BUT NO COLON AND A SUB-DIRECTORY 
CASE FIRSTSL > 1 .AND. COLONPOS = 0
LENMSG= "Error: There must be a Colon right AFTER the Drive and BEFORE the '\'" 
@ J,0 SAY LENMSG + SPACE(80-LEN(TRIM(LENMSG))) 
STORE .T. TO ERRORS
LOOP

*** ERROR CASE WITH D: NO SUB-DIRECTORY 
CASE FIRSTBL >= 11 .AND. FIRSTSL = 0 .AND. LASTSL = 0
STORE "Error: File Name Length is more than 8 valid characters " TO LENMSG
@ J,0 SAY LENMSG + SPACE(80-LEN(TRIM(LENMSG)))
STORE .T. TO ERRORS
LOOP

*** THE OK CASE WITH D: ONLY AND NO SLASH FOR SUB-DIRECTORY:
CASE FIRSTBL < 11 .AND. FIRSTSL = 0 .AND. COLONPOS = 2
 STORE "File Name Length has 8 or fewer valid characters " TO LENMSG
@ J,0 SAY LENMSG + SPACE(80-LEN(TRIM(LENMSG)))
STORE .F. TO ERRORS



*** ERROR CASE WITH D: ONLY AND NO SLASH FOR SUB-DIRECTORY:
CASE FIRSTBL > 11 .AND. FIRSTSL = 0 .AND. COLONPOS = 2
STORE "Error: File Name Length has more than 8 valid characters " TO LENMSG
@ J,0 SAY LENMSG + SPACE(80-LEN(TRIM(LENMSG)))
STORE .T. TO ERRORS
LOOP

*** ERROR CASE WITH D:\XXXX\XXXXXX
CASE (LASTSL > FIRSTSL) .AND. (LASTSL - FIRSTSL > 9)
STORE "Error: The Directory Name Length has more than 8 valid characters" TO LENMSG
@ J,0 SAY LENMSG + SPACE(80-LEN(TRIM(LENMSG)))
STORE .T. TO ERRORS
LOOP

*** ERROR CASE WITH D:\XXXX\123456789 				
CASE (LASTSL > FIRSTSL) .AND. (FIRSTBL - LASTSL > 9)
 STORE "Error: The File Name Length has more than 8 valid characters" TO LENMSG
@ J,0 SAY LENMSG + SPACE(80-LEN(TRIM(LENMSG)))
 STORE .T. TO ERRORS
 LOOP

*** OK CASE WITH NO SLASH OR COLON OR DRIVE LETTER, JUST FILENAME:
CASE FIRSTBL <= 8 .AND. FIRSTSL = 0 .AND. COLONPOS = 0
STORE "File Name Length has 8 or fewer valid characters " TO LENMSG
STORE .F. TO ERRORS

*** ERROR CASE WITH NO SLASH OR COLON OR DRIVE LETTER, JUST FILENAME:
CASE FIRSTBL > 8 .AND. FIRSTSL = 0 .AND. COLONPOS = 0
 STORE "Error: File Name Length has more than 8 valid characters " to LENMSG
@ J,0 SAY LENMSG + SPACE(80-LEN(TRIM(LENMSG)))
STORE .T. TO ERRORS
LOOP

OTHERWISE

STORE .F. TO ERRORS

 @ J,0

 @ J,0 SAY LENMSG
 STORE " " TO ANS

ENDCASE

 STORE " " TO ANS
 FILENAME_TXT = FILENAME + ".TXT"

DO WHILE ANS = " "

@ J,0 SAY;
"The File will be Named: &FILENAME_TXT ...Is this Correct [Y/N] ?";
 GET ANS PICT "!"
 READ
   IF ANS = "Y"	.OR. ANS = "N"
      EXIT
   ENDIF
ENDDO WHILE ANS = " "

 IF ANS = "N"
   STORE .T. TO ERRORS
   LOOP
 ENDIF

STORE " " TO ANS
STORE "N" TO PATHWORKS

DO WHILE ANS = " "

 IF FILE("&FILENAME_TXT")
STORE "Y" TO PATHWORKS
@ J,0 SAY;
"The File: &FILENAME_TXT ...Exists. Replace it with this file? [Y/N]" ;
 GET ANS PICT "!"
   READ
 ELSE
   EXIT
 ENDIF FILE("&FILENAME_TXT")

ENDDO WHILE ANS = " "

 IF ANS = "N"
  STORE .T. TO ERRORS
  LOOP
 ENDIF

IF FILENAME = "EXIT      "
  EXIT
ENDIF

IF SUBSTR(FILENAME,1,4) = "EXIT"
  EXIT
ENDIF

shandle = FCREATE("&FILENAME_TXT")
IF FERROR() <> 0 .AND. PATHWORKS = "N"
LENMSG="File Error: Sub-Directory Path does NOT exist OR is unavailable to DOS"
@ J,0 SAY LENMSG + SPACE(80-LEN(TRIM(LENMSG)))
STORE .T. TO ERRORS
LOOP
ENDIF FERROR() <> 0

@ J-1,0 CLEAR
***********************************************************************
*** INSERT YOUR OWN FILE SAVE OR FILE CREATE COMMANDS HERE:
***
    IF FILE("PERSONS.DBF")
      USE PERSONS
      COPY NEXT 3 TO &FILENAME_TXT SDF
    ELSE
      set alter on
      set alternate to &FILENAME_TXT
      @ J,0 SAY "The File 'PERSONS.DBF' is not in the Current Directory"
      @ J+1,1 SAY "This File was created by the Clipper Filespec.prg"
      @ J+2,1 SAY "Copyright 1988, 1989 Brookvale Associates, Inc."
      set alter to
      STORE .T. TO ERRORS
      LOOP
    ENDIF
***
************************************************************************
************************************************************************

@ J,0 SAY;
 "  The File named: &FILENAME_TXT was successfully written to disk"
**** NOTE: REMOVE THIS LOOP IN THE PRODUCTION SYSTEM (FOR TEST USAGE ONLY):
STORE .T. TO ERRORS
LOOP
*************************************************************************
		
ENDDO WHILE ERRORS = .T.

FUNCTION RTAT
INSTR1 = "        "
INSTR2 = "        "
PARAMETERS INSTR1, INSTR2
PRIVATE POSITION
POSITION = LEN(INSTR2)

DO WHILE POSITION > 0 .AND. .NOT. INSTR1 $ SUBSTR(INSTR2,POSITION)
  POSITION = POSITION -1
ENDDO

RETURN(POSITION)
** EOF(RTAT)

