**BEGIN HEADER**
*---------------------------------------------------------------------------
* NAME          FFWFONT.PRG
*
* SYSTEM        Foxfire! V2.5
*
* DESCRIPTION   Utility to install Windows fonts
*
* CALLED BY     command window
*
* CALLS         none
*
* COMMENT       This code will write changes to your WIN.INI file,
*               so use it cautiously.
*---------------------------------------------------------------------------
**BEGIN SAMPLE**
*---------------------------------------------------------------------------
* EXAMPLE CALLS
*    DO FFWFONT
*
*---------------------------------------------------------------------------
**END SAMPLE**
*---------------------------------------------------------------------------
* ARGUMENT LIST
*
*     NAME      TYPE/LENGTH                DESCRIPTION
* ------------- ----------- -------------------------------------------
* none
*---------------------------------------------------------------------------
* VARIABLE RETURNED
*
*     NAME      TYPE/LENGTH                DESCRIPTION
* ------------- ----------- -------------------------------------------
* none
*---------------------------------------------------------------------------
* REVISION HISTORY
* 01/04/94  ASN  Initial release
*
*---------------------------------------------------------------------------
*
* Copyright (c) 1992,1993 by Micromega Systems, Inc., San Francisco, CA, USA
* World Rights Reserved.
*
**END HEADER**

  PRIVATE lcFFWtalk,lcFFWsafe,lcWinDir,llIniMod,lnFontAt,;
          lnNewLn,lcFOTFile,laFFWFonts, laOldFonts

  IF SET('TALK') = 'ON'
     SET TALK OFF
     lcFFWtalk = 'ON'
  ELSE
     lcFFWtalk = 'OFF'
  ENDIF
  lcFFWsafe = SET('SAFETY')
  SET SAFETY OFF

  IF !_WINDOWS
     WAIT WINDOW 'This code works under FoxPro for Windows only'
     SET SAFETY &lcFFWsafe
     SET TALK &lcFFWtalk
     RETURN
  ELSE
     lcWinDir = GETENV('WINDIR')    && Windows 3.x standard environment variable
     IF EMPTY(lcWinDir)
        WAIT WINDOW "Windows directory unknown -- can't find WINDIR variable"
        SET SAFETY &lcFFWsafe
        SET TALK &lcFFWtalk
        RETURN
     ELSE
        * edit a copy of WIN.INI in a scratch memo
        CREATE CURSOR FFWFTEMP (FFWFIni M)
        INSERT BLANK
        APPEND MEMO FFWFIni FROM (lcWinDir+'\WIN.INI')
        llIniMod = .f.   && changed contents?
        * locate the [fonts] section and set pointer
        lnFontAt = AT('[fonts]',FFWFTEMP.FFWFIni)
        IF lnFontAt < 1
           WAIT WINDOW 'WIN.INI has no [fonts] section, no way to add new fonts'
           SET SAFETY &lcFFWsafe
           SET TALK &lcFFWtalk
           RETURN
        ELSE
           * set pointer for insert of new lines
           lnNewLn = lnFontAt + LEN('[fonts]')
        ENDIF
     ENDIF
  ENDIF

  DIME laFFWFonts(2,4)     && fonts to install
  * column 1 = font file path
  * column 2 = font file name
  * column 3 = font name as it appears in font picker
  * column 4 = font string for WIN.INI -- case-sensitive!
  laFFWFonts(1,1) =  "FONTS\"
  laFFWFonts(1,2) =  "FOXFONT.FON"
  laFFWFonts(1,3) =  "FoxFont"
  laFFWFonts(1,4) =  "FoxFont 7,9=FOXFONT.FON"
  laFFWFonts(2,1) =  "FONTS\"
  laFFWFonts(2,2) =  "FFDIX25A.FOT"
  laFFWFonts(2,3) =  "Dixon Mono Thin"
  laFFWFonts(2,4) =  "Dixon Mono Thin (TrueType)=FFDIX25A.FOT"

  =AFONT(laOldFonts)     && one-dimensional array of already-installed fonts

  PRIVATE lnCnt
  FOR lnCnt = 1 TO ALEN(laFFWFonts,1)
      * font already installed?
      IF NOT (ASCAN(laOldFonts,laFFWFonts[lnCnt,3]) > 0)

         * copy file to Windows SYSTEM dir
         COPY FILE (laFFWFonts[lnCnt,1]+laFFWFonts[lnCnt,2]) ;
              TO (lcWinDir+'\SYSTEM\'+laFFWFonts[lnCnt,2])

         * if file is .FOT, copy the .TTF too (TrueType)
         IF '.FOT' $ laFFWFonts[lnCnt,2]
            lcFOTFile = STRTRAN(laFFWFonts[lnCnt,2],'.FOT','.TTF')
            COPY FILE (laFFWFonts[lnCnt,1]+lcFOTFile) ;
               TO (lcWinDir+'\SYSTEM\'+lcFOTFile)
         ENDIF

         * add the line to .INI file
         REPLACE FFWFTEMP.FFWFIni WITH LEFT(FFWFTEMP.FFWFIni,lnNewLn) + ;
           + CHR(13) + CHR(10) + laFFWFonts[lnCnt,4] + ;
           SUBSTR(FFWFTEMP.FFWFIni,lnNewLn+1)

         llIniMod = .t.
      ENDIF
  ENDFOR

  * write changed INI file and get out
  IF llIniMod
     COPY FILE (lcWinDir+'\WIN.INI') TO (lcWinDir+'\WININI.FF')
     COPY MEMO FFWFTEMP.FFWFIni TO (lcWinDir+'\WIN.INI')
     WAIT WINDOW 'Font(s) installed -- exit Windows and restart so you can use them'
  ELSE
     WAIT WINDOW 'All fonts were already installed'
  ENDIF
  USE IN FFWFTEMP
  SET SAFETY &lcFFWsafe
  SET TALK &lcFFWtalk
RETURN
**EOF FFWFONT.PRG**
