************************************************************************************************
*
*														Faxing from FoxPro Windows
*														using DDE to WinFax Pro 4.0
*
*														Compiled by Wayne Willingham
*															 Cambridge Consulting
*																 Survivor Software
*
*																	(214) 783-0094
*																Fax: (214) 783-0095
*																	CIS: 76170,2016
*
*		All code contained herein is provided as an example, and the author/compiler
*		assumes responsibility for it's implementation or use.  You're on your own!!
*
************************************************************************************************

IF .F.
	TEXT

	I opened up my big mouth and promised to assemble some samples of how
	we're faxing out of FoxPro using WinFax Pro, so here it is.

A few things:

1.	You MUST have WinFax Pro 4.0 of to do a DDE attachment - 3.0 didn't have it. WinFax 3.0
		CAN send faxes via DDE, though...

2.	Note the difference in the time formats of ADIR() and TIME() on times before 10:00 AM
			ADIR() uses [ 9:30:00]
			TIME() uses [09:30:00]
		that missing zero will get you when you try to compare the two!!

3.	We've used several modems with WinFax.  USR Sportsters, Boca, and so on.  But our best
		results have been with Intel Satisfaxtion 400 modems.  They are CAS-compliant right out
		of the box, and were able to connect with every kind of fax receiver with no problem.
		(We had particular trouble with the USR's connecting to Monroe Laser Fax machines)
		And yes, the Intel is more money, but if your client is sending CRITICAL faxes as
		our client is, the extra hundred bucks is no biggie.

4.	If you're working on a Novell network and will be doing HIGH VOLUME faxing (we're doing
		200 to 500 per night!), I highly recommend the Cheyenne FaxServer.  Cheyenne can manage up
		to four fax modems on separate lines, and "roll over" from one to the next, so you can
		effectively send four faxes simultaneously.

5.	One of our Cambridge Consulting coding standards is to use left and right brackets
		in place of quotes.  This is confusing to some because you immediately think of arrays,
		but we've become quite comfortable with it.  It also comes in REAL handy when you're
		doing string manipulations like in this sample.

6.	WinFax can export it's send log to a DBF file, but there is no DDE provision to
		execute that function.  We've used a RECORDER.EXE macro with limited success, but 
		have opted to do it manually every day, which also get the user into WinFax to delete 
		all the faxes scheduled for December 31, 1999 in the DUMMYFAX procedure


The data we're dealing with is shipping information contained in two tables:

	SHIPMENT.DBF  Ship from/to information - The only significant fields here are
								Shipment.Shipment, which is like a unique invoice number, and
								Shipment.Carrier, which is the unique ID of the freight company
								who will handle the shipment, and is the recipient of the fax.

	SHIPITEM.DBF	Line item detail of all items being shipped.  The only significant
								field for our purposes is Product_ID, which refers to the ATTACH
								table to get attachments


	LOCATION.DBF	Holds the fax recipient information.  This is who will handle the shipment,
								and we're faxing them their instructions, called an ALERT.
			locationID	C 10
			name 				C 25
			address1  	C 25
			address2  	C 25
			city  			C 25
			state  			C  2
			zip  				C  5
			phone  			C 12
			fax  				C 12
			contact 		C 25

In addition to the normal faxes, we send attachment files that have been previously stored
in the WINFAX\DATA directory. (We just faxed them into the computer.)  So every time our fax
refers to a certain product, we wanted FoxPro to also send any attachment file that might
apply.  So we have a PRODUCT table and an ATTACH table:

		PRODUCT.DBF
			product_id 	C 10
			prod_descr 	C	30

		ATTACH.DBF
			product_id	C 10
			attachment  C 12	***  Actual file name of the attachment  ***

So a product can have none, one, or many attachment files associated with it


The mission is to fax several reports to the same location, include attachments, and put a cover
sheet on the whole thing.  The program flow is:

	*	Find a fax to send, and determine the location (recipient)
	* Generate separate reports for however many records are flagged to fax to the recipient
	* Add stock attachments at the end of the fax
	* Generate a cover page report that tells the recipient what's coming

ENDTEXT
ENDIF

************************************************************************************************
*
*														AND FINALLY, THIS IS THE CODE!!
*
************************************************************************************************

* Select the WINFAX printer driver as the default
* This routine is available on Compuserve as WINPRT.ZIP
=PRINTSEL([WINFAX])

* Let's put in a loop to keep looking for faxes until we say stop
m.DieNow = []
DO WHILE DieNow <> [Q]
  =FindRecip()																						&& This is the driver!
  WAIT WINDOW TIMEOUT 5 [Press 'Q' to quit...] TO DieNow
ENDDO
RETURN

*--------------------------------------------------------------*
PROCEDURE FindRecip
*	Look for a 'SendFax' flag, which is a numeric field in SHIPMENT
*	A 1 in SendFax means to send it, a 2 means it was sent
* ummm - this is just a sample, okay?

SELECT Shipment
LOCATE FOR SendFax = 1

* Since we have an index in the Location table, we can get the carrier ID
* There's no need for validation, since the info came from there to begin with
*	We already know it's there
=SEEK(Shipment.Carrier,[Location])

* Now let's get all records to fax for that carrier
SCAN FOR Shipment.Carrier = Location.LocationID AND ;
    Shipment.SendFax = 1
  * Send a DDE signal to Winfax so it knows what to do with what's coming
  * it schedules the fax for 23:59:00 on 12/31/99
  =DummyFax()
  * Now send the report to Winfax, where it's created and just waits
  REPORT FORM Alert TO PRINT NOCONSOLE
  * Now get the attachments that go with this shipment
  =GetAttach(Shipment.Shipment)
  * This completes the operation on this record, so change the SendFax flag
  REPLACE Shipment.SendFax WITH 2
ENDSCAN


* Finally, do the cover sheet
=MakeCover
SELECT Location
REPORT FORM Cover NEXT 1 TO PRINT NOCONSOLE


*--------------------------------------------------------------*
PROCEDURE DummyFax
* Create fax information memvars for Winfax, and 
* schedule the fax to be sent 12/31/99 at 23:59:00
m.contact 		= Location.contact
m.FAXNUMBER 	= Location.fax
m.Keywords  	= [Alert]
m.Billingcd 	= Shipment.shipment

* Poke the dummy fax info before each report.
jcRun = '=DDEPoke(m.channum,"sendfax",[recipient("' + m.Faxnumber+ ;
  '",[23:59:59],"12/31/99",' + ',' + m.CONTACT + ',' +  m.Keywords + ',' + 'm.Billingcd)])'
&jcRun


*--------------------------------------------------------------*
PROCEDURE GetAttach
*	To attach instruction sheets to end of each alert
PARAMETERS cShipment

** Select instruction attachments, and put
** them into an array to be handled below
SELECT DISTINCT ;
  Attach.product_id , ;
  Attach.attachment ;
  FROM Attach, Shipitem ;
  WHERE UPPER(Shipitem.product_id) = UPPER(Attach.product_id);
  AND Shipitem.shipment = cShipment ;
  INTO ARRAY laAttach

* Should any records exist, so will the array
IF TYPE([laAttach]) <> [U]
  FOR MakeAttach = 1 TO ALEN(laAttach,1)
    ** Poke the files from array - note that the C drive is hard-coded here!
    cAttFile = [C:\WINFAX\DATA\]+ALLTRIM(laAttach[MakeAttach,2])
		* Make sure that the file exists to avoid a DDE error that
		* stops WinFax dead in it's tracks waiting for user input
    IF FILE(cAttfile)
      jcRun = '=DDEPoke(m.channum,"Sendfax",[attach("' + cAttFile  + '")])'
    ELSE
    	* We log an error here, but do whatever you like
      WAIT WIND [Attachement: ] +cAttfile + [ not found] TIMEOUT 5
    ENDIF
    &jcRun
  ENDFOR
ENDIF


*--------------------------------------------------------------*
PROCEDURE MakeCover
*--------------------------------------------------------------*
* This is where we assemble the "cover page" to tell the recipient
* what's coming.  This is the REAL fax

m.FAXNUMBER = Location.fax
m.COMPANY   = Location.name
m.contact 	= location.contact
m.Recipient = location.Recipient
m.Subject 	= [Shipment Alert]
m.billingCd = []
m.Keywords   = [Sent: ] + DTOS(DATE()) + [ ] + TIME()

* DDE Info for WINFAX
* Create DDEPoke string to send to Winfax
* PLEASE NOTE THAT 'recipient' _MUST_ BE ALL lowercase!!
m.pokestring = [recipient(] + CHR(34)  + ;
  ALLTRIM(m.Faxnumber)  + CHR(34) + [,] + CHR(34) + ;
  TIME()                + CHR(34) + [,] + CHR(34) + ;
  DTOC(DATE())    	    + CHR(34) + [,] + CHR(34) + ;
  ALLTRIM(m.Contact )   + CHR(34) + [,] + CHR(34) + ;
  ALLTRIM(m.Recipient ) + CHR(34) + [,] + CHR(34) + ;
  ALLTRIM(m.Subject  )  + CHR(34) + [,] + CHR(34) + ;
  ALLTRIM(m.Keywords )  + CHR(34) + [,] + CHR(34) + ;
  ALLTRIM(m.BillingCd)  + CHR(34) + [)]
m.ShowSend=DDEPOKE( m.Channum, 'Sendfax', 'showsendscreen("0")' )
m.Poked=DDEPOKE( m.Channum, 'Sendfax', m.PokeString )

*--------------------------------------------------------------*
* Now check the WinFax\Data directory for fax image files that
* were created between the times recorded above.
* Thanks to Ed Leafe for this sequence!
*
jcTime2=TIME()
DIMENSION jaFaxFiles[1,5]
=ADIR(jaFaxFiles,"C:\WINFAX\DATA\*.FX?")
IF !EMPTY(jaFaxFiles[1,1])
  jnLen = ALEN(jaFaxFiles,1)
  FOR jnCnt = 1 TO jnLen
    * Prepend the 0 if time is before 10:00 AM ****** NOTE: ANAMOLY IN ADIR!!! ******
    jaFaxFiles[jnCnt,4] = STRTRAN(jaFaxFiles[jnCnt,4],[ ], [0])
    IF (jaFaxFiles[jnCnt,3]=DATE()) AND (jaFaxFiles[jnCnt,4]>=jcTime1) ;
        AND (jaFaxFiles[jnCnt,4]<=jcTime2)
      * This is a file we need; attach it.
      jcFile = "C:\WINFAX\DATA\" + jaFaxFiles[jnCnt,1]
      jcRun = '=DDEPoke(m.channum,"Sendfax",[attach("' + jcFile + '")])'

      &jcRun
    ENDIF
  ENDFOR
ENDIF
