*-- PROGRAM: E_LOG10.PRG
*--------------------------------------------------------------------
*-- Programmer : Peter Ripaldi
*--            : Borbbs = Dbpete *  CIS = 70711,3420 * 1-508-683-4987
*-- Date       : 04/09/92
*-- Notes      : Program to produce an error log on disk that is about
*--            : 7k long. The idea is to provide as much information as
*--            : possible about the system at the time of the error. On
*--            : error you can print the screen to printer and/or disk
*--            : if you uncomment the section(s). The error log on
*--            : disk is called E_ERROR.LOG, each error session will
*--            : add to the bottom of the previous error.
*--            : There are no functions for Dbase 1.5 yet.
*--            : Any suggestion to add, or if it helps
*--            : let me know. Happy Erroring ?
*--            :
*-- Written for: dBase IV 1.1
*-- Rev. Hist. : 04/09/92 1.0 - none-  format from E_LOG.PRG
*-- Calls      : PRINTSCR.BIN  Prints screen to printer if uncommented
*--            : SCREEN.BIN    Prints screen to disk if uncommented
*-- Called by  : Any
*-- Example    : First set up error trapping in main program with
*--            : ON ERROR DO Er_Log WITH error(),lineno(),program(),;
*--            : alias(),memory()
*-- Returns    : None
*-- Parameters : error(),lineno(),program(),alias(),memory()
*
***********************************************************
PROCEDURE Er_log
PARAMETER E_error,E_lineno,E_program,E_alias,E_memory
* Try to bring in as much of system before loading anything else

* talk off so answers to IIF() dont go in e_error.log file
SET TALK OFF

* set up disk file E_ERROR.LOG
SET ALTERNATE TO

* If already there add to it, incase of more errors next time runs
IF FILE("e_error.log")
   SET ALTERNATE TO E_ERROR.LOG ADDITIVE
ELSE
   * If not there make one
   SET ALTERNATE TO E_ERROR.LOG
ENDIF && FILE("e_error.log")

* Turn on e_error.log file
SET ALTERNATE ON

* Turn screen off
SET CONSOLE OFF

* set date to 19xx format
SET CENTURY ON

* Begin error logging information to disk
*
* Set up heading
? "=========================================================================="
? "=====                   Begin Errors Found                           ====="
? "====="
?? SPACE(10)+CDOW(DATE())+SPACE(10)+MDY(DATE())+SPACE(10)+(TIME())
?? "  ====="
? "=========================================================================="
?
? " Error / Program Information"
? "------------------------------"
? "    Error #      : " + LTRIM(STR(E_error)) +"  "+ MESSAGE()
? "    In Program   : " + E_program
? "    On Line #    : " + LTRIM(STR(E_lineno))
?
?

? " System Information"
? "------------------------------"
? "    Memory          : " + LTRIM(STR(E_memory))
? "    Diskspace       : " + LTRIM(STR(DISKSPACE()))
? "    Path            : " + GETENV("path")
? "    Prompt          : " + GETENV("prompt")
? "    ComSpec         : " + GETENV("comspec")
? "    Operating Sys   : " + LTRIM(OS())
? "    Dbase Version   : " + LTRIM(VERSION(0))
? "    Compile Error   : " + LTRIM(STR(CERROR()))
?
?

* Set up logical to yes and no
E_found  = IIF(FOUND(),"Yes","No")
E_eof    = IIF(EOF(),"Yes","No")
E_delete = IIF(DELETED(),"Yes","No")


? "  Database File Information "
? "------------------------------"
? "    DBF File        : " + DBF()
? "    Alias Name      : " + E_alias
? "    Order           : " + ORDER()
? "    Record #        : " + LTRIM(STR(RECNO()))
? "    Deleted         : " + LTRIM(E_delete)
? "    Record Count    : " + LTRIM(STR(RECCOUNT()))

* record size may not be right add 35 for header if wanted
? "    Record Size     : " + LTRIM(STR(RECSIZE()))
? "    Last Update     : " + DTOC(LUPDATE())
? "    Last Seek Found : " + LTRIM(E_found)
? "    End Of File     : " + LTRIM(E_eof)
?
?

* Set up logical to character yes and no
E_network  = IIF(NETWORK(),"Yes","No")
E_change   = IIF(CHANGE(),"Yes","No")
E_complete = IIF(COMPLETED(),"Yes","No")
E_rollback = IIF(ROLLBACK(),"Yes","No")
E_mark     = IIF(ISMARKED(),"Yes","No")

? " File / User / Network  Information"
? "------------------------------"
? "    On Network             : " + LTRIM(E_network)
? "    DBF in state of change : " + LTRIM(E_mark)
? "    User Access Level      : " + LTRIM(STR(ACCESS()))
? "    User Name              : " + USER()
? "    Changed by others      : " + LTRIM(E_change)
? "    Completed Transaction  : " + LTRIM(E_complete)
? "    Rollback  Successful   : " + LTRIM(E_rollback)
?
?
? " List of Users  "
? "--------------------------------"
LIST USERS
?
?
? " Screen Information "
? "------------------------------"
? "    Window        : " + WINDOW()
? "    Pad           : " + PAD()
? "    Popup         : " + POPUP()
? "    Bar #         : " + LTRIM(STR(BAR()))
? "    Prompt        : " + PROMPT()
? "    Menu          : " + MENU()
? "    Cursor Row    : " + LTRIM(STR(ROW()))
? "    Cursor Column : " + LTRIM(STR(COL()))
?
?

? " Key Stroke Information "
? "------------------------------"
? "    Varread       : " + VARREAD()
? "    Inkey         : " + LTRIM(STR(INKEY()))
? "    Lastkey       : " + LTRIM(STR(LASTKEY()))
? "    Readkey       : " + LTRIM(STR(READKEY()))
?

* Set up logical to yes and no
E_prtstat = IIF(PRINTSTATUS(),"On","Off")
? " Printer Information "
? "------------------------------"
? "    Print Status     : " + LTRIM(E_prtstat)
? "    Print Column     : " + LTRIM(STR(PCOL()))
? "    Print Row        : " + LTRIM(STR(PROW()))
?
?

* List  Status, Memory, History .....
? " Status Listing "
? "----------------------------------------------"
?
?
LIST STATUS

? " Memory Listing "
? "----------------------------------------------"
? " Variables beginning with  E_xxxxxx  from Error Program"
?
?
LIST MEMORY
?
?

? " History Listing "
? "------------------------------------------------"
LIST HISTORY
?
?
* End of errors for this time
? "=========================================================================="
? "=====                  End of Errors Found                           ====="
? "====="
?? SPACE(10)+CDOW(DATE())+SPACE(10)+MDY(DATE())+SPACE(10)+(TIME())
?? "  ====="
? "=========================================================================="
* spaces to seperate error log for next time error happens
?
?
?
?
* All done with saving file close up error file
SET ALTERNATE OFF
SET ALTERNATE TO
SET CONSOLE ON
SET CENTURY OFF

* If you have someone that will be using special forms, or checks
* they might get upset if you print over them.
*
* Option to print screen on printer or print screen to file
*
* Uncomment to print to printer or disk, or both
* Print Screen First, uses printscr.bin
* load printscr
* call printscr
* release module printscr

* Print screen to disk,  uses screen.bin
* load screen
* call screen with "a", "tscreen.txt"
* release module screen

* For real fun use one of KenMayer's "Death March" Songs
* Alert user for heart attack, Give a tone
SET BELL TO 500,5
?? CHR(7)
SET BELL TO 400,4
?? CHR(7)
SET BELL TO 500,5
?? CHR(7)
SET BELL TO 400,5
?? CHR(7)
SET BELL TO 500,5
?? CHR(7)
SET BELL TO

* Give user message
* sample message inspired by movie China Syndrome
CLEAR
@ 10,10 SAY "An unscheduled event has happened."
@ 12,10 SAY "The information was stored to disk. "
@ 14,10 SAY "Notify Peter at     1-508-683-4987   "
@ 16,10 SAY "You are being returned to the main menu "
@ 18,10 SAY "Please start over........."
@ 20,10 SAY " This means all your work is gone ....... HA HA "

* uncomment your choice
* Wait a few seconds and exit, or wait until user see's message
*
* wait a few seconds and exit
* e_wait = inkey(5)
*
* Wait until user sees message
WAIT

* uncomment your choice(s) below,
* if you do nothing your program will continue after writting error
*
* Future option to view e_error.log file in window for developing
* For testing
* edit in window
* modify file e_error.log

* Clean up, continue or restart program from beginning if needed
* CLOSE ALL
* CLEAR ALL

* If want to continue program release the variables that the
* error program made
* RELEASE ALL LIKE E_

* If want to end and close up release everything
* RELEASE ALL

* Call your main program to restart the application if wanted
* DO <your program here>

* Quit the program
* Quit

* Prevent Recursion
ON ERROR
RETURN
* EOP E_Log.prg
****************************
