* Program...: EntPrg.PRG
* Author....: Tom Woodward
* Date......: Sep 15, 1989
* Notes.....: This is mainly a file of procedures that will simulate
*             EDIT while working on variables instead of fields.

SET TALK OFF
CLEAR

*--- READKEY() Code Definitions.
PgDn1  =   7    && PgDn, no update.
PgDn2  = 263    && PgDn, with update.
PgUp1  =   6    && PgUp, no update.
PgUp2  = 262    && PgUp, with update.
CtrlW  = 270    && Ctrl-W or Ctrl-End.
Rtrn1  =  15    && Return or Enter, no update.
Rtrn2  = 271    && Return or Enter, with update.
Escape =  12    && Escape.
UpAr1  =   4    && Up Arrow, no update.
UpAr2  = 260    && Up Arrow, with update.
DnAr1  =   5    && Down Arrow, no update.
DnAr2  = 261    && Down Arrow, with update.
CtlUp1 =  34    && Ctrl-PgUp, no update.
CtlUp2 = 290    && Ctrl-PgUp, with update.
CtlDn1 =  35    && Ctrl-PgDn, no update.
CtlDn2 = 291    && Ctrl-PgDn, with update.

*--- Define Main Menu.
DEFINE POPUP Choice FROM 2,5 TO 8,20
DEFINE BAR 1 OF Choice PROMPT "Employee Entry" SKIP
DEFINE BAR 2 OF Choice PROMPT "" SKIP
DEFINE BAR 3 OF Choice PROMPT "1. Append"
DEFINE BAR 4 OF Choice PROMPT "2. Edit"
DEFINE BAR 5 OF Choice PROMPT "Q. Quit"
ON SELECTION POPUP Choice DO EntInfo

*--- Main Routine.
USE Customer ORDER CustNo

PUBLIC M->CustNo, M->FirstName, M->LastName, M->Company, M->Address,;
       M->City, M->State, M->Zip, M->Phone, AppeRec, Deletes

*--- Start Main Menu.
ACTIVATE POPUP Choice
RELEASE POPUP Choice

*--- To save execution time, only pack the database if any deletes
*    have taken place.

IF Deletes > 0
	PACK
ENDIF
CLEAR ALL
RETURN
*--- End of Main Routine.


PROCEDURE EntInfo
	*--- Entry Routine.  This is the driving engine of the program called by
	*    the main menu.
	CLEAR
	
	UserChoice=PROMPT()
	IF UserChoice = "Q. Quit"
		DEACTIVATE POPUP
	ELSE
		IF UserChoice="1. Append"
			DO NewVars       && Initialize Entry Variables.
			AppeRec = .T.    && Set Appending Flag.
		ELSE
			*--- Edit Customer Number Menu Definition.
			DEFINE POPUP Customer FROM 2,5 TO 15, 11 PROMPT FIELD CustNo
			ON SELECTION POPUP Customer DEACTIVATE POPUP

			@ 1, 5 SAY "Choose Customer # to Edit:"
			ACTIVATE POPUP Customer
			SEEK PROMPT()
			DO InitVars     && Store field values to entry variables.
			RELEASE POPUP Customer
			RELEASE MReturn
			AppeRec = .F.   && Clear Append Flag.
			CLEAR
		ENDIF
		
		Deletes = 0        
		*--- Define "ON KEY" routine which simulates the delete operation in 
		*    edit mode (activated by a Ctrl-U).
		ON KEY LABEL CTRL-U DO DelRec    
		DO WHILE .T.
			DO MakeScr      && Get Info from User.
			DO CASE
				*--- PgDn, Arrows and Return should all advance the record
				*    pointer one record.
				CASE READKEY()= PgDn1 .OR. READKEY()= PgDn2 .OR.  ;
				     READKEY()= Rtrn1 .OR. READKEY()= Rtrn2 .OR.  ;          
				     READKEY()= DnAr1 .OR. READKEY()= DnAr2
					IF AppeRec          && If this was a new record.
						IF READKEY() > Rtrn1     && If new record was updated.
					    	APPEND BLANK
						ELSE    && Assume user is finished.
							EXIT 
						ENDIF
					ENDIF
					DO ReplFlds   && Replace fields with entry variables.
					SKIP          && Page Down.
					IF .NOT.EOF()
						DO InitVars     && Store new fields to entry vars.
					ELSE          && If EOF()
						IF UserChoice = "2. Edit"   && If we are in edit mode.
							CLEAR
							mChoice = .T.
							CLEAR GETS
					    	?         && Top Margin
							*--- See if they want to switch to append mode.
							WAIT "At End of file. Add New Records (Y/N)? " ;
						     	TO mChoice
							CLEAR
	
							IF UPPER(mChoice) = "Y"
					       			AppeRec = .T.       && Set Append Flag
								UserChoice = "1. Append"  && Switch to Append Mode
								DO NewVars          && Initialize Entry Variables
							ELSE             && mChoice = "N"
								SKIP -1             && Get off of EOF Record
							ENDIF
						ELSE                    && User Choice = "1. Append"
							AppeRec = .T.         && Set Append Flag
							DO NewVars            && Initialize Entry Variables
						ENDIF
					ENDIF
					
				*--- PgUp and Up Arrow should retract record pointer 1 record.
				CASE READKEY()= PgUp1 .OR. READKEY()= PgUp2 .OR. ;           
					 READKEY()= UpAr1.OR. READKEY()= UpAr2
					IF .NOT.BOF()
						Replc = .T.   && Flag that decides if fields are replaced
						IF AppeRec              && If this was a new record
							IF READKEY()>PgUp1         && If new record was updated.
		
								APPEND BLANK
							ELSE             && If record wasn't updated
								GO BOTTOM           && Go back to last rec in DBF
								Replc = .F.         && Don't bother replacing info.
							ENDIF
						ENDIF
						IF Replc
							DO ReplFlds
							SKIP -1               && Page Up.
						ENDIF
						DO InitVars
						AppeRec = .F.           && Clear Append Flag
					ELSE                 && If BOF()
						??CHR(7)           && Alarm User
					ENDIF
				
				*--- Ctrl-PgUp should move record pointer to the first record in the file.
				CASE READKEY()=CtlUp1 .OR. READKEY()=CtlUp2
					IF AppeRec
						APPEND BLANK
					ENDIF
					DO ReplFlds
					GO TOP
					DO InitVars
					AppeRec = .F.
				
				*--- Ctrl-PgDn should move record pointer to the last record in the file.
				CASE READKEY()=CtlDn1 .OR. READKEY()=CtlDn2
					IF AppeRec
						APPEND BLANK
					ENDIF
					DO ReplFlds
					GO BOTTOM
					DO InitVars
					AppeRec = .F.
				
				*--- Ctrl-W/Ctrl-End should save information and exit.
				CASE READKEY()=CtrlW 
					IF AppeRec
						APPEND BLANK
					ENDIF
					DO ReplFlds
					EXIT
				
				*--- Escape should abandon and exit.
				CASE READKEY()=Escape
					EXIT
			ENDCASE
		ENDDO
	ENDIF
	CLEAR
RETURN


PROCEDURE DelRec
	* Delete Procedure.
	* This procedure, called when a Ctrl-U is struck, is responsible
	* for simulating the Ctrl-U keystroke in Edit mode. 
	
	IF .NOT.AppeRec              && If we are not in append mode (the record
	                             && info already has a record created.
		IF DELETED()                && If the record has already been deleted
			RECALL                   && toggle its status back to Un-Deleted.
			@ 22,70 SAY "       "    && Clear the "Deleted" marker from the screen.
			Deletes = Deletes - 1    && Decrement number of deleted count
		ELSE                     && If it is not deleted, mark it for deletion.
			DELETE
			@ 22,70 SAY "Deleted"
			Deletes = Deletes + 1
		ENDIF
	ENDIF
RETURN


PROCEDURE InitVars
	* Variable Storage Procedure.
	* This procedure is responsible for storing the field values for
	* the current record to the entry variables.
	
	Countr = 1
	DO WHILE LEN(TRIM(FIELD(Countr))) <> 0   && While there are Fields.
		VarName = "M->" + FIELD(Countr)
		FldName = FIELD(Countr)
		&VarName = &FldName              && Store field to entry variable.
		Countr = Countr + 1              && Go to next field.
	ENDDO
RETURN


PROCEDURE ReplFlds
	* Field Replacement Procedure.
	* This procedure is responsible for the replacement of the fields
	* for the current record with the entry variables.
	
	Countr = 1
	DO WHILE LEN(TRIM(FIELD(Countr))) <> 0   && While there are fields.
		VarName = "M->"+FIELD(Countr)         
		FldName = FIELD(Countr)
		REPLACE &FldName WITH &VarName   && Replace field with entry variables.
		Countr = Countr + 1              && Go to next field.
	ENDDO
RETURN


PROCEDURE NewVars
	* Variable Initialization Procedure.
	* This Procedure is responsible for initializing the entry
	* variables when a record is being added.  Default values, Carry
	* vorward vields, as well as Calculated predefined fields from 
	* previously entered records are demonstrated here. 
	
	M->FirstName = SPACE(15)
	M->LastName = SPACE(15)
	M->Phone = SPACE(18)
	
	* Default Value Field.
	M->State = "CA"
	
	* Carry Forward Fields.
	IF .NOT. BOF()
		GO BOTTOM
		M->CustNo = REPLICATE("0", 4 -LEN(LTRIM(STR(VAL(CustNo) +1, 4)))) ;
		          + LTRIM(STR(VAL(CustNo) +1, 4))
		M->City = City
		M->Zip = Zip
		M->Company = Company
		M->Address = Address
	ELSE
		M->CustNo = "0001"
		M->City = SPACE(15)
		M->Zip = SPACE(10)
		M->Company = SPACE(20)
		M->Address = SPACE(40)
	ENDIF
	
RETURN

PROCEDURE MakeScr
	* Get Screen Drawing Procedure.
	* This procedure works similarly to a format file in getting 
	* information from the user.  It is called after the record pointer
	* has been positioned and it has been determined that the user 
	* would like to continue data processing.
	
	
	@  1,30 SAY "CUSTOMER ENTRY SCREEN"
	@  2, 3 TO 9, 76 DOUBLE            && Draw Box.
	@  3, 5 SAY "Customer Number: "
	@  3,30 SAY M->CustNo PICTURE "9999"    && Cust# predefined/Read-Only.
	@  4, 5 SAY "Customer Name:"
	@  4,30 GET M->FirstName
	
	@  4,46 GET M->LastName
	@  5, 5 SAY "Company:"
	@  5,30 GET M->Company
	@  6, 5 SAY "Address:"
	@  6,30 GET M->Address
	@  7,30 GET M->City
	@  7,46 GET M->State
	@  7,49 GET M->Zip PICTURE "99999-9999"
	@  8, 5 SAY "Phone:"
	@  8,30 GET M->Phone PICTURE "(999)999-9999X9999"
	@ 22,70 SAY IIF(DELETED(),"Deleted","") && "Deleted marker".
	READ
RETURN
* EoF: EntPrg.PRG
                                                                             