procedure ChrTran
parameters m_text,m_table,m_trans
	*** Parameters ***
	* m_text is the text to be translated - Type: C
	* m_table is the table of translatable things - Type: C
	* m_trans is what to translate things into - type: C

	*** Local Variables ***
	* m_len is the length of m_text - type: N
	* m_pos is the position in the text we are at - Type: N
	* m_char is the character we are working with in text - Type: C
	* m_intable is where character is in table to be translated - Type: N
	* m_lentran is the length of the translation table - type: N
	* m_newchr is the new character - Type: C
	PRIVATE m_len, m_pos, m_char, m_intable, m_lentran, m_newchr
	m_len = 0
	m_pos = 1
	m_char = ""
	m_intable = 0
	m_lentran = 0
	m_newchr = ""
	
	m_len = len(m_text)
	m_lentran = len(m_trans)
	do while (m_pos <= m_len)
		m_char = substr(m_text,m_pos,1)
		m_intable = at(m_char,m_table)
		if (m_intable > 0)
			m_newchr = IIF(m_intable > m_lentran, "", SUBSTR(m_trans,m_intable,1))
		else
			m_newchr = m_char
		endif
		m_text = STUFF(m_text,m_pos,1,m_newchr)
		m_pos = IIF(LEN(m_newchr) = 0, m_pos, m_pos+1)
		m_len = LEN(m_text)
	enddo
	return (m_text)

procedure Encode
parameters m_text, m_key
	*** Local Variables ***
	* m_string1 is the first translation string set
	* m_string2 is the second translation string set
	* m_rotate is the # times to rotate the string
	* m_length is the length of the key
	* m_coded is the encoded string
	private m_string1, m_string2, m_rotate, m_length, m_coded
	m_string1 = "thequickbrownfxjmpsvlazydgTHEQUICKBROWNFXJMPSVLAZYDG `1234567890-=[]\;,./~!@#$%^&*()_+{}|:<>?!(tm)ss*-oee(R)ueipia(C)n"
	m_string2 = " `1234567890-=[]\;,./~!@#$%^&*()_+{}|:<>?!(tm)ss*-oee(R)ueipia(C)nabcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"
	m_rotate = 0
	m_length = len(m_key)
	m_coded = ""

	do while (len(m_key) > 0)
		m_rotate = int(asc(left(m_key,1))/m_length)
		m_key = right(m_key,len(m_key)-1)
		do while (m_rotate > 0)
			m_string1 = right(m_string1,129)+left(m_string1,1)
			m_rotate = m_rotate - 1
		enddo
	enddo
	m_coded = ChrTran(m_text,m_string1,m_string2)
	return (m_coded)

procedure Decode
parameters m_text, m_key
	*** Local Variables ***
	* m_string1 is the first translation string set
	* m_string2 is the second translation string set
	* m_rotate is the # times to rotate the string
	* m_length is the length of the key
	* m_coded is the decoded string
	private m_string1, m_string2, m_rotate, m_length, m_coded
	m_string1 = "thequickbrownfxjmpsvlazydgTHEQUICKBROWNFXJMPSVLAZYDG `1234567890-=[]\;,./~!@#$%^&*()_+{}|:<>?!(tm)ss*-oee(R)ueipia(C)n"
	m_string2 = " `1234567890-=[]\;,./~!@#$%^&*()_+{}|:<>?!(tm)ss*-oee(R)ueipia(C)nabcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"
	m_rotate = 0
	m_length = len(m_key)
	m_coded = ""

	do while (len(m_key) > 0)
		m_rotate = int(asc(left(m_key,1))/m_length)
		m_key = right(m_key,len(m_key)-1)
		do while (m_rotate > 0)
			m_string1 = right(m_string1,129)+left(m_string1,1)
			m_rotate = m_rotate - 1
		enddo
	enddo
	m_coded = ChrTran(m_text,m_string2,m_string1)
	return (m_coded)
